"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PluginStatement = PluginStatement;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _format_number = require("../../../../lib/format_number");
var _metric = require("./metric");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const pluginStyle = ({
  euiTheme
}) => (0, _react2.css)`
  ${(0, _eui.logicalCSS)('margin-left', euiTheme.size.xs)}
`;
const pluginStatementStyle = ({
  euiTheme
}) => (0, _react2.css)`
  ${(0, _eui.logicalCSS)('padding-left', euiTheme.size.m)}
`;
function getInputStatementMetrics({
  latestEventsPerSecond
}) {
  return [/*#__PURE__*/_react.default.createElement(_metric.Metric, {
    key: "eventsEmitted",
    type: "eventsEmitted",
    value: (0, _format_number.formatMetric)(latestEventsPerSecond, '0.[00]a', 'e/s emitted')
  })];
}
function getProcessorStatementMetrics(processorVertex) {
  const {
    latestMillisPerEvent,
    latestEventsPerSecond,
    percentOfTotalProcessorTime
  } = processorVertex;
  return [/*#__PURE__*/_react.default.createElement(_metric.Metric, {
    key: "cpuMetric",
    type: "cpuTime",
    warning: processorVertex.isTimeConsuming(),
    value: (0, _format_number.formatMetric)(Math.round(percentOfTotalProcessorTime || 0), '0', '%', {
      prependSpace: false
    })
  }), /*#__PURE__*/_react.default.createElement(_metric.Metric, {
    key: "eventMillis",
    type: "eventMillis",
    warning: processorVertex.isSlow(),
    value: (0, _format_number.formatMetric)(latestMillisPerEvent, '0.[00]a', 'ms/e')
  }), /*#__PURE__*/_react.default.createElement(_metric.Metric, {
    key: "eventsReceived",
    type: "events",
    value: (0, _format_number.formatMetric)(latestEventsPerSecond, '0.[00]a', 'e/s received')
  })];
}
function renderPluginStatementMetrics(pluginType, vertex) {
  return pluginType === 'input' ? getInputStatementMetrics(vertex) : getProcessorStatementMetrics(vertex);
}
function PluginStatement({
  statement: {
    hasExplicitId,
    id,
    name,
    pluginType,
    vertex
  },
  onShowVertexDetails
}) {
  const statementMetrics = renderPluginStatementMetrics(pluginType, vertex);
  const onNameButtonClick = () => {
    onShowVertexDetails(vertex);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    css: pluginStatementStyle,
    gutterSize: "none",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": `pluginStatement-${pluginType}-${name}-EmptyButton`,
    "aria-label": name,
    color: "primary",
    css: pluginStyle,
    flush: "left",
    iconType: "dot",
    onClick: onNameButtonClick,
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("span", null, name))), hasExplicitId && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    "data-test-subj": `pluginStatement-${pluginType}-${name}-Badge`,
    onClick: onNameButtonClick,
    onClickAriaLabel: _i18n.i18n.translate('xpack.monitoring.logstash.pipelineStatement.viewDetailsAriaLabel', {
      defaultMessage: 'View details'
    })
  }, id)))), statementMetrics && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, statementMetrics)));
}