"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Expression = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _alert_param_duration = require("../flyout_expressions/alert_param_duration");
var _enums = require("../../../common/enums");
var _alert_param_percentage = require("../flyout_expressions/alert_param_percentage");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Expression = props => {
  const {
    ruleParams,
    paramDetails,
    setRuleParams,
    errors
  } = props;
  const alertParamsUi = Object.keys(ruleParams).map(alertParamName => {
    const details = paramDetails[alertParamName];
    const value = ruleParams[alertParamName];
    switch (details === null || details === void 0 ? void 0 : details.type) {
      case _enums.AlertParamType.Duration:
        return /*#__PURE__*/_react.default.createElement(_alert_param_duration.AlertParamDuration, {
          key: alertParamName,
          name: alertParamName,
          duration: value,
          label: details.label,
          errors: errors[alertParamName],
          setRuleParams: setRuleParams
        });
      case _enums.AlertParamType.Percentage:
        return /*#__PURE__*/_react.default.createElement(_alert_param_percentage.AlertParamPercentage, {
          key: alertParamName,
          name: alertParamName,
          label: details.label,
          percentage: value,
          errors: errors[alertParamName],
          setRuleParams: setRuleParams
        });
    }
  });
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form"
  }, alertParamsUi), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
};

// for lazy loading
// eslint-disable-next-line import/no-default-export
exports.Expression = Expression;
var _default = exports.default = Expression;