"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CategorizationDetectorsSummary = void 0;
var _react = _interopRequireWildcard(require("react"));
var _job_creator_context = require("../../../job_creator_context");
var _event_rate_chart = require("../../../charts/event_rate_chart");
var _top_categories = require("./top_categories");
var _category_stopped_partitions = require("./category_stopped_partitions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DTR_IDX = 0;
const CategorizationDetectorsSummary = () => {
  const {
    jobCreator: jc,
    chartLoader,
    resultsLoader,
    chartInterval
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const jobCreator = jc;
  const [loadingData, setLoadingData] = (0, _react.useState)(false);
  const [anomalyData, setAnomalyData] = (0, _react.useState)([]);
  const [eventRateChartData, setEventRateChartData] = (0, _react.useState)([]);
  const [jobIsRunning, setJobIsRunning] = (0, _react.useState)(false);
  function setResultsWrapper(results) {
    const anomalies = results.anomalies[DTR_IDX];
    if (anomalies !== undefined) {
      setAnomalyData(anomalies);
    }
  }
  function watchProgress(progress) {
    setJobIsRunning(progress > 0);
  }
  (0, _react.useEffect)(() => {
    // subscribe to progress and results
    const resultsSubscription = resultsLoader.subscribeToResults(setResultsWrapper);
    jobCreator.subscribeToProgress(watchProgress);
    loadChart();
    return () => {
      resultsSubscription.unsubscribe();
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  async function loadChart() {
    setLoadingData(true);
    try {
      var _jobCreator$runtimeMa;
      const resp = await chartLoader.loadEventRateChart(jobCreator.start, jobCreator.end, chartInterval.getInterval().asMilliseconds(), (_jobCreator$runtimeMa = jobCreator.runtimeMappings) !== null && _jobCreator$runtimeMa !== void 0 ? _jobCreator$runtimeMa : undefined, jobCreator.datafeedConfig.indices_options);
      setEventRateChartData(resp);
    } catch (error) {
      setEventRateChartData([]);
    }
    setLoadingData(false);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_event_rate_chart.EventRateChart, {
    eventRateChartData: eventRateChartData,
    anomalyData: anomalyData,
    height: "300px",
    width: "100%",
    showAxis: true,
    loading: loadingData,
    fadeChart: jobIsRunning
  }), /*#__PURE__*/_react.default.createElement(_top_categories.TopCategories, null), /*#__PURE__*/_react.default.createElement(_category_stopped_partitions.CategoryStoppedPartitions, null));
};
exports.CategorizationDetectorsSummary = CategorizationDetectorsSummary;