"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.averageOfValues = averageOfValues;
exports.makeUnpackMetric = makeUnpackMetric;
exports.scaleUpPercentage = scaleUpPercentage;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function averageOfValues(values) {
  const sum = values.reduce((acc, value) => acc + value, 0);
  return sum / values.length;
}
function makeUnpackMetric(metricByField) {
  // Make sure metrics are accessed as row[metricByField['FIELD_NAME']]
  // Not row['FIELD_NAME'] by accident
  return (row, field) => row[metricByField[field]];
}
function scaleUpPercentage(unscaled) {
  // Scale e.g. 0.027 to 2.7
  return unscaled * 100;
}