"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeEditApi = initializeEditApi;
var _presentationPublishing = require("@kbn/presentation-publishing");
var _constants = require("../../common/constants");
var _kibana_services = require("../kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function initializeEditApi(uuid, getState, parentApi, savedObjectId) {
  return !parentApi || !(0, _presentationPublishing.apiHasAppContext)(parentApi) ? {} : {
    getTypeDisplayName: () => {
      return _constants.MAP_EMBEDDABLE_NAME;
    },
    onEdit: async () => {
      var _parentApiContext$get;
      const parentApiContext = parentApi.getAppContext();
      const stateTransfer = (0, _kibana_services.getEmbeddableService)().getStateTransfer();
      await stateTransfer.navigateToEditor(_constants.APP_ID, {
        path: (0, _constants.getEditPath)(savedObjectId),
        state: {
          embeddableId: uuid,
          valueInput: getState(),
          originatingApp: parentApiContext.currentAppId,
          originatingPath: (_parentApiContext$get = parentApiContext.getCurrentPath) === null || _parentApiContext$get === void 0 ? void 0 : _parentApiContext$get.call(parentApiContext)
        }
      });
    },
    isEditingEnabled: () => {
      return (0, _kibana_services.getMapsCapabilities)().save;
    },
    getEditHref: async () => {
      return (0, _kibana_services.getHttp)().basePath.prepend((0, _constants.getFullPath)(savedObjectId));
    }
  };
}