"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.emsWorldLayerId = exports.ZOOM_PRECISION = exports.WIZARD_ID = exports.VECTOR_STYLES = exports.VECTOR_SHAPE_TYPE = exports.TOP_TERM_PERCENTAGE_SUFFIX = exports.SYMBOLIZE_AS_TYPES = exports.STYLE_TYPE = exports.SPATIAL_FILTERS_LAYER_ID = exports.SOURCE_TYPES = exports.SOURCE_META_DATA_REQUEST_ID = exports.SOURCE_FORMATTERS_DATA_REQUEST_ID = exports.SOURCE_DATA_REQUEST_ID = exports.SOURCE_BOUNDS_DATA_REQUEST_ID = exports.SINGLE_SELECTION_AS_TEXT_PROPS = exports.SCALING_TYPES = exports.RENDER_TIMEOUT = exports.RENDER_AS = exports.POLYGON_COORDINATES_EXTERIOR_INDEX = exports.ORDINAL_DATA_TYPES = exports.OPEN_LAYER_WIZARD = exports.NO_EMS_LOCALE = exports.MVT_GETTILE_API_PATH = exports.MVT_GETGRIDTILE_API_PATH = exports.MVT_FIELD_TYPE = exports.MIN_ZOOM = exports.MIDDLE_TRUNCATION_PROPS = exports.META_DATA_REQUEST_ID_SUFFIX = exports.MB_SOURCE_ID_LAYER_ID_PREFIX_DELIMITER = exports.MB_LOOKUP_FUNCTION = exports.MAX_ZOOM = exports.MAX_DRAWING_SIZE_BYTES = exports.MASK_OPERATOR = exports.MAP_SAVED_OBJECT_TYPE = exports.MAP_PATH = exports.MAP_EMBEDDABLE_NAME = exports.MAPS_NEW_VECTOR_LAYER_META_CREATED_BY = exports.MAPS_APP_PATH = exports.MAKI_ICON_SIZE = exports.LON_INDEX = exports.LAYER_WIZARD_CATEGORY = exports.LAYER_TYPE = exports.LAYER_STYLE_TYPE = exports.LAT_INDEX = exports.LABEL_POSITIONS = exports.LABEL_BORDER_SIZES = exports.KBN_IS_CENTROID_FEATURE = exports.JOIN_FIELD_NAME_PREFIX = exports.INITIAL_LOCATION = exports.INITIAL_LAYERS_KEY = exports.INDEX_SOURCE_API_PATH = exports.INDEX_SETTINGS_API_PATH = exports.INDEX_FEATURE_PATH = exports.ICON_SOURCE = exports.HALF_MAKI_ICON_SIZE = exports.GRID_RESOLUTION = exports.GET_MATCHING_INDEXES_PATH = exports.GEO_JSON_TYPE = exports.GEOTILE_GRID_AGG_NAME = exports.GEOJSON_FEATURE_ID_PROPERTY_NAME = exports.GEOCENTROID_AGG_NAME = exports.FORMATTERS_DATA_REQUEST_ID_SUFFIX = exports.FONTS_API_PATH = exports.FIELD_ORIGIN = exports.FEATURE_VISIBLE_PROPERTY_NAME = exports.ES_GEO_FIELD_TYPES = exports.ES_GEO_FIELD_TYPE = exports.EMPTY_FEATURE_COLLECTION = exports.DRAW_SHAPE = exports.DRAW_MODE = exports.DEFAULT_PERCENTILES = exports.DEFAULT_PERCENTILE = exports.DEFAULT_MAX_RESULT_WINDOW = exports.DEFAULT_MAX_INNER_RESULT_WINDOW = exports.DEFAULT_MAX_BUCKETS_LIMIT = exports.DEFAULT_ICON = exports.DEFAULT_CUSTOM_ICON_RADIUS = exports.DEFAULT_CUSTOM_ICON_CUTOFF = exports.DECIMAL_DEGREES_PRECISION = exports.DATA_MAPPING_FUNCTION = exports.CUSTOM_ICON_SIZE = exports.CUSTOM_ICON_PREFIX_SDF = exports.COUNT_PROP_NAME = exports.COLOR_MAP_TYPE = exports.CHECK_IS_DRAWING_INDEX = exports.CATEGORICAL_DATA_TYPES = exports.AUTOSELECT_EMS_LOCALE = exports.APP_NAME = exports.APP_ID = exports.APP_ICON_SOLUTION = exports.APP_ICON = exports.AGG_TYPE = exports.AGG_DELIMITER = void 0;
exports.getEditPath = getEditPath;
exports.getFullPath = getFullPath;
exports.getNewMapPath = getNewMapPath;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAP_SAVED_OBJECT_TYPE = exports.MAP_SAVED_OBJECT_TYPE = 'map';
const APP_ID = exports.APP_ID = 'maps';
const APP_ICON = exports.APP_ICON = 'gisApp';
const APP_ICON_SOLUTION = exports.APP_ICON_SOLUTION = 'logoKibana';
const APP_NAME = exports.APP_NAME = _i18n.i18n.translate('xpack.maps.visTypeAlias.title', {
  defaultMessage: 'Maps'
});
const MAP_EMBEDDABLE_NAME = exports.MAP_EMBEDDABLE_NAME = _i18n.i18n.translate('xpack.maps.embeddableDisplayName', {
  defaultMessage: 'map'
});
const INITIAL_LAYERS_KEY = exports.INITIAL_LAYERS_KEY = 'initialLayers';
const MAPS_APP_PATH = exports.MAPS_APP_PATH = `app/${APP_ID}`;
const MAP_PATH = exports.MAP_PATH = 'map';
const GIS_INTERNAL_PATH = `internal/${APP_ID}`;
const INDEX_SETTINGS_API_PATH = exports.INDEX_SETTINGS_API_PATH = `/${GIS_INTERNAL_PATH}/indexSettings`;
const FONTS_API_PATH = exports.FONTS_API_PATH = `/${GIS_INTERNAL_PATH}/fonts`;
const INDEX_SOURCE_API_PATH = exports.INDEX_SOURCE_API_PATH = `/${GIS_INTERNAL_PATH}/docSource`;
const INDEX_FEATURE_PATH = exports.INDEX_FEATURE_PATH = `/${GIS_INTERNAL_PATH}/feature`;
const GET_MATCHING_INDEXES_PATH = exports.GET_MATCHING_INDEXES_PATH = `/${GIS_INTERNAL_PATH}/getMatchingIndexes`;
const CHECK_IS_DRAWING_INDEX = exports.CHECK_IS_DRAWING_INDEX = `/${GIS_INTERNAL_PATH}/checkIsDrawingIndex`;
const MVT_GETTILE_API_PATH = exports.MVT_GETTILE_API_PATH = `/${GIS_INTERNAL_PATH}/mvt/getTile`;
const MVT_GETGRIDTILE_API_PATH = exports.MVT_GETGRIDTILE_API_PATH = `/${GIS_INTERNAL_PATH}/mvt/getGridTile`;
const OPEN_LAYER_WIZARD = exports.OPEN_LAYER_WIZARD = 'openLayerWizard';

// Identifies centroid feature.
// Centroids are a single point for representing lines, multiLines, polygons, and multiPolygons
const KBN_IS_CENTROID_FEATURE = exports.KBN_IS_CENTROID_FEATURE = '__kbn_is_centroid_feature__';
const GEOJSON_FEATURE_ID_PROPERTY_NAME = exports.GEOJSON_FEATURE_ID_PROPERTY_NAME = '__kbn__feature_id__';
function getNewMapPath() {
  return `/${MAPS_APP_PATH}/${MAP_PATH}`;
}
function getFullPath(id) {
  return `/${MAPS_APP_PATH}${getEditPath(id)}`;
}
function getEditPath(id) {
  return id ? `/${MAP_PATH}/${id}` : `/${MAP_PATH}`;
}
let LAYER_TYPE = exports.LAYER_TYPE = /*#__PURE__*/function (LAYER_TYPE) {
  LAYER_TYPE["RASTER_TILE"] = "RASTER_TILE";
  LAYER_TYPE["GEOJSON_VECTOR"] = "GEOJSON_VECTOR";
  LAYER_TYPE["EMS_VECTOR_TILE"] = "EMS_VECTOR_TILE";
  LAYER_TYPE["HEATMAP"] = "HEATMAP";
  LAYER_TYPE["BLENDED_VECTOR"] = "BLENDED_VECTOR";
  LAYER_TYPE["MVT_VECTOR"] = "MVT_VECTOR";
  LAYER_TYPE["LAYER_GROUP"] = "LAYER_GROUP";
  return LAYER_TYPE;
}({});
let SOURCE_TYPES = exports.SOURCE_TYPES = /*#__PURE__*/function (SOURCE_TYPES) {
  SOURCE_TYPES["EMS_TMS"] = "EMS_TMS";
  SOURCE_TYPES["EMS_FILE"] = "EMS_FILE";
  SOURCE_TYPES["ES_GEO_GRID"] = "ES_GEO_GRID";
  SOURCE_TYPES["ES_GEO_LINE"] = "ES_GEO_LINE";
  SOURCE_TYPES["ES_SEARCH"] = "ES_SEARCH";
  SOURCE_TYPES["ES_PEW_PEW"] = "ES_PEW_PEW";
  SOURCE_TYPES["ES_ML_ANOMALIES"] = "ML_ANOMALIES";
  SOURCE_TYPES["ESQL"] = "ESQL";
  SOURCE_TYPES["EMS_XYZ"] = "EMS_XYZ";
  SOURCE_TYPES["WMS"] = "WMS";
  SOURCE_TYPES["KIBANA_TILEMAP"] = "KIBANA_TILEMAP";
  SOURCE_TYPES["GEOJSON_FILE"] = "GEOJSON_FILE";
  SOURCE_TYPES["MVT_SINGLE_LAYER"] = "MVT_SINGLE_LAYER";
  SOURCE_TYPES["ES_DISTANCE_SOURCE"] = "ES_DISTANCE_SOURCE";
  SOURCE_TYPES["ES_TERM_SOURCE"] = "ES_TERM_SOURCE";
  SOURCE_TYPES["TABLE_SOURCE"] = "TABLE_SOURCE";
  return SOURCE_TYPES;
}({});
let FIELD_ORIGIN = exports.FIELD_ORIGIN = /*#__PURE__*/function (FIELD_ORIGIN) {
  FIELD_ORIGIN["SOURCE"] = "source";
  FIELD_ORIGIN["JOIN"] = "join";
  return FIELD_ORIGIN;
}({});
const JOIN_FIELD_NAME_PREFIX = exports.JOIN_FIELD_NAME_PREFIX = '__kbnjoin__';
const META_DATA_REQUEST_ID_SUFFIX = exports.META_DATA_REQUEST_ID_SUFFIX = 'meta';
const FORMATTERS_DATA_REQUEST_ID_SUFFIX = exports.FORMATTERS_DATA_REQUEST_ID_SUFFIX = 'formatters';
const SOURCE_DATA_REQUEST_ID = exports.SOURCE_DATA_REQUEST_ID = 'source';
const SOURCE_META_DATA_REQUEST_ID = exports.SOURCE_META_DATA_REQUEST_ID = `${SOURCE_DATA_REQUEST_ID}_${META_DATA_REQUEST_ID_SUFFIX}`;
const SOURCE_FORMATTERS_DATA_REQUEST_ID = exports.SOURCE_FORMATTERS_DATA_REQUEST_ID = `${SOURCE_DATA_REQUEST_ID}_${FORMATTERS_DATA_REQUEST_ID_SUFFIX}`;
const SOURCE_BOUNDS_DATA_REQUEST_ID = exports.SOURCE_BOUNDS_DATA_REQUEST_ID = `${SOURCE_DATA_REQUEST_ID}_bounds`;
const MIN_ZOOM = exports.MIN_ZOOM = 0;
const MAX_ZOOM = exports.MAX_ZOOM = 24;
const DECIMAL_DEGREES_PRECISION = exports.DECIMAL_DEGREES_PRECISION = 5; // meters precision
const ZOOM_PRECISION = exports.ZOOM_PRECISION = 2;
const DEFAULT_MAX_RESULT_WINDOW = exports.DEFAULT_MAX_RESULT_WINDOW = 10000;
const DEFAULT_MAX_INNER_RESULT_WINDOW = exports.DEFAULT_MAX_INNER_RESULT_WINDOW = 100;
const DEFAULT_MAX_BUCKETS_LIMIT = exports.DEFAULT_MAX_BUCKETS_LIMIT = 65535;
const FEATURE_VISIBLE_PROPERTY_NAME = exports.FEATURE_VISIBLE_PROPERTY_NAME = '__kbn_isvisibleduetojoin__';
const MB_SOURCE_ID_LAYER_ID_PREFIX_DELIMITER = exports.MB_SOURCE_ID_LAYER_ID_PREFIX_DELIMITER = '_';
let ES_GEO_FIELD_TYPE = exports.ES_GEO_FIELD_TYPE = /*#__PURE__*/function (ES_GEO_FIELD_TYPE) {
  ES_GEO_FIELD_TYPE["GEO_POINT"] = "geo_point";
  ES_GEO_FIELD_TYPE["GEO_SHAPE"] = "geo_shape";
  return ES_GEO_FIELD_TYPE;
}({}); // Using strings instead of ES_GEO_FIELD_TYPE enum to avoid typeing errors where IndexPatternField.type is compared to value
const ES_GEO_FIELD_TYPES = exports.ES_GEO_FIELD_TYPES = ['geo_point', 'geo_shape'];
let GEO_JSON_TYPE = exports.GEO_JSON_TYPE = /*#__PURE__*/function (GEO_JSON_TYPE) {
  GEO_JSON_TYPE["POINT"] = "Point";
  GEO_JSON_TYPE["MULTI_POINT"] = "MultiPoint";
  GEO_JSON_TYPE["LINE_STRING"] = "LineString";
  GEO_JSON_TYPE["MULTI_LINE_STRING"] = "MultiLineString";
  GEO_JSON_TYPE["POLYGON"] = "Polygon";
  GEO_JSON_TYPE["MULTI_POLYGON"] = "MultiPolygon";
  GEO_JSON_TYPE["GEOMETRY_COLLECTION"] = "GeometryCollection";
  return GEO_JSON_TYPE;
}({});
const POLYGON_COORDINATES_EXTERIOR_INDEX = exports.POLYGON_COORDINATES_EXTERIOR_INDEX = 0;
const LON_INDEX = exports.LON_INDEX = 0;
const LAT_INDEX = exports.LAT_INDEX = 1;
const EMPTY_FEATURE_COLLECTION = exports.EMPTY_FEATURE_COLLECTION = {
  type: 'FeatureCollection',
  features: []
};
let DRAW_MODE = exports.DRAW_MODE = /*#__PURE__*/function (DRAW_MODE) {
  DRAW_MODE["DRAW_SHAPES"] = "DRAW_SHAPES";
  DRAW_MODE["DRAW_POINTS"] = "DRAW_POINTS";
  DRAW_MODE["DRAW_FILTERS"] = "DRAW_FILTERS";
  DRAW_MODE["NONE"] = "NONE";
  return DRAW_MODE;
}({});
let DRAW_SHAPE = exports.DRAW_SHAPE = /*#__PURE__*/function (DRAW_SHAPE) {
  DRAW_SHAPE["BOUNDS"] = "BOUNDS";
  DRAW_SHAPE["DISTANCE"] = "DISTANCE";
  DRAW_SHAPE["POLYGON"] = "POLYGON";
  DRAW_SHAPE["POINT"] = "POINT";
  DRAW_SHAPE["LINE"] = "LINE";
  DRAW_SHAPE["SIMPLE_SELECT"] = "SIMPLE_SELECT";
  DRAW_SHAPE["DELETE"] = "DELETE";
  DRAW_SHAPE["WAIT"] = "WAIT";
  return DRAW_SHAPE;
}({});
const AGG_DELIMITER = exports.AGG_DELIMITER = '_of_';
let AGG_TYPE = exports.AGG_TYPE = /*#__PURE__*/function (AGG_TYPE) {
  AGG_TYPE["AVG"] = "avg";
  AGG_TYPE["COUNT"] = "count";
  AGG_TYPE["MAX"] = "max";
  AGG_TYPE["MIN"] = "min";
  AGG_TYPE["SUM"] = "sum";
  AGG_TYPE["TERMS"] = "terms";
  AGG_TYPE["PERCENTILE"] = "percentile";
  AGG_TYPE["UNIQUE_COUNT"] = "cardinality";
  return AGG_TYPE;
}({});
let RENDER_AS = exports.RENDER_AS = /*#__PURE__*/function (RENDER_AS) {
  RENDER_AS["HEATMAP"] = "heatmap";
  RENDER_AS["POINT"] = "point";
  RENDER_AS["GRID"] = "grid";
  RENDER_AS["HEX"] = "hex";
  return RENDER_AS;
}({});
let GRID_RESOLUTION = exports.GRID_RESOLUTION = /*#__PURE__*/function (GRID_RESOLUTION) {
  GRID_RESOLUTION["COARSE"] = "COARSE";
  GRID_RESOLUTION["FINE"] = "FINE";
  GRID_RESOLUTION["MOST_FINE"] = "MOST_FINE";
  GRID_RESOLUTION["SUPER_FINE"] = "SUPER_FINE";
  return GRID_RESOLUTION;
}({});
const GEOTILE_GRID_AGG_NAME = exports.GEOTILE_GRID_AGG_NAME = 'gridSplit';
const GEOCENTROID_AGG_NAME = exports.GEOCENTROID_AGG_NAME = 'gridCentroid';
const TOP_TERM_PERCENTAGE_SUFFIX = exports.TOP_TERM_PERCENTAGE_SUFFIX = '__percentage';
const DEFAULT_PERCENTILE = exports.DEFAULT_PERCENTILE = 50;
const COUNT_PROP_NAME = exports.COUNT_PROP_NAME = 'doc_count';
let STYLE_TYPE = exports.STYLE_TYPE = /*#__PURE__*/function (STYLE_TYPE) {
  STYLE_TYPE["STATIC"] = "STATIC";
  STYLE_TYPE["DYNAMIC"] = "DYNAMIC";
  return STYLE_TYPE;
}({});
let LAYER_STYLE_TYPE = exports.LAYER_STYLE_TYPE = /*#__PURE__*/function (LAYER_STYLE_TYPE) {
  LAYER_STYLE_TYPE["VECTOR"] = "VECTOR";
  LAYER_STYLE_TYPE["HEATMAP"] = "HEATMAP";
  LAYER_STYLE_TYPE["TILE"] = "TILE";
  LAYER_STYLE_TYPE["EMS_VECTOR_TILE"] = "EMS_VECTOR_TILE";
  return LAYER_STYLE_TYPE;
}({});
let COLOR_MAP_TYPE = exports.COLOR_MAP_TYPE = /*#__PURE__*/function (COLOR_MAP_TYPE) {
  COLOR_MAP_TYPE["CATEGORICAL"] = "CATEGORICAL";
  COLOR_MAP_TYPE["ORDINAL"] = "ORDINAL";
  return COLOR_MAP_TYPE;
}({});
const CATEGORICAL_DATA_TYPES = exports.CATEGORICAL_DATA_TYPES = ['string', 'ip', 'boolean'];
const ORDINAL_DATA_TYPES = exports.ORDINAL_DATA_TYPES = ['number', 'date'];
let SYMBOLIZE_AS_TYPES = exports.SYMBOLIZE_AS_TYPES = /*#__PURE__*/function (SYMBOLIZE_AS_TYPES) {
  SYMBOLIZE_AS_TYPES["CIRCLE"] = "circle";
  SYMBOLIZE_AS_TYPES["ICON"] = "icon";
  return SYMBOLIZE_AS_TYPES;
}({});
let LABEL_BORDER_SIZES = exports.LABEL_BORDER_SIZES = /*#__PURE__*/function (LABEL_BORDER_SIZES) {
  LABEL_BORDER_SIZES["NONE"] = "NONE";
  LABEL_BORDER_SIZES["SMALL"] = "SMALL";
  LABEL_BORDER_SIZES["MEDIUM"] = "MEDIUM";
  LABEL_BORDER_SIZES["LARGE"] = "LARGE";
  return LABEL_BORDER_SIZES;
}({});
let LABEL_POSITIONS = exports.LABEL_POSITIONS = /*#__PURE__*/function (LABEL_POSITIONS) {
  LABEL_POSITIONS["BOTTOM"] = "BOTTOM";
  LABEL_POSITIONS["CENTER"] = "CENTER";
  LABEL_POSITIONS["TOP"] = "TOP";
  return LABEL_POSITIONS;
}({});
const DEFAULT_ICON = exports.DEFAULT_ICON = 'marker';
const DEFAULT_CUSTOM_ICON_CUTOFF = exports.DEFAULT_CUSTOM_ICON_CUTOFF = 0.25;
const DEFAULT_CUSTOM_ICON_RADIUS = exports.DEFAULT_CUSTOM_ICON_RADIUS = 0.25;
const CUSTOM_ICON_SIZE = exports.CUSTOM_ICON_SIZE = 64;
const CUSTOM_ICON_PREFIX_SDF = exports.CUSTOM_ICON_PREFIX_SDF = '__kbn__custom_icon_sdf__';
const MAKI_ICON_SIZE = exports.MAKI_ICON_SIZE = 16;
const HALF_MAKI_ICON_SIZE = exports.HALF_MAKI_ICON_SIZE = MAKI_ICON_SIZE / 2;
let ICON_SOURCE = exports.ICON_SOURCE = /*#__PURE__*/function (ICON_SOURCE) {
  ICON_SOURCE["CUSTOM"] = "CUSTOM";
  ICON_SOURCE["MAKI"] = "MAKI";
  return ICON_SOURCE;
}({});
let VECTOR_STYLES = exports.VECTOR_STYLES = /*#__PURE__*/function (VECTOR_STYLES) {
  VECTOR_STYLES["SYMBOLIZE_AS"] = "symbolizeAs";
  VECTOR_STYLES["FILL_COLOR"] = "fillColor";
  VECTOR_STYLES["LINE_COLOR"] = "lineColor";
  VECTOR_STYLES["LINE_WIDTH"] = "lineWidth";
  VECTOR_STYLES["ICON"] = "icon";
  VECTOR_STYLES["ICON_SIZE"] = "iconSize";
  VECTOR_STYLES["ICON_ORIENTATION"] = "iconOrientation";
  VECTOR_STYLES["LABEL_TEXT"] = "labelText";
  VECTOR_STYLES["LABEL_ZOOM_RANGE"] = "labelZoomRange";
  VECTOR_STYLES["LABEL_COLOR"] = "labelColor";
  VECTOR_STYLES["LABEL_SIZE"] = "labelSize";
  VECTOR_STYLES["LABEL_BORDER_COLOR"] = "labelBorderColor";
  VECTOR_STYLES["LABEL_BORDER_SIZE"] = "labelBorderSize";
  VECTOR_STYLES["LABEL_POSITION"] = "labelPosition";
  return VECTOR_STYLES;
}({});
let SCALING_TYPES = exports.SCALING_TYPES = /*#__PURE__*/function (SCALING_TYPES) {
  SCALING_TYPES["LIMIT"] = "LIMIT";
  SCALING_TYPES["CLUSTERS"] = "CLUSTERS";
  SCALING_TYPES["TOP_HITS"] = "TOP_HITS";
  SCALING_TYPES["MVT"] = "MVT";
  return SCALING_TYPES;
}({});
let MVT_FIELD_TYPE = exports.MVT_FIELD_TYPE = /*#__PURE__*/function (MVT_FIELD_TYPE) {
  MVT_FIELD_TYPE["STRING"] = "String";
  MVT_FIELD_TYPE["NUMBER"] = "Number";
  return MVT_FIELD_TYPE;
}({});
const SPATIAL_FILTERS_LAYER_ID = exports.SPATIAL_FILTERS_LAYER_ID = 'SPATIAL_FILTERS_LAYER_ID';
let INITIAL_LOCATION = exports.INITIAL_LOCATION = /*#__PURE__*/function (INITIAL_LOCATION) {
  INITIAL_LOCATION["LAST_SAVED_LOCATION"] = "LAST_SAVED_LOCATION";
  INITIAL_LOCATION["FIXED_LOCATION"] = "FIXED_LOCATION";
  INITIAL_LOCATION["BROWSER_LOCATION"] = "BROWSER_LOCATION";
  INITIAL_LOCATION["AUTO_FIT_TO_BOUNDS"] = "AUTO_FIT_TO_BOUNDS";
  return INITIAL_LOCATION;
}({});
let LAYER_WIZARD_CATEGORY = exports.LAYER_WIZARD_CATEGORY = /*#__PURE__*/function (LAYER_WIZARD_CATEGORY) {
  LAYER_WIZARD_CATEGORY["ELASTICSEARCH"] = "ELASTICSEARCH";
  LAYER_WIZARD_CATEGORY["REFERENCE"] = "REFERENCE";
  LAYER_WIZARD_CATEGORY["SOLUTIONS"] = "SOLUTIONS";
  return LAYER_WIZARD_CATEGORY;
}({});
let VECTOR_SHAPE_TYPE = exports.VECTOR_SHAPE_TYPE = /*#__PURE__*/function (VECTOR_SHAPE_TYPE) {
  VECTOR_SHAPE_TYPE["POINT"] = "POINT";
  VECTOR_SHAPE_TYPE["LINE"] = "LINE";
  VECTOR_SHAPE_TYPE["POLYGON"] = "POLYGON";
  return VECTOR_SHAPE_TYPE;
}({}); // https://docs.mapbox.com/mapbox-gl-js/style-spec/expressions/#data-expressions
let MB_LOOKUP_FUNCTION = exports.MB_LOOKUP_FUNCTION = /*#__PURE__*/function (MB_LOOKUP_FUNCTION) {
  MB_LOOKUP_FUNCTION["GET"] = "get";
  MB_LOOKUP_FUNCTION["FEATURE_STATE"] = "feature-state";
  return MB_LOOKUP_FUNCTION;
}({});
let DATA_MAPPING_FUNCTION = exports.DATA_MAPPING_FUNCTION = /*#__PURE__*/function (DATA_MAPPING_FUNCTION) {
  DATA_MAPPING_FUNCTION["INTERPOLATE"] = "INTERPOLATE";
  DATA_MAPPING_FUNCTION["PERCENTILES"] = "PERCENTILES";
  return DATA_MAPPING_FUNCTION;
}({});
const DEFAULT_PERCENTILES = exports.DEFAULT_PERCENTILES = [50, 75, 90, 95, 99];
const MAPS_NEW_VECTOR_LAYER_META_CREATED_BY = exports.MAPS_NEW_VECTOR_LAYER_META_CREATED_BY = 'maps-new-vector-layer';
const MAX_DRAWING_SIZE_BYTES = exports.MAX_DRAWING_SIZE_BYTES = 10485760; // 10MB

const NO_EMS_LOCALE = exports.NO_EMS_LOCALE = 'none';
const AUTOSELECT_EMS_LOCALE = exports.AUTOSELECT_EMS_LOCALE = 'autoselect';
const emsWorldLayerId = exports.emsWorldLayerId = 'world_countries';
let WIZARD_ID = exports.WIZARD_ID = /*#__PURE__*/function (WIZARD_ID) {
  WIZARD_ID["CHOROPLETH"] = "choropleth";
  WIZARD_ID["GEO_FILE"] = "uploadGeoFile";
  WIZARD_ID["LAYER_GROUP"] = "layerGroup";
  WIZARD_ID["NEW_VECTOR"] = "newVectorLayer";
  WIZARD_ID["OBSERVABILITY"] = "observabilityLayer";
  WIZARD_ID["SECURITY"] = "securityLayer";
  WIZARD_ID["EMS_BOUNDARIES"] = "emsBoundaries";
  WIZARD_ID["EMS_BASEMAP"] = "emsBaseMap";
  WIZARD_ID["CLUSTERS"] = "clusters";
  WIZARD_ID["HEATMAP"] = "heatmap";
  WIZARD_ID["GEO_LINE"] = "geoLine";
  WIZARD_ID["POINT_2_POINT"] = "point2Point";
  WIZARD_ID["ES_DOCUMENT"] = "esDocument";
  WIZARD_ID["ES_TOP_HITS"] = "esTopHits";
  WIZARD_ID["ESQL"] = "ESQL";
  WIZARD_ID["KIBANA_BASEMAP"] = "kibanaBasemap";
  WIZARD_ID["MVT_VECTOR"] = "mvtVector";
  WIZARD_ID["WMS_LAYER"] = "wmsLayer";
  WIZARD_ID["TMS_LAYER"] = "tmsLayer";
  WIZARD_ID["SPATIAL_JOIN"] = "spatialJoin";
  return WIZARD_ID;
}({});
let MASK_OPERATOR = exports.MASK_OPERATOR = /*#__PURE__*/function (MASK_OPERATOR) {
  MASK_OPERATOR["ABOVE"] = "ABOVE";
  MASK_OPERATOR["BELOW"] = "BELOW";
  return MASK_OPERATOR;
}({}); // Maplibre does not provide any feedback when rendering is complete.
// Workaround is hard-coded timeout period.
const RENDER_TIMEOUT = exports.RENDER_TIMEOUT = 1000;
const MIDDLE_TRUNCATION_PROPS = exports.MIDDLE_TRUNCATION_PROPS = {
  truncation: 'middle'
};
const SINGLE_SELECTION_AS_TEXT_PROPS = exports.SINGLE_SELECTION_AS_TEXT_PROPS = {
  asPlainText: true
};