"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RequestDetailsStats = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// TODO: Replace by property once available

const StatRow = ({
  stat
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, null, stat.label, /*#__PURE__*/_react.default.createElement("span", {
    css: (0, _react2.css)({
      marginLeft: euiTheme.size.xs
    })
  }, stat.description ? /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    "aria-label": _i18n.i18n.translate('inspector.requests.descriptionRowIconAriaLabel', {
      defaultMessage: 'Description'
    }),
    type: "question",
    color: "subdued",
    content: stat.description
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "empty"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, null, stat.value));
};
class RequestDetailsStats extends _react.Component {
  render() {
    const {
      stats
    } = this.props.request;
    if (!stats) {
      return null;
    }
    const sortedStats = Object.keys(stats).sort().map(id => ({
      id,
      ...stats[id]
    }));
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTable, {
      responsiveBreakpoint: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableBody, null, sortedStats.map(stat => /*#__PURE__*/_react.default.createElement(StatRow, {
      stat: stat,
      key: stat.id
    }))));
  }
}
exports.RequestDetailsStats = RequestDetailsStats;
(0, _defineProperty2.default)(RequestDetailsStats, "shouldShow", request => Boolean(request.stats && Object.keys(request.stats).length));