"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineEditor = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _context = require("./context");
var _components = require("./components");
var _editors = require("./editors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    container: (0, _react2.css)`
      background-color: ${euiTheme.colors.backgroundBaseSubdued};
    `
  };
};
const PipelineEditor = ({
  onLoadJson
}) => {
  const {
    state: {
      processors: allProcessors
    }
  } = (0, _context.usePipelineProcessorsContext)();
  const styles = useStyles();
  const {
    state: {
      processors,
      onFailure
    }
  } = allProcessors;
  const showEmptyPrompt = processors.length === 0 && onFailure.length === 0;
  let content;
  if (showEmptyPrompt) {
    content = /*#__PURE__*/_react.default.createElement(_components.ProcessorsEmptyPrompt, {
      onLoadJson: onLoadJson
    });
  } else {
    content = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_editors.ProcessorsEditor, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_components.OnFailureProcessorsTitle, null), /*#__PURE__*/_react.default.createElement(_editors.GlobalOnFailureProcessorsEditor, null));
  }
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    responsive: false,
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_components.ProcessorsHeader, {
    onLoadJson: onLoadJson,
    hasProcessors: processors.length > 0
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: styles.container,
    grow: false
  }, content)));
};
exports.PipelineEditor = PipelineEditor;