"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_TIMERANGE = exports.DEFAULT_OPTIONS = exports.DEFAULT_METRICS_EXPLORER_VIEW_STATE = exports.DEFAULT_METRICS = exports.DEFAULT_CHART_OPTIONS = void 0;
Object.defineProperty(exports, "MetricsExplorerChartType", {
  enumerable: true,
  get: function () {
    return _metrics_explorer_views.MetricsExplorerChartType;
  }
});
exports.MetricsExplorerOptionsContainer = void 0;
Object.defineProperty(exports, "MetricsExplorerYAxisMode", {
  enumerable: true,
  get: function () {
    return _metrics_explorer_views.MetricsExplorerYAxisMode;
  }
});
Object.defineProperty(exports, "metricsExplorerChartOptionsRT", {
  enumerable: true,
  get: function () {
    return _metrics_explorer_views.metricsExplorerChartOptionsRT;
  }
});
Object.defineProperty(exports, "metricsExplorerOptionsRT", {
  enumerable: true,
  get: function () {
    return _metrics_explorer_views.metricsExplorerOptionsRT;
  }
});
Object.defineProperty(exports, "metricsExplorerTimeOptionsRT", {
  enumerable: true,
  get: function () {
    return _metrics_explorer_views.metricsExplorerTimeOptionsRT;
  }
});
exports.useMetricsExplorerOptionsContainerContext = exports.useMetricsExplorerOptions = exports.metricsExplorerTimestampsRT = void 0;
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var t = _interopRequireWildcard(require("io-ts"));
var _constate = _interopRequireDefault(require("constate"));
var _react = require("react");
var _metrics_explorer_views = require("../../../../../common/metrics_explorer_views");
var _use_alert_prefill = require("../../../../alerting/use_alert_prefill");
var _color_palette = require("../../../../../common/color_palette");
var _use_kibana_timefilter_time = require("../../../../hooks/use_kibana_timefilter_time");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const metricsExplorerTimestampsRT = exports.metricsExplorerTimestampsRT = t.type({
  fromTimestamp: t.number,
  toTimestamp: t.number,
  interval: t.string
});
const DEFAULT_TIMERANGE = exports.DEFAULT_TIMERANGE = {
  from: 'now-1h',
  to: 'now',
  interval: '>=10s'
};
const DEFAULT_CHART_OPTIONS = exports.DEFAULT_CHART_OPTIONS = {
  type: _metrics_explorer_views.MetricsExplorerChartType.line,
  yAxisMode: _metrics_explorer_views.MetricsExplorerYAxisMode.fromZero,
  stack: false
};
const DEFAULT_METRICS = exports.DEFAULT_METRICS = [{
  aggregation: 'avg',
  field: 'system.cpu.total.norm.pct',
  color: _color_palette.Color.color0
}, {
  aggregation: 'avg',
  field: 'kubernetes.pod.cpu.usage.node.pct',
  color: _color_palette.Color.color1
}, {
  aggregation: 'avg',
  field: 'docker.cpu.total.pct',
  color: _color_palette.Color.color2
}];
const DEFAULT_OPTIONS = exports.DEFAULT_OPTIONS = {
  aggregation: 'avg',
  metrics: DEFAULT_METRICS,
  source: 'default'
};
const DEFAULT_METRICS_EXPLORER_VIEW_STATE = exports.DEFAULT_METRICS_EXPLORER_VIEW_STATE = {
  options: DEFAULT_OPTIONS,
  chartOptions: DEFAULT_CHART_OPTIONS,
  currentTimerange: DEFAULT_TIMERANGE
};
function parseJsonOrDefault(value, defaultValue) {
  if (!value) {
    return defaultValue;
  }
  try {
    return JSON.parse(value);
  } catch (e) {
    return defaultValue;
  }
}
function useStateWithLocalStorage(key, defaultState) {
  const storageState = localStorage.getItem(key);
  const [state, setState] = (0, _react.useState)(parseJsonOrDefault(storageState, defaultState));
  (0, _react.useEffect)(() => {
    localStorage.setItem(key, JSON.stringify(state));
  }, [key, state]);
  return [state, setState];
}
const getDefaultTimeRange = ({
  from,
  to
}) => {
  const fromTimestamp = _datemath.default.parse(from).valueOf();
  const toTimestamp = _datemath.default.parse(to, {
    roundUp: true
  }).valueOf();
  return {
    fromTimestamp,
    toTimestamp,
    interval: DEFAULT_TIMERANGE.interval
  };
};
const useMetricsExplorerOptions = () => {
  const TIME_DEFAULTS = {
    from: 'now-1h',
    to: 'now'
  };
  const [getTime] = (0, _use_kibana_timefilter_time.useKibanaTimefilterTime)(TIME_DEFAULTS);
  const {
    from,
    to
  } = getTime();
  const [options, setOptions] = useStateWithLocalStorage('MetricsExplorerOptions', DEFAULT_OPTIONS);
  const [timeRange, setTimeRange] = (0, _react.useState)({
    from,
    to,
    interval: DEFAULT_TIMERANGE.interval
  });
  const [timestamps, setTimestamps] = (0, _react.useState)(getDefaultTimeRange({
    from,
    to
  }));
  (0, _use_kibana_timefilter_time.useSyncKibanaTimeFilterTime)(TIME_DEFAULTS, {
    from: timeRange.from,
    to: timeRange.to
  });
  const [chartOptions, setChartOptions] = useStateWithLocalStorage('MetricsExplorerChartOptions', DEFAULT_CHART_OPTIONS);
  const [isAutoReloading, setAutoReloading] = (0, _react.useState)(false);
  const {
    metricThresholdPrefill
  } = (0, _use_alert_prefill.useAlertPrefillContext)();
  // For Jest compatibility; including metricThresholdPrefill as a dep in useEffect causes an
  // infinite loop in test environment
  const prefillContext = (0, _react.useMemo)(() => metricThresholdPrefill, [metricThresholdPrefill]);
  (0, _react.useEffect)(() => {
    if (prefillContext) {
      const {
        setPrefillOptions
      } = prefillContext;
      const {
        metrics,
        groupBy,
        filterQuery
      } = options;
      setPrefillOptions({
        metrics,
        groupBy,
        filterQuery
      });
    }
  }, [options, prefillContext]);
  return {
    defaultViewState: {
      options: DEFAULT_OPTIONS,
      chartOptions: DEFAULT_CHART_OPTIONS,
      currentTimerange: timeRange
    },
    options,
    chartOptions,
    setChartOptions,
    timeRange,
    isAutoReloading,
    setOptions,
    setTimeRange,
    startAutoReload: () => setAutoReloading(true),
    stopAutoReload: () => setAutoReloading(false),
    timestamps,
    setTimestamps
  };
};
exports.useMetricsExplorerOptions = useMetricsExplorerOptions;
const [MetricsExplorerOptionsContainer, useMetricsExplorerOptionsContainerContext] = (0, _constate.default)(useMetricsExplorerOptions);
exports.useMetricsExplorerOptionsContainerContext = useMetricsExplorerOptionsContainerContext;
exports.MetricsExplorerOptionsContainer = MetricsExplorerOptionsContainer;