"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogAnalysisSetupStatusUnknownPrompt = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _styled = _interopRequireDefault(require("@emotion/styled"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogAnalysisSetupStatusUnknownPrompt = ({
  retry
}) => /*#__PURE__*/_react.default.createElement(EmptyPrompt, {
  title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.logs.analysis.setupStatusUnknownTitle",
    defaultMessage: "We couldn't determine the status of your ML jobs."
  })),
  actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraLogAnalysisSetupStatusUnknownPromptTryAgainButton",
    onClick: () => retry(),
    color: "primary",
    fill: true
  }, _i18n.i18n.translate('xpack.infra.logs.analysis.setupStatusTryAgainButton', {
    defaultMessage: 'Try again'
  }))
});
exports.LogAnalysisSetupStatusUnknownPrompt = LogAnalysisSetupStatusUnknownPrompt;
const EmptyPrompt = (0, _styled.default)(_eui.EuiEmptyPrompt)`
  align-self: center;
`;