"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isNativeFunctionCallingSupported = void 0;
var _inferenceCommon = require("@kbn/inference-common");
var _types = require("../adapters/openai/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isNativeFunctionCallingSupported = connector => {
  var _ref;
  switch (connector.type) {
    case _inferenceCommon.InferenceConnectorType.OpenAI:
      const apiProvider = (_ref = connector.config.apiProvider) !== null && _ref !== void 0 ? _ref : undefined;
      // defaulting to `true` when the config is not accessible
      return apiProvider ? apiProvider !== _types.OpenAiProviderType.Other : true;
    case _inferenceCommon.InferenceConnectorType.Inference:
      // note: later we might need to check the provider type, for now let's assume support
      //       will be handled by ES and that all providers will support native FC.
      return true;
    case _inferenceCommon.InferenceConnectorType.Bedrock:
      return true;
    case _inferenceCommon.InferenceConnectorType.Gemini:
      return true;
  }
};
exports.isNativeFunctionCallingSupported = isNativeFunctionCallingSupported;