"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ModalConfirmationDeleteFields = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lib = require("../../../lib");
var _fields_tree = require("../../fields_tree");
var _constants = require("../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ModalConfirmationDeleteFields = ({
  title,
  childFields,
  aliases,
  byId,
  confirmButtonText,
  onCancel,
  onConfirm
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const fieldsTree = childFields && childFields.length ? (0, _lib.buildFieldTreeFromIds)(childFields, byId, fieldItem => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, fieldItem.source.name, fieldItem.isMultiField && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow"
  }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.deleteField.confirmationModal.multiFieldBadgeLabel', {
    defaultMessage: '{dataType} multi-field',
    values: {
      dataType: _constants.TYPE_DEFINITION[fieldItem.source.type].label
    }
  }))))) : null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    title: title,
    titleProps: {
      id: modalTitleId
    },
    onCancel: onCancel,
    onConfirm: onConfirm,
    cancelButtonText: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.deleteField.confirmationModal.cancelButtonLabel', {
      defaultMessage: 'Cancel'
    }),
    buttonColor: "danger",
    confirmButtonText: confirmButtonText
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, fieldsTree && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.confirmationModal.deleteFieldsDescription', {
    defaultMessage: 'This will also delete the following fields.'
  })), /*#__PURE__*/_react.default.createElement(_fields_tree.FieldsTree, {
    fields: fieldsTree
  })), aliases && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.confirmationModal.deleteAliasesDescription', {
    defaultMessage: 'The following aliases will also be deleted.'
  })), /*#__PURE__*/_react.default.createElement("ul", null, aliases.map(aliasPath => /*#__PURE__*/_react.default.createElement("li", {
    key: aliasPath
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, aliasPath)))))));
};
exports.ModalConfirmationDeleteFields = ModalConfirmationDeleteFields;