"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeprecatedBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeprecatedBadge = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.idxMgmt.componentTemplate.deprecatedBadgeTooltip', {
      defaultMessage: 'This component template is no longer supported and might be removed in a future release. Instead, use one of the other component templates available or create a new one.'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "warning",
    tabIndex: 0,
    "data-test-subj": "deprecatedComponentTemplateBadge"
  }, _i18n.i18n.translate('xpack.idxMgmt.componentTemplate.deprecatedTemplateBadgeText', {
    defaultMessage: 'Deprecated'
  })));
};
exports.DeprecatedBadge = DeprecatedBadge;