"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCachedIndexPatternProvider = createCachedIndexPatternProvider;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createCachedIndexPatternProvider(indexPatternGetter) {
  const cache = new Map();
  return {
    get: async id => {
      if (!cache.has(id)) {
        cache.set(id, await indexPatternGetter(id));
      }
      return Promise.resolve(cache.get(id));
    }
  };
}