"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpaceSettingsResponseSchema = exports.SettingsResponseSchema = exports.PutSpaceSettingsRequestSchema = exports.PutSettingsRequestSchema = exports.GetSpaceSettingsRequestSchema = exports.GetSettingsRequestSchema = exports.GetEnrollmentSettingsResponseSchema = exports.GetEnrollmentSettingsRequestSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _services = require("../../../common/services");
var _models = require("../models");
var _fleet_proxies = require("./fleet_proxies");
var _fleet_server_policy_config = require("./fleet_server_policy_config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GetSettingsRequestSchema = exports.GetSettingsRequestSchema = {};
const PutSettingsRequestSchema = exports.PutSettingsRequestSchema = {
  body: _configSchema.schema.object({
    has_seen_add_data_notice: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    additional_yaml_config: _configSchema.schema.maybe(_configSchema.schema.string()),
    // Deprecated not used
    kibana_urls: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.uri({
      scheme: ['http', 'https']
    }), {
      validate: value => {
        if ((0, _services.isDiffPathProtocol)(value)) {
          return 'Protocol and path must be the same for each URL';
        }
      }
    })),
    kibana_ca_sha256: _configSchema.schema.maybe(_configSchema.schema.string()),
    prerelease_integrations_enabled: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    delete_unenrolled_agents: _configSchema.schema.maybe(_configSchema.schema.object({
      enabled: _configSchema.schema.boolean(),
      is_preconfigured: _configSchema.schema.boolean()
    }))
  })
};
const GetSpaceSettingsRequestSchema = exports.GetSpaceSettingsRequestSchema = {};
const SpaceSettingsResponseSchema = exports.SpaceSettingsResponseSchema = _configSchema.schema.object({
  item: _configSchema.schema.object({
    managed_by: _configSchema.schema.maybe(_configSchema.schema.string()),
    allowed_namespace_prefixes: _configSchema.schema.arrayOf(_configSchema.schema.string())
  })
});
const SettingsResponseSchema = exports.SettingsResponseSchema = _configSchema.schema.object({
  item: _configSchema.schema.object({
    has_seen_add_data_notice: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    prerelease_integrations_enabled: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    id: _configSchema.schema.string(),
    version: _configSchema.schema.maybe(_configSchema.schema.string()),
    preconfigured_fields: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.literal('fleet_server_hosts'))),
    secret_storage_requirements_met: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    output_secret_storage_requirements_met: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    use_space_awareness_migration_status: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('pending'), _configSchema.schema.literal('success'), _configSchema.schema.literal('error')])),
    use_space_awareness_migration_started_at: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(null), _configSchema.schema.string()])),
    delete_unenrolled_agents: _configSchema.schema.maybe(_configSchema.schema.object({
      enabled: _configSchema.schema.boolean(),
      is_preconfigured: _configSchema.schema.boolean()
    }))
  })
});
const PutSpaceSettingsRequestSchema = exports.PutSpaceSettingsRequestSchema = {
  body: _configSchema.schema.object({
    allowed_namespace_prefixes: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string({
      validate: v => {
        if (v.includes('-')) {
          return 'Must not contain -';
        }
      }
    })))
  })
};
const GetEnrollmentSettingsRequestSchema = exports.GetEnrollmentSettingsRequestSchema = {
  query: _configSchema.schema.maybe(_configSchema.schema.object({
    agentPolicyId: _configSchema.schema.maybe(_configSchema.schema.string())
  }))
};
const GetEnrollmentSettingsResponseSchema = exports.GetEnrollmentSettingsResponseSchema = _configSchema.schema.object({
  fleet_server: _configSchema.schema.object({
    policies: _configSchema.schema.arrayOf(_configSchema.schema.object({
      id: _configSchema.schema.string(),
      name: _configSchema.schema.string(),
      is_managed: _configSchema.schema.boolean(),
      is_default_fleet_server: _configSchema.schema.maybe(_configSchema.schema.boolean()),
      has_fleet_server: _configSchema.schema.maybe(_configSchema.schema.boolean()),
      fleet_server_host_id: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(null), _configSchema.schema.string()])),
      download_source_id: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(null), _configSchema.schema.string()])),
      space_ids: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
      data_output_id: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(null), _configSchema.schema.string()]))
    })),
    has_active: _configSchema.schema.boolean(),
    host: _configSchema.schema.maybe(_fleet_server_policy_config.FleetServerHostSchema),
    host_proxy: _configSchema.schema.maybe(_fleet_proxies.FleetProxySchema),
    es_output: _configSchema.schema.maybe(_models.OutputSchema),
    es_output_proxy: _configSchema.schema.maybe(_fleet_proxies.FleetProxySchema)
  }),
  download_source: _models.DownloadSourceResponseSchema,
  download_source_proxy: _configSchema.schema.maybe(_fleet_proxies.FleetProxySchema)
});