"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdatePackageResponseSchema = exports.UpdatePackageRequestSchema = exports.ReauthorizeTransformResponseSchema = exports.ReauthorizeTransformRequestSchema = exports.PackageMetadataSchema = exports.PackageListItemSchema = exports.PackageInfoSchema = exports.KibanaAssetReferenceSchema = exports.InstalledPackageSchema = exports.InstallationInfoSchema = exports.InstallPackageResponseSchema = exports.InstallPackageFromRegistryRequestSchema = exports.InstallPackageByUploadRequestSchema = exports.InstallKibanaAssetsResponseSchema = exports.InstallKibanaAssetsRequestSchema = exports.GetVerificationKeyIdResponseSchema = exports.GetStatsResponseSchema = exports.GetStatsRequestSchema = exports.GetPackagesResponseSchema = exports.GetPackagesRequestSchema = exports.GetPackageInfoSchema = exports.GetOneBulkOperationPackagesResponseSchema = exports.GetOneBulkOperationPackagesRequestSchema = exports.GetLimitedPackagesResponseSchema = exports.GetLimitedPackagesRequestSchema = exports.GetInstalledPackagesResponseSchema = exports.GetInstalledPackagesRequestSchema = exports.GetInputsResponseSchema = exports.GetInputsRequestSchema = exports.GetInfoResponseSchema = exports.GetInfoRequestSchema = exports.GetFileResponseSchema = exports.GetFileRequestSchema = exports.GetDataStreamsResponseSchema = exports.GetDataStreamsRequestSchema = exports.GetCategoriesResponseSchema = exports.GetCategoriesRequestSchema = exports.GetBulkAssetsResponseSchema = exports.GetBulkAssetsRequestSchema = exports.EsAssetReferenceSchema = exports.DeletePackageResponseSchema = exports.DeletePackageRequestSchema = exports.DeletePackageDatastreamAssetsResponseSchema = exports.DeletePackageDatastreamAssetsRequestSchema = exports.DeleteKibanaAssetsRequestSchema = exports.CreateCustomIntegrationRequestSchema = exports.BulkUpgradePackagesResponseSchema = exports.BulkUpgradePackagesRequestSchema = exports.BulkUninstallPackagesRequestSchema = exports.BulkInstallPackagesResponseItemSchema = exports.BulkInstallPackagesFromRegistryResponseSchema = exports.BulkInstallPackagesFromRegistryRequestSchema = exports.AssetReferenceSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _package_policy = require("../models/package_policy");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GetCategoriesRequestSchema = exports.GetCategoriesRequestSchema = {
  query: _configSchema.schema.object({
    prerelease: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    include_policy_templates: _configSchema.schema.maybe(_configSchema.schema.boolean())
  })
};
const CategorySummaryItemSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  title: _configSchema.schema.string(),
  count: _configSchema.schema.number(),
  parent_id: _configSchema.schema.maybe(_configSchema.schema.string()),
  parent_title: _configSchema.schema.maybe(_configSchema.schema.string())
});
const GetCategoriesResponseSchema = exports.GetCategoriesResponseSchema = _configSchema.schema.object({
  items: _configSchema.schema.arrayOf(CategorySummaryItemSchema)
});
const GetPackagesRequestSchema = exports.GetPackagesRequestSchema = {
  query: _configSchema.schema.object({
    category: _configSchema.schema.maybe(_configSchema.schema.string()),
    prerelease: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    excludeInstallStatus: _configSchema.schema.maybe(_configSchema.schema.boolean({
      defaultValue: false
    })),
    withPackagePoliciesCount: _configSchema.schema.maybe(_configSchema.schema.boolean({
      defaultValue: false
    }))
  })
};
const KibanaAssetReferenceSchema = exports.KibanaAssetReferenceSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  originId: _configSchema.schema.maybe(_configSchema.schema.string()),
  type: _configSchema.schema.oneOf([_configSchema.schema.oneOf([_configSchema.schema.literal('dashboard'), _configSchema.schema.literal('lens'), _configSchema.schema.literal('visualization'), _configSchema.schema.literal('search'), _configSchema.schema.literal('index-pattern'), _configSchema.schema.literal('map'), _configSchema.schema.literal('ml-module'), _configSchema.schema.literal('security-rule'), _configSchema.schema.literal('csp-rule-template'), _configSchema.schema.literal('osquery-pack-asset'), _configSchema.schema.literal('osquery-saved-query'), _configSchema.schema.literal('tag')]), _configSchema.schema.string()])
});
const EsAssetReferenceSchema = exports.EsAssetReferenceSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  type: _configSchema.schema.oneOf([_configSchema.schema.literal('index'), _configSchema.schema.literal('index_template'), _configSchema.schema.literal('component_template'), _configSchema.schema.literal('ingest_pipeline'), _configSchema.schema.literal('ilm_policy'), _configSchema.schema.literal('data_stream_ilm_policy'), _configSchema.schema.literal('transform'), _configSchema.schema.literal('ml_model')]),
  deferred: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  version: _configSchema.schema.maybe(_configSchema.schema.string())
});
const InstallationInfoSchema = exports.InstallationInfoSchema = _configSchema.schema.object({
  type: _configSchema.schema.string(),
  created_at: _configSchema.schema.maybe(_configSchema.schema.string()),
  updated_at: _configSchema.schema.maybe(_configSchema.schema.string()),
  namespaces: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  installed_kibana: _configSchema.schema.arrayOf(KibanaAssetReferenceSchema),
  additional_spaces_installed_kibana: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.arrayOf(KibanaAssetReferenceSchema))),
  installed_es: _configSchema.schema.arrayOf(EsAssetReferenceSchema),
  name: _configSchema.schema.string(),
  version: _configSchema.schema.string(),
  install_status: _configSchema.schema.oneOf([_configSchema.schema.literal('installed'), _configSchema.schema.literal('installing'), _configSchema.schema.literal('install_failed')]),
  install_source: _configSchema.schema.oneOf([_configSchema.schema.literal('registry'), _configSchema.schema.literal('upload'), _configSchema.schema.literal('bundled'), _configSchema.schema.literal('custom')]),
  installed_kibana_space_id: _configSchema.schema.maybe(_configSchema.schema.string()),
  install_format_schema_version: _configSchema.schema.maybe(_configSchema.schema.string()),
  verification_status: _configSchema.schema.oneOf([_configSchema.schema.literal('unverified'), _configSchema.schema.literal('verified'), _configSchema.schema.literal('unknown')]),
  verification_key_id: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.literal(null)])),
  experimental_data_stream_features: _configSchema.schema.maybe(_package_policy.ExperimentalDataStreamFeaturesSchema),
  latest_install_failed_attempts: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
    created_at: _configSchema.schema.string(),
    target_version: _configSchema.schema.string(),
    error: _configSchema.schema.object({
      name: _configSchema.schema.string(),
      message: _configSchema.schema.string(),
      stack: _configSchema.schema.maybe(_configSchema.schema.string())
    })
  }))),
  latest_executed_state: _configSchema.schema.maybe(_configSchema.schema.object({
    name: _configSchema.schema.maybe(_configSchema.schema.string()),
    started_at: _configSchema.schema.maybe(_configSchema.schema.string()),
    error: _configSchema.schema.maybe(_configSchema.schema.string())
  }))
});
const PackageIconSchema = _configSchema.schema.object({
  path: _configSchema.schema.maybe(_configSchema.schema.string()),
  src: _configSchema.schema.string(),
  title: _configSchema.schema.maybe(_configSchema.schema.string()),
  type: _configSchema.schema.maybe(_configSchema.schema.string()),
  size: _configSchema.schema.maybe(_configSchema.schema.string()),
  dark_mode: _configSchema.schema.maybe(_configSchema.schema.boolean())
});
const PackageInfoSchema = exports.PackageInfoSchema = _configSchema.schema.object({
  status: _configSchema.schema.maybe(_configSchema.schema.string()),
  installationInfo: _configSchema.schema.maybe(InstallationInfoSchema),
  name: _configSchema.schema.string(),
  version: _configSchema.schema.string(),
  description: _configSchema.schema.maybe(_configSchema.schema.string()),
  title: _configSchema.schema.string(),
  icons: _configSchema.schema.maybe(_configSchema.schema.arrayOf(PackageIconSchema)),
  conditions: _configSchema.schema.maybe(_configSchema.schema.object({
    kibana: _configSchema.schema.maybe(_configSchema.schema.object({
      version: _configSchema.schema.maybe(_configSchema.schema.string())
    })),
    elastic: _configSchema.schema.maybe(_configSchema.schema.object({
      subscription: _configSchema.schema.maybe(_configSchema.schema.string()),
      capabilities: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
    }))
  })),
  release: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('ga'), _configSchema.schema.literal('beta'), _configSchema.schema.literal('experimental')])),
  type: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('integration'), _configSchema.schema.literal('input'), _configSchema.schema.literal('content'), _configSchema.schema.string()])),
  path: _configSchema.schema.maybe(_configSchema.schema.string()),
  download: _configSchema.schema.maybe(_configSchema.schema.string()),
  internal: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  data_streams: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any()))),
  policy_templates: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any()))),
  categories: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  owner: _configSchema.schema.maybe(_configSchema.schema.object({
    github: _configSchema.schema.maybe(_configSchema.schema.string()),
    type: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('elastic'), _configSchema.schema.literal('partner'), _configSchema.schema.literal('community')]))
  })),
  readme: _configSchema.schema.maybe(_configSchema.schema.string()),
  signature_path: _configSchema.schema.maybe(_configSchema.schema.string()),
  source: _configSchema.schema.maybe(_configSchema.schema.object({
    license: _configSchema.schema.string()
  })),
  format_version: _configSchema.schema.maybe(_configSchema.schema.string()),
  vars: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any()))),
  latestVersion: _configSchema.schema.maybe(_configSchema.schema.string()),
  discovery: _configSchema.schema.maybe(_configSchema.schema.object({
    fields: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
      name: _configSchema.schema.string()
    })))
  }))
})
// sometimes package list response contains extra properties, e.g. installed_kibana
.extendsDeep({
  unknowns: 'allow'
});
const PackageListItemSchema = exports.PackageListItemSchema = PackageInfoSchema.extends({
  id: _configSchema.schema.string(),
  integration: _configSchema.schema.maybe(_configSchema.schema.string())
});
const GetPackagesResponseSchema = exports.GetPackagesResponseSchema = _configSchema.schema.object({
  items: _configSchema.schema.arrayOf(PackageListItemSchema)
});
const InstalledPackageSchema = exports.InstalledPackageSchema = _configSchema.schema.object({
  name: _configSchema.schema.string(),
  version: _configSchema.schema.string(),
  status: _configSchema.schema.string(),
  title: _configSchema.schema.maybe(_configSchema.schema.string()),
  description: _configSchema.schema.maybe(_configSchema.schema.string()),
  icons: _configSchema.schema.maybe(_configSchema.schema.arrayOf(PackageIconSchema)),
  dataStreams: _configSchema.schema.arrayOf(_configSchema.schema.object({
    name: _configSchema.schema.string(),
    title: _configSchema.schema.string()
  }))
});
const GetInstalledPackagesResponseSchema = exports.GetInstalledPackagesResponseSchema = _configSchema.schema.object({
  items: _configSchema.schema.arrayOf(InstalledPackageSchema),
  total: _configSchema.schema.number(),
  searchAfter: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.number(), _configSchema.schema.boolean(), _configSchema.schema.literal(null), _configSchema.schema.any()])))
});
const GetLimitedPackagesResponseSchema = exports.GetLimitedPackagesResponseSchema = _configSchema.schema.object({
  items: _configSchema.schema.arrayOf(_configSchema.schema.string())
});
const GetStatsResponseSchema = exports.GetStatsResponseSchema = _configSchema.schema.object({
  response: _configSchema.schema.object({
    agent_policy_count: _configSchema.schema.number()
  })
});
const GetInputsResponseSchema = exports.GetInputsResponseSchema = _configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.object({
  inputs: _configSchema.schema.arrayOf(_configSchema.schema.object({
    id: _configSchema.schema.string(),
    type: _configSchema.schema.string(),
    streams: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
      id: _configSchema.schema.string(),
      data_stream: _configSchema.schema.object({
        dataset: _configSchema.schema.string(),
        type: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }).extendsDeep({
      unknowns: 'allow'
    })))
  }))
})]);
const GetFileResponseSchema = exports.GetFileResponseSchema = _configSchema.schema.any();
const PackageMetadataSchema = exports.PackageMetadataSchema = _configSchema.schema.object({
  has_policies: _configSchema.schema.boolean()
});
const GetPackageInfoSchema = exports.GetPackageInfoSchema = PackageInfoSchema.extends({
  assets: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.maybe(_configSchema.schema.any())),
  notice: _configSchema.schema.maybe(_configSchema.schema.string()),
  licensePath: _configSchema.schema.maybe(_configSchema.schema.string()),
  keepPoliciesUpToDate: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  license: _configSchema.schema.maybe(_configSchema.schema.string()),
  screenshots: _configSchema.schema.maybe(_configSchema.schema.arrayOf(PackageIconSchema)),
  elasticsearch: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any())),
  agent: _configSchema.schema.maybe(_configSchema.schema.object({
    privileges: _configSchema.schema.maybe(_configSchema.schema.object({
      root: _configSchema.schema.maybe(_configSchema.schema.boolean())
    }))
  })),
  asset_tags: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
    text: _configSchema.schema.string(),
    asset_types: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
    asset_ids: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
  })))
});
const GetInfoResponseSchema = exports.GetInfoResponseSchema = _configSchema.schema.object({
  item: GetPackageInfoSchema,
  metadata: _configSchema.schema.maybe(PackageMetadataSchema)
});
const UpdatePackageResponseSchema = exports.UpdatePackageResponseSchema = _configSchema.schema.object({
  item: GetPackageInfoSchema
});
const AssetReferenceSchema = exports.AssetReferenceSchema = _configSchema.schema.oneOf([KibanaAssetReferenceSchema, EsAssetReferenceSchema]);
const InstallPackageResponseSchema = exports.InstallPackageResponseSchema = _configSchema.schema.object({
  items: _configSchema.schema.arrayOf(AssetReferenceSchema),
  _meta: _configSchema.schema.object({
    install_source: _configSchema.schema.string(),
    name: _configSchema.schema.string()
  })
});
const InstallKibanaAssetsResponseSchema = exports.InstallKibanaAssetsResponseSchema = _configSchema.schema.object({
  success: _configSchema.schema.boolean()
});
const DeletePackageDatastreamAssetsResponseSchema = exports.DeletePackageDatastreamAssetsResponseSchema = _configSchema.schema.object({
  success: _configSchema.schema.boolean()
});
const BulkInstallPackagesResponseItemSchema = exports.BulkInstallPackagesResponseItemSchema = _configSchema.schema.oneOf([_configSchema.schema.object({
  name: _configSchema.schema.string(),
  version: _configSchema.schema.string(),
  result: _configSchema.schema.object({
    assets: _configSchema.schema.maybe(_configSchema.schema.arrayOf(AssetReferenceSchema)),
    status: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('installed'), _configSchema.schema.literal('already_installed')])),
    error: _configSchema.schema.maybe(_configSchema.schema.any()),
    installType: _configSchema.schema.string(),
    installSource: _configSchema.schema.maybe(_configSchema.schema.string())
  })
}), _configSchema.schema.object({
  name: _configSchema.schema.string(),
  statusCode: _configSchema.schema.number(),
  error: _configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.any()])
})]);
const BulkInstallPackagesFromRegistryResponseSchema = exports.BulkInstallPackagesFromRegistryResponseSchema = _configSchema.schema.object({
  items: _configSchema.schema.arrayOf(BulkInstallPackagesResponseItemSchema)
});
const BulkUpgradePackagesResponseSchema = exports.BulkUpgradePackagesResponseSchema = _configSchema.schema.object({
  taskId: _configSchema.schema.string()
});
const GetOneBulkOperationPackagesResponseSchema = exports.GetOneBulkOperationPackagesResponseSchema = _configSchema.schema.object({
  status: _configSchema.schema.string(),
  error: _configSchema.schema.maybe(_configSchema.schema.object({
    message: _configSchema.schema.string()
  })),
  results: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
    name: _configSchema.schema.string(),
    success: _configSchema.schema.boolean(),
    error: _configSchema.schema.maybe(_configSchema.schema.object({
      message: _configSchema.schema.string()
    }))
  })))
});
const DeletePackageResponseSchema = exports.DeletePackageResponseSchema = _configSchema.schema.object({
  items: _configSchema.schema.arrayOf(AssetReferenceSchema)
});
const GetVerificationKeyIdResponseSchema = exports.GetVerificationKeyIdResponseSchema = _configSchema.schema.object({
  id: _configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.literal(null)])
});
const GetDataStreamsResponseSchema = exports.GetDataStreamsResponseSchema = _configSchema.schema.object({
  items: _configSchema.schema.arrayOf(_configSchema.schema.object({
    name: _configSchema.schema.string()
  }))
});
const GetBulkAssetsResponseSchema = exports.GetBulkAssetsResponseSchema = _configSchema.schema.object({
  items: _configSchema.schema.arrayOf(_configSchema.schema.object({
    appLink: _configSchema.schema.maybe(_configSchema.schema.string()),
    id: _configSchema.schema.string(),
    type: _configSchema.schema.string(),
    updatedAt: _configSchema.schema.maybe(_configSchema.schema.string()),
    attributes: _configSchema.schema.object({
      service: _configSchema.schema.maybe(_configSchema.schema.string()),
      title: _configSchema.schema.maybe(_configSchema.schema.string()),
      description: _configSchema.schema.maybe(_configSchema.schema.string())
    })
  }))
});
const ReauthorizeTransformResponseSchema = exports.ReauthorizeTransformResponseSchema = _configSchema.schema.arrayOf(_configSchema.schema.object({
  transformId: _configSchema.schema.string(),
  success: _configSchema.schema.boolean(),
  error: _configSchema.schema.oneOf([_configSchema.schema.literal(null), _configSchema.schema.any()])
}));
const GetInstalledPackagesRequestSchema = exports.GetInstalledPackagesRequestSchema = {
  query: _configSchema.schema.object({
    dataStreamType: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('logs'), _configSchema.schema.literal('metrics'), _configSchema.schema.literal('traces'), _configSchema.schema.literal('synthetics'), _configSchema.schema.literal('profiling')])),
    showOnlyActiveDataStreams: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    nameQuery: _configSchema.schema.maybe(_configSchema.schema.string()),
    searchAfter: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.number()]))),
    perPage: _configSchema.schema.number({
      defaultValue: 15
    }),
    sortOrder: _configSchema.schema.oneOf([_configSchema.schema.literal('asc'), _configSchema.schema.literal('desc')], {
      defaultValue: 'asc'
    })
  })
};
const GetDataStreamsRequestSchema = exports.GetDataStreamsRequestSchema = {
  query: _configSchema.schema.object({
    type: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('logs'), _configSchema.schema.literal('metrics'), _configSchema.schema.literal('traces'), _configSchema.schema.literal('synthetics'), _configSchema.schema.literal('profiling')])),
    datasetQuery: _configSchema.schema.maybe(_configSchema.schema.string()),
    sortOrder: _configSchema.schema.oneOf([_configSchema.schema.literal('asc'), _configSchema.schema.literal('desc')], {
      defaultValue: 'asc'
    }),
    uncategorisedOnly: _configSchema.schema.boolean({
      defaultValue: false
    })
  })
};
const GetLimitedPackagesRequestSchema = exports.GetLimitedPackagesRequestSchema = {
  query: _configSchema.schema.object({
    prerelease: _configSchema.schema.maybe(_configSchema.schema.boolean())
  })
};
const GetFileRequestSchema = exports.GetFileRequestSchema = {
  params: _configSchema.schema.object({
    pkgName: _configSchema.schema.string(),
    pkgVersion: _configSchema.schema.string(),
    filePath: _configSchema.schema.string()
  })
};
const GetInfoRequestSchema = exports.GetInfoRequestSchema = {
  params: _configSchema.schema.object({
    pkgName: _configSchema.schema.string(),
    pkgVersion: _configSchema.schema.maybe(_configSchema.schema.string())
  }),
  query: _configSchema.schema.object({
    ignoreUnverified: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    prerelease: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    full: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    withMetadata: _configSchema.schema.boolean({
      defaultValue: false
    })
  })
};
const GetBulkAssetsRequestSchema = exports.GetBulkAssetsRequestSchema = {
  body: _configSchema.schema.object({
    assetIds: _configSchema.schema.arrayOf(_configSchema.schema.object({
      id: _configSchema.schema.string(),
      type: _configSchema.schema.string()
    }))
  })
};
const UpdatePackageRequestSchema = exports.UpdatePackageRequestSchema = {
  params: _configSchema.schema.object({
    pkgName: _configSchema.schema.string(),
    pkgVersion: _configSchema.schema.maybe(_configSchema.schema.string())
  }),
  body: _configSchema.schema.object({
    keepPoliciesUpToDate: _configSchema.schema.boolean()
  })
};
const GetStatsRequestSchema = exports.GetStatsRequestSchema = {
  params: _configSchema.schema.object({
    pkgName: _configSchema.schema.string()
  })
};
const InstallPackageFromRegistryRequestSchema = exports.InstallPackageFromRegistryRequestSchema = {
  params: _configSchema.schema.object({
    pkgName: _configSchema.schema.string(),
    pkgVersion: _configSchema.schema.maybe(_configSchema.schema.string())
  }),
  query: _configSchema.schema.object({
    prerelease: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    ignoreMappingUpdateErrors: _configSchema.schema.boolean({
      defaultValue: false
    }),
    skipDataStreamRollover: _configSchema.schema.boolean({
      defaultValue: false
    })
  }),
  body: _configSchema.schema.nullable(_configSchema.schema.object({
    force: _configSchema.schema.boolean({
      defaultValue: false
    }),
    ignore_constraints: _configSchema.schema.boolean({
      defaultValue: false
    })
  }))
};
const ReauthorizeTransformRequestSchema = exports.ReauthorizeTransformRequestSchema = {
  params: _configSchema.schema.object({
    pkgName: _configSchema.schema.string(),
    pkgVersion: _configSchema.schema.maybe(_configSchema.schema.string())
  }),
  query: _configSchema.schema.object({
    prerelease: _configSchema.schema.maybe(_configSchema.schema.boolean())
  }),
  body: _configSchema.schema.object({
    transforms: _configSchema.schema.arrayOf(_configSchema.schema.object({
      transformId: _configSchema.schema.string()
    }))
  })
};
const BulkInstallPackagesFromRegistryRequestSchema = exports.BulkInstallPackagesFromRegistryRequestSchema = {
  query: _configSchema.schema.object({
    prerelease: _configSchema.schema.maybe(_configSchema.schema.boolean())
  }),
  body: _configSchema.schema.object({
    packages: _configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.object({
      name: _configSchema.schema.string(),
      version: _configSchema.schema.string(),
      prerelease: _configSchema.schema.maybe(_configSchema.schema.boolean())
    })]), {
      minSize: 1
    }),
    force: _configSchema.schema.boolean({
      defaultValue: false
    })
  })
};
const GetOneBulkOperationPackagesRequestSchema = exports.GetOneBulkOperationPackagesRequestSchema = {
  params: _configSchema.schema.object({
    taskId: _configSchema.schema.string()
  })
};
const BulkUpgradePackagesRequestSchema = exports.BulkUpgradePackagesRequestSchema = {
  body: _configSchema.schema.object({
    packages: _configSchema.schema.arrayOf(_configSchema.schema.object({
      name: _configSchema.schema.string(),
      version: _configSchema.schema.maybe(_configSchema.schema.string())
    }), {
      minSize: 1
    }),
    prerelease: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    force: _configSchema.schema.boolean({
      defaultValue: false
    }),
    upgrade_package_policies: _configSchema.schema.boolean({
      defaultValue: false
    })
  })
};
const BulkUninstallPackagesRequestSchema = exports.BulkUninstallPackagesRequestSchema = {
  body: _configSchema.schema.object({
    packages: _configSchema.schema.arrayOf(_configSchema.schema.object({
      name: _configSchema.schema.string(),
      version: _configSchema.schema.string()
    }), {
      minSize: 1
    }),
    force: _configSchema.schema.boolean({
      defaultValue: false
    })
  })
};
const InstallPackageByUploadRequestSchema = exports.InstallPackageByUploadRequestSchema = {
  query: _configSchema.schema.object({
    ignoreMappingUpdateErrors: _configSchema.schema.boolean({
      defaultValue: false
    }),
    skipDataStreamRollover: _configSchema.schema.boolean({
      defaultValue: false
    })
  }),
  body: _configSchema.schema.buffer()
};
const CreateCustomIntegrationRequestSchema = exports.CreateCustomIntegrationRequestSchema = {
  body: _configSchema.schema.object({
    integrationName: _configSchema.schema.string(),
    datasets: _configSchema.schema.arrayOf(_configSchema.schema.object({
      name: _configSchema.schema.string(),
      type: _configSchema.schema.oneOf([_configSchema.schema.literal('logs'), _configSchema.schema.literal('metrics'), _configSchema.schema.literal('traces'), _configSchema.schema.literal('synthetics'), _configSchema.schema.literal('profiling')])
    })),
    force: _configSchema.schema.maybe(_configSchema.schema.boolean())
  })
};
const DeletePackageRequestSchema = exports.DeletePackageRequestSchema = {
  params: _configSchema.schema.object({
    pkgName: _configSchema.schema.string(),
    pkgVersion: _configSchema.schema.maybe(_configSchema.schema.string())
  }),
  query: _configSchema.schema.object({
    force: _configSchema.schema.maybe(_configSchema.schema.boolean())
  })
};
const InstallKibanaAssetsRequestSchema = exports.InstallKibanaAssetsRequestSchema = {
  params: _configSchema.schema.object({
    pkgName: _configSchema.schema.string(),
    pkgVersion: _configSchema.schema.string()
  }),
  body: _configSchema.schema.nullable(_configSchema.schema.object({
    force: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    space_ids: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string(), {
      minSize: 1,
      meta: {
        description: 'When provided install assets in the specified spaces instead of the current space.'
      }
    }))
  }))
};
const DeleteKibanaAssetsRequestSchema = exports.DeleteKibanaAssetsRequestSchema = {
  params: _configSchema.schema.object({
    pkgName: _configSchema.schema.string(),
    pkgVersion: _configSchema.schema.string()
  })
};
const DeletePackageDatastreamAssetsRequestSchema = exports.DeletePackageDatastreamAssetsRequestSchema = {
  params: _configSchema.schema.object({
    pkgName: _configSchema.schema.string(),
    pkgVersion: _configSchema.schema.string()
  }),
  query: _configSchema.schema.object({
    packagePolicyId: _configSchema.schema.string()
  })
};
const GetInputsRequestSchema = exports.GetInputsRequestSchema = {
  params: _configSchema.schema.object({
    pkgName: _configSchema.schema.string(),
    pkgVersion: _configSchema.schema.string()
  }),
  query: _configSchema.schema.object({
    format: _configSchema.schema.oneOf([_configSchema.schema.literal('json'), _configSchema.schema.literal('yml'), _configSchema.schema.literal('yaml')], {
      defaultValue: 'json'
    }),
    prerelease: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    ignoreUnverified: _configSchema.schema.maybe(_configSchema.schema.boolean())
  })
};