"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFilesClientFactory = void 0;
var _constants = require("../../../common/constants");
var _common = require("../../../common");
var _errors = require("../../errors");
var _client_to_host = require("./client_to_host");
var _client_from_host = require("./client_from_host");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFilesClientFactory = ({
  esClient,
  logger
}) => {
  return {
    fromHost: packageName => {
      var _FILE_STORAGE_INTEGRA;
      if (!((_FILE_STORAGE_INTEGRA = _constants.FILE_STORAGE_INTEGRATION_INDEX_NAMES[packageName]) !== null && _FILE_STORAGE_INTEGRA !== void 0 && _FILE_STORAGE_INTEGRA.fromHost)) {
        throw new _errors.FleetFilesClientError(`Integration name [${packageName}] does not have access to files received from host`);
      }
      return new _client_from_host.FleetFromHostFilesClient(esClient, logger.get('fleetFiles', packageName), (0, _common.getFileMetadataIndexName)(packageName), (0, _common.getFileDataIndexName)(packageName));
    },
    toHost: (packageName, maxFileBytes) => {
      var _FILE_STORAGE_INTEGRA2;
      if (!((_FILE_STORAGE_INTEGRA2 = _constants.FILE_STORAGE_INTEGRATION_INDEX_NAMES[packageName]) !== null && _FILE_STORAGE_INTEGRA2 !== void 0 && _FILE_STORAGE_INTEGRA2.toHost)) {
        throw new _errors.FleetFilesClientError(`Integration name [${packageName}] does not have access to files for delivery to host`);
      }
      return new _client_to_host.FleetToHostFilesClient(esClient, logger.get('fleetFiles', packageName), (0, _common.getFileMetadataIndexName)(packageName, true), (0, _common.getFileDataIndexName)(packageName, true), maxFileBytes);
    }
  };
};
exports.getFilesClientFactory = getFilesClientFactory;