"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NamespaceComboBox = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NamespaceComboBox = ({
  namespace,
  placeholder,
  isEditPage,
  packageType,
  validationError,
  docLinks,
  onNamespaceChange,
  'data-test-subj': dataTestSubj = 'packagePolicyNamespaceInput',
  fullWidth = false
}) => {
  const getHelpText = () => {
    var _docLinks$links, _docLinks$links$fleet;
    if (isEditPage && packageType === 'input') {
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.createPackagePolicy.stepConfigure.packagePolicyInputOnlyEditNamespaceHelpLabel",
        defaultMessage: "The namespace cannot be changed for this integration. Create a new integration policy to use a different namespace."
      });
    }
    const learnMoreLink = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: (docLinks === null || docLinks === void 0 ? void 0 : (_docLinks$links = docLinks.links) === null || _docLinks$links === void 0 ? void 0 : (_docLinks$links$fleet = _docLinks$links.fleet) === null || _docLinks$links$fleet === void 0 ? void 0 : _docLinks$links$fleet.datastreamsNamingScheme) || 'https://www.elastic.co/docs/reference/fleet/data-streams#data-streams-naming-scheme',
      target: "_blank"
    }, _i18n.i18n.translate('xpack.fleet.createPackagePolicy.stepConfigure.packagePolicyNamespaceHelpLearnMoreLabel', {
      defaultMessage: 'Learn more'
    }));
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.stepConfigure.packagePolicyNamespaceHelpLabel",
      defaultMessage: "Change the default namespace inherited from the parent agent policy. This setting changes the name of the integration's data stream. {learnMore}.",
      values: {
        learnMore: learnMoreLink
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: fullWidth,
    isInvalid: !!validationError,
    error: validationError,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: 'xpack.fleet.createPackagePolicy.stepConfigure.packagePolicyNamespaceInputLabel',
      defaultMessage: "Namespace"
    }),
    helpText: getHelpText()
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    isInvalid: !!validationError,
    fullWidth: fullWidth,
    "data-test-subj": dataTestSubj,
    noSuggestions: true,
    placeholder: placeholder,
    isDisabled: isEditPage && packageType === 'input',
    singleSelection: true,
    selectedOptions: namespace ? [{
      label: namespace
    }] : [],
    onCreateOption: newNamespace => {
      onNamespaceChange(newNamespace);
    },
    onChange: newNamespaces => {
      onNamespaceChange(newNamespaces.length ? newNamespaces[0].label : '');
    }
  }));
};
exports.NamespaceComboBox = NamespaceComboBox;