"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGcpIntegrationDetailsFromAgentPolicy = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Get the project id, organization id and account type of gcp integration from an agent policy
 */
const getGcpIntegrationDetailsFromAgentPolicy = selectedPolicy => {
  var _selectedPolicy$packa, _selectedPolicy$packa2, _selectedPolicy$packa3;
  let gcpProjectId = selectedPolicy === null || selectedPolicy === void 0 ? void 0 : (_selectedPolicy$packa = selectedPolicy.package_policies) === null || _selectedPolicy$packa === void 0 ? void 0 : _selectedPolicy$packa.reduce((acc, packagePolicy) => {
    var _packagePolicy$inputs;
    const findGcpProjectId = (_packagePolicy$inputs = packagePolicy.inputs) === null || _packagePolicy$inputs === void 0 ? void 0 : _packagePolicy$inputs.reduce((accInput, input) => {
      var _input$streams$, _input$streams$$vars, _input$streams$$vars$;
      if (accInput !== '') {
        return accInput;
      }
      if (input !== null && input !== void 0 && input.enabled && input !== null && input !== void 0 && (_input$streams$ = input.streams[0]) !== null && _input$streams$ !== void 0 && (_input$streams$$vars = _input$streams$.vars) !== null && _input$streams$$vars !== void 0 && (_input$streams$$vars$ = _input$streams$$vars['gcp.project_id']) !== null && _input$streams$$vars$ !== void 0 && _input$streams$$vars$.value) {
        var _input$streams$2, _input$streams$2$vars, _input$streams$2$vars2;
        return input === null || input === void 0 ? void 0 : (_input$streams$2 = input.streams[0]) === null || _input$streams$2 === void 0 ? void 0 : (_input$streams$2$vars = _input$streams$2.vars) === null || _input$streams$2$vars === void 0 ? void 0 : (_input$streams$2$vars2 = _input$streams$2$vars['gcp.project_id']) === null || _input$streams$2$vars2 === void 0 ? void 0 : _input$streams$2$vars2.value;
      }
      return accInput;
    }, '');
    if (findGcpProjectId) {
      return findGcpProjectId;
    }
    return acc;
  }, '');
  let gcpOrganizationId = selectedPolicy === null || selectedPolicy === void 0 ? void 0 : (_selectedPolicy$packa2 = selectedPolicy.package_policies) === null || _selectedPolicy$packa2 === void 0 ? void 0 : _selectedPolicy$packa2.reduce((acc, packagePolicy) => {
    var _packagePolicy$inputs2;
    const findGcpProjectId = (_packagePolicy$inputs2 = packagePolicy.inputs) === null || _packagePolicy$inputs2 === void 0 ? void 0 : _packagePolicy$inputs2.reduce((accInput, input) => {
      var _input$streams$3, _input$streams$3$vars, _input$streams$3$vars2;
      if (accInput !== '') {
        return accInput;
      }
      if (input !== null && input !== void 0 && input.enabled && input !== null && input !== void 0 && (_input$streams$3 = input.streams[0]) !== null && _input$streams$3 !== void 0 && (_input$streams$3$vars = _input$streams$3.vars) !== null && _input$streams$3$vars !== void 0 && (_input$streams$3$vars2 = _input$streams$3$vars['gcp.organization_id']) !== null && _input$streams$3$vars2 !== void 0 && _input$streams$3$vars2.value) {
        var _input$streams$4, _input$streams$4$vars, _input$streams$4$vars2;
        return input === null || input === void 0 ? void 0 : (_input$streams$4 = input.streams[0]) === null || _input$streams$4 === void 0 ? void 0 : (_input$streams$4$vars = _input$streams$4.vars) === null || _input$streams$4$vars === void 0 ? void 0 : (_input$streams$4$vars2 = _input$streams$4$vars['gcp.organization_id']) === null || _input$streams$4$vars2 === void 0 ? void 0 : _input$streams$4$vars2.value;
      }
      return accInput;
    }, '');
    if (findGcpProjectId) {
      return findGcpProjectId;
    }
    return acc;
  }, '');
  let gcpAccountType = selectedPolicy === null || selectedPolicy === void 0 ? void 0 : (_selectedPolicy$packa3 = selectedPolicy.package_policies) === null || _selectedPolicy$packa3 === void 0 ? void 0 : _selectedPolicy$packa3.reduce((acc, packagePolicy) => {
    var _packagePolicy$inputs3;
    const findGcpProjectId = (_packagePolicy$inputs3 = packagePolicy.inputs) === null || _packagePolicy$inputs3 === void 0 ? void 0 : _packagePolicy$inputs3.reduce((accInput, input) => {
      var _input$streams$5, _input$streams$5$vars, _input$streams$5$vars2;
      if (accInput !== '') {
        return accInput;
      }
      if (input !== null && input !== void 0 && input.enabled && input !== null && input !== void 0 && (_input$streams$5 = input.streams[0]) !== null && _input$streams$5 !== void 0 && (_input$streams$5$vars = _input$streams$5.vars) !== null && _input$streams$5$vars !== void 0 && (_input$streams$5$vars2 = _input$streams$5$vars['gcp.account_type']) !== null && _input$streams$5$vars2 !== void 0 && _input$streams$5$vars2.value) {
        var _input$streams$6, _input$streams$6$vars, _input$streams$6$vars2;
        return input === null || input === void 0 ? void 0 : (_input$streams$6 = input.streams[0]) === null || _input$streams$6 === void 0 ? void 0 : (_input$streams$6$vars = _input$streams$6.vars) === null || _input$streams$6$vars === void 0 ? void 0 : (_input$streams$6$vars2 = _input$streams$6$vars['gcp.account_type']) === null || _input$streams$6$vars2 === void 0 ? void 0 : _input$streams$6$vars2.value;
      }
      return accInput;
    }, '');
    if (findGcpProjectId) {
      return findGcpProjectId;
    }
    return acc;
  }, '');
  gcpProjectId = gcpProjectId !== '' ? gcpProjectId : undefined;
  gcpOrganizationId = gcpOrganizationId !== '' ? gcpOrganizationId : undefined;
  gcpAccountType = gcpAccountType !== '' ? gcpAccountType : undefined;
  return {
    gcpProjectId,
    gcpOrganizationId,
    gcpAccountType
  };
};
exports.getGcpIntegrationDetailsFromAgentPolicy = getGcpIntegrationDetailsFromAgentPolicy;