"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewChangelog = exports.ConfirmBulkUpgradeModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../../../../../hooks");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ViewChangelog = ({
  pkgName,
  pkgVersion
}) => {
  const {
    data: changelogText,
    isLoading
  } = (0, _hooks.useGetFileByPathQuery)(`/package/${pkgName}/${pkgVersion}/changelog.yml`);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 5,
    size: "s",
    isLoading: isLoading,
    contentAriaLabel: "changelog text"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    overflowHeight: 150
  }, changelogText));
};
exports.ViewChangelog = ViewChangelog;
const ConfirmBulkUpgradeModal = ({
  onClose,
  onConfirm,
  selectedItems
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [updatePolicies, setUpdatePolicies] = (0, _react.useState)(false);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const isSingleItem = selectedItems.length === 1;
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    title: isSingleItem ? _i18n.i18n.translate('xpack.fleet.installedIntegrations.bulkUpgradeModal.title', {
      defaultMessage: 'Upgrade {pkgName} and policies',
      values: {
        pkgName: selectedItems[0].title
      }
    }) : _i18n.i18n.translate('xpack.fleet.installedIntegrations.bulkUpgradeModal.title', {
      defaultMessage: 'Upgrade {countIntegrations} integrations and {countPolicies} policies',
      values: {
        countIntegrations: selectedItems.length,
        countPolicies: selectedItems.reduce((acc, item) => {
          var _item$packagePolicies, _item$packagePolicies2;
          return acc + ((_item$packagePolicies = (_item$packagePolicies2 = item.packagePoliciesInfo) === null || _item$packagePolicies2 === void 0 ? void 0 : _item$packagePolicies2.count) !== null && _item$packagePolicies !== void 0 ? _item$packagePolicies : 0);
        }, 0)
      }
    }),
    titleProps: {
      id: modalTitleId
    },
    confirmButtonText: _i18n.i18n.translate('xpack.fleet.installedIntegrations.bulkUpgradeModal.confirmButton', {
      defaultMessage: 'Upgrade to latest version'
    }),
    cancelButtonText: isSingleItem ? _i18n.i18n.translate('xpack.fleet.installedIntegrations.bulkUpgradeModal.cancelSingleItemButton', {
      defaultMessage: 'Cancel'
    }) : _i18n.i18n.translate('xpack.fleet.installedIntegrations.bulkUpgradeModal.cancelButton', {
      defaultMessage: 'Review integration selection'
    }),
    onCancel: onClose,
    isLoading: isLoading,
    onConfirm: async () => {
      try {
        setIsLoading(true);
        await onConfirm({
          updatePolicies
        });
        onClose();
      } catch (err) {
        setIsLoading(false);
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, isSingleItem ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.installedIntegrations.bulkUpgradeModal.singleItemDescription",
    defaultMessage: 'We will upgrade this integration and policies to the latest available version.'
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.installedIntegrations.bulkUpgradeModal.description",
    defaultMessage: 'We will upgrade your integrations and policies to the latest available version.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), isSingleItem ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.installedIntegrations.bulkUpgradeModal.installedVersionText",
    defaultMessage: 'Installed version: {installedVersion}',
    values: {
      installedVersion: /*#__PURE__*/_react.default.createElement("b", null, selectedItems[0].installationInfo.version)
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.installedIntegrations.bulkUpgradeModal.latestVersionText",
    defaultMessage: 'Latest version available: {latestVersion}',
    values: {
      latestVersion: /*#__PURE__*/_react.default.createElement("b", null, selectedItems[0].version)
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "viewChangelog",
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: euiTheme.colors.link
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.installedIntegrations.bulkUpgradeModal.viewChangelogButton",
      defaultMessage: "View Changelog"
    }))
  }, /*#__PURE__*/_react.default.createElement(ViewChangelog, {
    pkgName: selectedItems[0].name,
    pkgVersion: selectedItems[0].version
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: false,
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "upgradeIntegrationsPoliciesSwitch",
    checked: updatePolicies,
    onChange: e => {
      setUpdatePolicies(e.target.checked);
    },
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.installedIntegrations.bulkUpgradeModal.policiesSwitchLabel",
      defaultMessage: "Upgrade integration policies"
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "info",
    size: "m"
  }), "\xA0", /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.installedIntegrations.bulkUpgradeModal.policiesCallout",
    defaultMessage: "When enabled, Fleet will attempt to upgrade and deploy integration policies automatically."
  }))));
};
exports.ConfirmBulkUpgradeModal = ConfirmBulkUpgradeModal;