"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RequirementItem = exports.MissingESRequirementsPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _layouts = require("../../../layouts");
var _hooks = require("../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RequirementItem = ({
  isMissing,
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, isMissing ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "error",
    color: "danger"
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "checkInCircleFilled",
    color: "success"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, children)));
};
exports.RequirementItem = RequirementItem;
const MissingESRequirementsPage = ({
  missingRequirements
}) => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  const theme = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_layouts.WithoutHeaderLayout, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    restrictWidth: 820,
    css: (0, _react2.css)`
          border: ${theme.euiTheme.border.thin}};
          border-radius: 5px;
        `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    color: "transparent"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.fleet.setupPage.missingRequirementsCalloutTitle', {
      defaultMessage: 'Missing security requirements'
    }),
    color: "warning",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.setupPage.missingRequirementsCalloutDescription",
    defaultMessage: "To use central management for Elastic Agents, enable the following Elasticsearch security features."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.setupPage.missingRequirementsElasticsearchTitle",
    defaultMessage: "In your Elasticsearch configuration ({esConfigFile}), enable:",
    values: {
      esConfigFile: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "elasticsearch.yml")
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(RequirementItem, {
    isMissing: missingRequirements.includes('security_required')
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.setupPage.elasticsearchSecurityFlagText",
    defaultMessage: "{esSecurityLink}. Set {securityFlag} to {true} .",
    values: {
      esSecurityLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.security.elasticsearchEnableSecurity,
        target: "_blank",
        external: true
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.setupPage.elasticsearchSecurityLink",
        defaultMessage: "Elasticsearch security"
      })),
      securityFlag: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "xpack.security.enabled"),
      true: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "true")
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(RequirementItem, {
    isMissing: missingRequirements.includes('api_keys')
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.setupPage.elasticsearchApiKeyFlagText",
    defaultMessage: "{apiKeyLink}. Set {apiKeyFlag} to {true} .",
    values: {
      apiKeyFlag: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "xpack.security.authc.api_key.enabled"),
      true: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "true"),
      apiKeyLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.security.apiKeyServiceSettings,
        target: "_blank",
        external: true
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.setupPage.apiKeyServiceLink",
        defaultMessage: "API key service"
      }))
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    isCopyable: true
  }, `xpack.security.enabled: true
xpack.security.authc.api_key.enabled: true`), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.setupPage.gettingStartedText",
    defaultMessage: "For more information, read our {link} guide.",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.fleet.guide,
        target: "_blank",
        external: true
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.setupPage.gettingStartedLink",
        defaultMessage: "Getting Started"
      }))
    }
  }))));
};
exports.MissingESRequirementsPage = MissingESRequirementsPage;