"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.waffleArgTypes = exports.treemapArgTypes = exports.pieDonutArgTypes = exports.mosaicArgTypes = exports.argTypes = void 0;
var _charts = require("@elastic/charts");
var _common = require("../../../common");
var _types = require("../../../common/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const visConfigName = 'visConfig';
const argTypes = exports.argTypes = {
  addTooltip: {
    name: `${visConfigName}.addTooltip`,
    description: 'Add tooltip on hover',
    type: {
      name: 'boolean',
      required: false
    },
    table: {
      type: {
        summary: 'boolean'
      }
    },
    control: {
      type: 'boolean'
    }
  },
  legendDisplay: {
    name: `${visConfigName}.legendDisplay`,
    description: 'Legend mode of displaying',
    type: {
      name: 'string',
      required: false
    },
    table: {
      type: {
        summary: 'string'
      },
      defaultValue: {
        summary: _common.LegendDisplay.HIDE
      }
    },
    options: Object.values(_common.LegendDisplay),
    control: {
      type: 'select'
    }
  },
  legendPosition: {
    name: `${visConfigName}.legendPosition`,
    description: 'Legend position',
    type: {
      name: 'string',
      required: false
    },
    table: {
      type: {
        summary: 'string'
      },
      defaultValue: {
        summary: _charts.Position.Bottom
      }
    },
    options: Object.values(_charts.Position),
    control: {
      type: 'select'
    }
  },
  truncateLegend: {
    name: `${visConfigName}.truncateLegend`,
    description: 'Truncate too long legend',
    type: {
      name: 'boolean',
      required: false
    },
    table: {
      type: {
        summary: 'boolean'
      }
    },
    control: {
      type: 'boolean'
    }
  },
  maxLegendLines: {
    name: `${visConfigName}.maxLegendLines`,
    description: 'Legend maximum number of lines',
    type: {
      name: 'number',
      required: false
    },
    table: {
      type: {
        summary: 'number'
      }
    },
    control: {
      type: 'number'
    }
  },
  palette: {
    name: `${visConfigName}.palette`,
    description: 'Palette',
    type: {
      name: 'other',
      required: true,
      value: 'string'
    },
    table: {
      type: {
        summary: 'object'
      }
    },
    control: {
      type: 'object'
    }
  },
  labels: {
    name: `${visConfigName}.labels`,
    description: 'Labels configuration',
    type: {
      name: 'other',
      required: false,
      value: 'string'
    },
    table: {
      type: {
        summary: 'object',
        detail: `Labels configuration consists of further fields:
  - show: boolean. Default: true.
  - position: string. Options: 'default', 'inside'. Default: 'default'.
  - values: boolean. Default: true.
  - percentDecimals: number. Default: 2.
  - last_level: boolean. Default: false. DEPRECATED.
  - truncate: number. Default: null.
  - valuesFormat: string. Options: 'percent', 'value'. Default: percent.
        `
      }
    },
    control: {
      type: 'object'
    }
  },
  dimensions: {
    name: `${visConfigName}.dimensions`,
    description: 'dimensions configuration',
    type: {
      name: 'other',
      required: false,
      value: 'string'
    },
    table: {
      type: {
        summary: 'object',
        detail: `Dimensions configuration consists of two fields:
  - metric: visdimension.
  - buckets: visdimension[].
        `
      }
    },
    control: {
      type: 'object'
    }
  }
};
const pieDonutArgTypes = exports.pieDonutArgTypes = {
  ...argTypes,
  visType: {
    name: `visType`,
    description: 'Type of the chart',
    type: {
      name: 'string',
      required: false
    },
    table: {
      type: {
        summary: 'string'
      },
      defaultValue: {
        summary: `${_types.ChartTypes.PIE} | ${_types.ChartTypes.DONUT}`
      }
    },
    control: {
      type: 'text',
      disable: true
    }
  },
  isDonut: {
    name: `${visConfigName}.isDonut`,
    description: 'Render a donut chart',
    type: {
      name: 'boolean',
      required: false
    },
    table: {
      type: {
        summary: 'boolean'
      }
    },
    control: {
      type: 'boolean'
    }
  },
  emptySizeRatio: {
    name: `${visConfigName}.emptySizeRatio`,
    description: 'The hole size of the donut chart',
    type: {
      name: 'number',
      required: false
    },
    table: {
      type: {
        summary: 'number'
      }
    },
    options: [_common.EmptySizeRatios.SMALL, _common.EmptySizeRatios.MEDIUM, _common.EmptySizeRatios.LARGE],
    control: {
      type: 'select'
    }
  },
  distinctColors: {
    name: `${visConfigName}.distinctColors`,
    description: 'Enable distinct colors',
    type: {
      name: 'boolean',
      required: false
    },
    table: {
      type: {
        summary: 'boolean'
      }
    },
    control: {
      type: 'boolean'
    }
  },
  respectSourceOrder: {
    name: `${visConfigName}.respectSourceOrder`,
    description: 'Save default order of the incomming data',
    type: {
      name: 'boolean',
      required: false
    },
    table: {
      type: {
        summary: 'boolean'
      }
    },
    control: {
      type: 'boolean'
    }
  },
  startFromSecondLargestSlice: {
    name: `${visConfigName}.startFromSecondLargestSlice`,
    description: 'Start placement of slices from the second largest slice',
    type: {
      name: 'boolean',
      required: false
    },
    table: {
      type: {
        summary: 'boolean'
      }
    },
    control: {
      type: 'boolean'
    }
  },
  nestedLegend: {
    name: `${visConfigName}.nestedLegend`,
    description: 'Enable nested legend',
    type: {
      name: 'boolean',
      required: false
    },
    table: {
      type: {
        summary: 'boolean'
      }
    },
    control: {
      type: 'boolean'
    }
  }
};
const treemapArgTypes = exports.treemapArgTypes = {
  visType: {
    name: `visType`,
    description: 'Type of the chart',
    type: {
      name: 'string',
      required: false
    },
    table: {
      type: {
        summary: 'string'
      },
      defaultValue: {
        summary: `${_types.ChartTypes.TREEMAP}`
      }
    },
    control: {
      type: 'text',
      disable: true
    }
  },
  ...argTypes,
  nestedLegend: {
    name: `${visConfigName}.nestedLegend`,
    description: 'Enable nested legend',
    type: {
      name: 'boolean',
      required: false
    },
    table: {
      type: {
        summary: 'boolean'
      }
    },
    control: {
      type: 'boolean'
    }
  }
};
const mosaicArgTypes = exports.mosaicArgTypes = {
  visType: {
    name: `visType`,
    description: 'Type of the chart',
    type: {
      name: 'string',
      required: false
    },
    table: {
      type: {
        summary: 'string'
      },
      defaultValue: {
        summary: `${_types.ChartTypes.MOSAIC}`
      }
    },
    control: {
      type: 'text',
      disable: true
    }
  },
  ...argTypes,
  nestedLegend: {
    name: `${visConfigName}.nestedLegend`,
    description: 'Enable nested legend',
    type: {
      name: 'boolean',
      required: false
    },
    table: {
      type: {
        summary: 'boolean'
      }
    },
    control: {
      type: 'boolean'
    }
  }
};
const waffleArgTypes = exports.waffleArgTypes = {
  visType: {
    name: `visType`,
    description: 'Type of the chart',
    type: {
      name: 'string',
      required: false
    },
    table: {
      type: {
        summary: 'string'
      },
      defaultValue: {
        summary: `${_types.ChartTypes.WAFFLE}`
      }
    },
    control: {
      type: 'text',
      disable: true
    }
  },
  ...argTypes,
  legendStats: {
    name: `${visConfigName}.legendStats`,
    description: 'Legend stats',
    type: {
      name: 'string',
      required: false
    },
    table: {
      type: {
        summary: 'string'
      },
      defaultValue: {
        summary: undefined
      }
    },
    options: [_charts.LegendValue.Value],
    control: {
      type: 'select'
    }
  }
};