"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApiKeyConfig = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _api = require("../../../../../../common/types/api");
var _generate_connector_api_key_api_logic = require("../../../api/connector/generate_connector_api_key_api_logic");
var _api_key = require("../../api_key/api_key");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfirmModal = ({
  onCancel,
  onConfirm
}) => {
  const confirmModalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": confirmModalTitleId,
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.apiKey.confirmModal.title', {
      defaultMessage: 'Generate an Elasticsearch API key'
    }),
    titleProps: {
      id: confirmModalTitleId
    },
    onCancel: onCancel,
    onConfirm: onConfirm,
    cancelButtonText: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.apiKey.confirmModal.cancelButton.label', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.apiKey.confirmModal.confirmButton.label', {
      defaultMessage: 'Generate API key'
    }),
    defaultFocusedButton: "confirm"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.apiKey.confirmModal.description', {
    defaultMessage: 'Generating a new API key will invalidate the previous key. Are you sure you want to generate a new API key? This can not be undone.'
  }));
};
const ApiKeyConfig = ({
  hasApiKey,
  indexName,
  isNative
}) => {
  const {
    makeRequest,
    apiReset
  } = (0, _kea.useActions)(_generate_connector_api_key_api_logic.GenerateConnectorApiKeyApiLogic);
  const {
    data,
    status
  } = (0, _kea.useValues)(_generate_connector_api_key_api_logic.GenerateConnectorApiKeyApiLogic);
  (0, _react.useEffect)(() => {
    apiReset();
    return apiReset;
  }, [indexName]);
  const clickGenerateApiKey = () => {
    if (hasApiKey || data) {
      setIsModalVisible(true);
    } else {
      makeRequest({
        indexName,
        isNative
      });
    }
  };
  const [isModalVisible, setIsModalVisible] = (0, _react.useState)(false);
  const onCancel = () => {
    setIsModalVisible(false);
  };
  const onConfirm = () => {
    makeRequest({
      indexName,
      isNative
    });
    setIsModalVisible(false);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, isModalVisible && /*#__PURE__*/_react.default.createElement(ConfirmModal, {
    onCancel: onCancel,
    onConfirm: onConfirm
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, isNative ? _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.nativeConnector.apiKey.description', {
    defaultMessage: `This Elastic managed connector's API key {apiKeyName} is managed internally by Elasticsearch. The connector uses this API key to index documents into the {indexName} index. To refresh your API key, click "Generate API key".`,
    values: {
      apiKeyName: `${indexName}-connector`,
      indexName
    }
  }) : _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.apiKey.description', {
    defaultMessage: 'First, generate an Elasticsearch API key. This {apiKeyName} key will enable read and write permissions for the connector to index documents to the created {indexName} index. Save the key in a safe place, as you will need it to configure your connector.',
    values: {
      apiKeyName: `${indexName}-connector`,
      indexName
    }
  }))), !isNative || status === _api.Status.LOADING ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null) : indexName === '' ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "info",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.configurationConnector.nativeConnector.apiKey.waitingForAttachedIndex', {
      defaultMessage: 'An API key will be automatically generated when an index is attached to this connector.'
    })
  }) : !hasApiKey ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "warning",
    color: "danger",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.configurationConnector.nativeConnector.apiKey.missing', {
      defaultMessage: 'This connector is missing an API key.'
    })
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "enterpriseSearchApiKeyConfigGenerateApiKeyButton",
    onClick: clickGenerateApiKey,
    isLoading: status === _api.Status.LOADING,
    isDisabled: indexName.length === 0,
    "data-telemetry-id": "entSearch-content-connector-generateApiKeyButton"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.apiKey.button.label', {
    defaultMessage: 'Generate API key'
  }))), status === _api.Status.SUCCESS && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "success",
    size: "s",
    iconType: "check",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.apiKeyConfig.newApiKeyCreatedCalloutLabel",
      defaultMessage: "New API key created succesfully"
    })
  })))), data && !isNative && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_api_key.ApiKey, {
    apiKey: data === null || data === void 0 ? void 0 : data.encoded,
    label: _i18n.i18n.translate('xpack.enterpriseSearch.apiKeyConfig.apiKey.apiKeyLabel', {
      defaultMessage: 'API Key'
    })
  }))));
};
exports.ApiKeyConfig = ApiKeyConfig;