"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.discardPreviousGenerations = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const discardPreviousGenerations = ({
  generationAttempts,
  hallucinationFailures,
  isHallucinationDetected,
  state
}) => {
  return {
    ...state,
    combinedGenerations: '',
    // <-- reset the combined generations
    generationAttempts: generationAttempts + 1,
    generations: [],
    // <-- reset the generations
    hallucinationFailures: isHallucinationDetected ? hallucinationFailures + 1 : hallucinationFailures
  };
};
exports.discardPreviousGenerations = discardPreviousGenerations;