"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGenerateOrRefineOrEndEdge = void 0;
var _get_generate_or_refine_or_end_decision = require("./helpers/get_generate_or_refine_or_end_decision");
var _get_max_hallucination_failures_reached = require("../../helpers/get_max_hallucination_failures_reached");
var _get_max_retries_reached = require("../../helpers/get_max_retries_reached");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getGenerateOrRefineOrEndEdge = logger => {
  const edge = state => {
    logger === null || logger === void 0 ? void 0 : logger.debug(() => '---GENERATE OR REFINE OR END---');
    const {
      anonymizedDocuments,
      generationAttempts,
      hallucinationFailures,
      maxGenerationAttempts,
      maxHallucinationFailures,
      unrefinedResults
    } = state;
    const hasZeroDocs = !anonymizedDocuments.length;
    const hasUnrefinedResults = unrefinedResults !== null;
    const maxRetriesReached = (0, _get_max_retries_reached.getMaxRetriesReached)({
      generationAttempts,
      maxGenerationAttempts
    });
    const maxHallucinationFailuresReached = (0, _get_max_hallucination_failures_reached.getMaxHallucinationFailuresReached)({
      hallucinationFailures,
      maxHallucinationFailures
    });
    const decision = (0, _get_generate_or_refine_or_end_decision.getGenerateOrRefineOrEndDecision)({
      hasUnrefinedResults,
      hasZeroDocs,
      maxHallucinationFailuresReached,
      maxRetriesReached
    });
    logger === null || logger === void 0 ? void 0 : logger.debug(() => {
      var _unrefinedResults$len;
      return `generatOrRefineOrEndEdge evaluated the following (derived) state:\n${JSON.stringify({
        anonymizedDocuments: anonymizedDocuments.length,
        generationAttempts,
        hallucinationFailures,
        hasUnrefinedResults,
        hasZeroDocs,
        maxHallucinationFailuresReached,
        maxRetriesReached,
        unrefinedResults: (_unrefinedResults$len = unrefinedResults === null || unrefinedResults === void 0 ? void 0 : unrefinedResults.length) !== null && _unrefinedResults$len !== void 0 ? _unrefinedResults$len : 0
      }, null, 2)}
        \n---GENERATE OR REFINE OR END: ${decision}---`;
    });
    return decision;
  };
  return edge;
};
exports.getGenerateOrRefineOrEndEdge = getGenerateOrRefineOrEndEdge;