"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFlattenedSpanDocumentOverview = getFlattenedSpanDocumentOverview;
exports.getSpanDocumentOverview = getSpanDocumentOverview;
var _ = require("..");
var _get_formatted_fields = require("./get_formatted_fields");
var _get_flattened_fields = require("./get_flattened_fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const fields = [_.fieldConstants.TIMESTAMP_FIELD, _.fieldConstants.PARENT_ID_FIELD, _.fieldConstants.HTTP_RESPONSE_STATUS_CODE_FIELD, _.fieldConstants.TRACE_ID_FIELD, _.fieldConstants.SERVICE_NAME_FIELD, _.fieldConstants.SERVICE_ENVIRONMENT_FIELD, _.fieldConstants.AGENT_NAME_FIELD, _.fieldConstants.TRANSACTION_ID_FIELD, _.fieldConstants.TRANSACTION_NAME_FIELD, _.fieldConstants.SPAN_NAME_FIELD, _.fieldConstants.SPAN_ID_FIELD, _.fieldConstants.SPAN_ACTION_FIELD, _.fieldConstants.SPAN_DURATION_FIELD, _.fieldConstants.SPAN_TYPE_FIELD, _.fieldConstants.SPAN_SUBTYPE_FIELD, _.fieldConstants.SPAN_DESTINATION_SERVICE_RESOURCE_FIELD, _.fieldConstants.USER_AGENT_NAME_FIELD, _.fieldConstants.USER_AGENT_VERSION_FIELD, _.fieldConstants.PROCESSOR_EVENT_FIELD, _.fieldConstants.OTEL_DURATION, _.fieldConstants.OTEL_SPAN_KIND];
function getSpanDocumentOverview(doc, {
  dataView,
  fieldFormats
}) {
  return (0, _get_formatted_fields.getFormattedFields)(doc, fields, {
    dataView,
    fieldFormats
  });
}
function getFlattenedSpanDocumentOverview(doc) {
  return (0, _get_flattened_fields.getFlattenedFields)(doc, fields);
}