"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerGetDataViewRouteLegacy = exports.registerGetDataViewRoute = exports.getDataView = void 0;
var _configSchema = require("@kbn/config-schema");
var _handle_errors = require("./util/handle_errors");
var _schema = require("../schema");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getDataView = async ({
  dataViewsService,
  usageCollection,
  counterName,
  id
}) => {
  usageCollection === null || usageCollection === void 0 ? void 0 : usageCollection.incrementCounter({
    counterName
  });
  return dataViewsService.getDataViewLazy(id);
};
exports.getDataView = getDataView;
const getDataViewRouteFactory = (path, serviceKey, description) => (router, getStartServices, usageCollection) => {
  router.versioned.get({
    path,
    access: 'public',
    description,
    security: {
      authz: {
        enabled: false,
        reason: 'Authorization provided by saved objects client'
      }
    }
  }).addVersion({
    version: _constants.INITIAL_REST_VERSION,
    validate: {
      request: {
        params: _configSchema.schema.object({
          id: _configSchema.schema.string({
            minLength: 1,
            maxLength: 1_000
          })
        }, {
          unknowns: 'allow'
        })
      },
      response: {
        200: {
          body: () => _configSchema.schema.object({
            [serviceKey]: _schema.dataViewSpecSchema
          })
        }
      }
    }
  }, router.handleLegacyErrors((0, _handle_errors.handleErrors)(async (ctx, req, res) => {
    const core = await ctx.core;
    const savedObjectsClient = core.savedObjects.client;
    const elasticsearchClient = core.elasticsearch.client.asCurrentUser;
    const [,, {
      dataViewsServiceFactory
    }] = await getStartServices();
    const dataViewsService = await dataViewsServiceFactory(savedObjectsClient, elasticsearchClient, req);
    const id = req.params.id;
    const dataView = await getDataView({
      dataViewsService,
      usageCollection,
      counterName: `${req.route.method} ${path}`,
      id
    });
    const responseBody = {
      [serviceKey]: {
        ...(await dataView.toSpec({
          fieldParams: {
            fieldName: ['*']
          }
        })),
        namespaces: dataView.namespaces
      }
    };
    return res.ok({
      headers: {
        'content-type': 'application/json'
      },
      body: responseBody
    });
  })));
};
const registerGetDataViewRoute = exports.registerGetDataViewRoute = getDataViewRouteFactory(_constants.SPECIFIC_DATA_VIEW_PATH, _constants.SERVICE_KEY, _constants.GET_DATA_VIEW_DESCRIPTION);
const registerGetDataViewRouteLegacy = exports.registerGetDataViewRouteLegacy = getDataViewRouteFactory(_constants.SPECIFIC_DATA_VIEW_PATH_LEGACY, _constants.SERVICE_KEY_LEGACY);