"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformPanelsIn = transformPanelsIn;
var _uuid = require("uuid");
var _common = require("../../../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function transformPanelsIn(widgets, dropSections = false) {
  const panels = [];
  const sections = [];
  widgets === null || widgets === void 0 ? void 0 : widgets.forEach(widget => {
    if ((0, _common.isDashboardSection)(widget)) {
      var _gridData$i;
      const {
        panels: sectionPanels,
        gridData,
        ...restOfSection
      } = widget;
      const idx = (_gridData$i = gridData.i) !== null && _gridData$i !== void 0 ? _gridData$i : (0, _uuid.v4)();
      sections.push({
        ...restOfSection,
        gridData: {
          ...gridData,
          i: idx
        }
      });
      sectionPanels.forEach(panel => {
        const transformed = transformPanel(panel);
        panels.push({
          ...transformed,
          gridData: {
            ...transformed.gridData,
            ...(!dropSections && {
              sectionId: idx
            })
          }
        });
      });
    } else {
      // widget is a panel
      panels.push(transformPanel(widget));
    }
  });
  return {
    panelsJSON: JSON.stringify(panels),
    sections
  };
}
function transformPanel(panel) {
  const {
    panelIndex,
    gridData,
    panelConfig,
    ...restPanel
  } = panel;
  const idx = panelIndex !== null && panelIndex !== void 0 ? panelIndex : (0, _uuid.v4)();
  return {
    ...restPanel,
    embeddableConfig: panelConfig,
    panelIndex: idx,
    gridData: {
      ...gridData,
      i: idx
    }
  };
}