"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentlessConnectorStatusBadge = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _uiTheme = require("@kbn/ui-theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AgentlessConnectorStatusBadge = ({
  status,
  ...restOfProps
}) => {
  switch (status) {
    case 'error':
    case 'degraded':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
        color: "warning"
      }, restOfProps), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.contentConnectors.connectors.elasticManaged.agentHealth.unhealthyStatusText",
        defaultMessage: "Unhealthy"
      }));
    case 'inactive':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
        color: _uiTheme.euiLightVars.euiColorDarkShade
      }, restOfProps), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.contentConnectors.connectors.elasticManaged.agentHealth.inactiveStatusText",
        defaultMessage: "Inactive"
      }));
    case 'offline':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
        color: "default"
      }, restOfProps), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.contentConnectors.connectors.elasticManaged.agentHealth.offlineStatusText",
        defaultMessage: "Offline"
      }));
    case 'uninstalled':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
        color: "default"
      }, restOfProps), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.contentConnectors.connectors.elasticManaged.agentHealth.uninstalledStatusText",
        defaultMessage: "Uninstalled"
      }));
    case 'orphaned':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
        color: "warning"
      }, restOfProps), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.contentConnectors.connectors.elasticManaged.agentHealth.orphanedStatusText",
        defaultMessage: "Orphaned"
      }));
    case 'unenrolling':
    case 'enrolling':
    case 'updating':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
        color: "primary"
      }, restOfProps), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.contentConnectors.connectors.elasticManaged.agentHealth.updatingStatusText",
        defaultMessage: "Updating"
      }));
    case 'unenrolled':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
        color: _uiTheme.euiLightVars.euiColorDisabled
      }, restOfProps), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.contentConnectors.connectors.elasticManaged.agentHealth.unenrolledStatusText",
        defaultMessage: "Unenrolled"
      }));
    default:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
        color: "success"
      }, restOfProps), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.contentConnectors.connectors.elasticManaged.agentHealth.healthyStatusText",
        defaultMessage: "Healthy"
      }));
  }
};
exports.AgentlessConnectorStatusBadge = AgentlessConnectorStatusBadge;