"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "getBackwardCompatibleDocumentTypeFilter", {
  enumerable: true,
  get: function () {
    return _utils.getBackwardCompatibleDocumentTypeFilter;
  }
});
exports.getDurationFieldForTransactions = getDurationFieldForTransactions;
exports.getHasTransactionsEvents = getHasTransactionsEvents;
exports.getProcessorEventForTransactions = getProcessorEventForTransactions;
exports.getSearchTransactionsEvents = getSearchTransactionsEvents;
exports.isDurationSummaryNotSupportedFilter = isDurationSummaryNotSupportedFilter;
exports.isRootTransaction = isRootTransaction;
exports.isSummaryFieldSupportedByDocType = isSummaryFieldSupportedByDocType;
var _server = require("@kbn/observability-plugin/server");
var _common = require("@kbn/observability-plugin/common");
var _aggregated_transactions = require("../../../../common/aggregated_transactions");
var _apm = require("../../../../common/es_fields/apm");
var _document_type = require("../../../../common/document_type");
var _utils = require("@kbn/apm-data-access-plugin/server/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getHasTransactionsEvents({
  start,
  end,
  apmEventClient,
  kuery
}) {
  const response = await apmEventClient.search('get_has_aggregated_transactions', {
    apm: {
      events: [_common.ProcessorEvent.metric]
    },
    track_total_hits: 1,
    terminate_after: 1,
    size: 0,
    query: {
      bool: {
        filter: [{
          exists: {
            field: _apm.TRANSACTION_DURATION_HISTOGRAM
          }
        }, ...(start && end ? (0, _server.rangeQuery)(start, end) : []), ...(0, _server.kqlQuery)(kuery)]
      }
    }
  });
  return response.hits.total.value > 0;
}
async function getSearchTransactionsEvents({
  config,
  start,
  end,
  apmEventClient,
  kuery
}) {
  switch (config.searchAggregatedTransactions) {
    case _aggregated_transactions.SearchAggregatedTransactionSetting.always:
      return kuery ? getHasTransactionsEvents({
        start,
        end,
        apmEventClient,
        kuery
      }) : true;
    case _aggregated_transactions.SearchAggregatedTransactionSetting.auto:
      return getHasTransactionsEvents({
        start,
        end,
        apmEventClient,
        kuery
      });
    case _aggregated_transactions.SearchAggregatedTransactionSetting.never:
      return false;
  }
}
function isSummaryFieldSupportedByDocType(typeOrSearchAgggregatedTransactions) {
  let type;
  if (typeOrSearchAgggregatedTransactions === true) {
    type = _document_type.ApmDocumentType.TransactionMetric;
  } else if (typeOrSearchAgggregatedTransactions === false) {
    type = _document_type.ApmDocumentType.TransactionEvent;
  } else {
    type = typeOrSearchAgggregatedTransactions;
  }
  return type === _document_type.ApmDocumentType.ServiceTransactionMetric || type === _document_type.ApmDocumentType.TransactionMetric;
}
function getDurationFieldForTransactions(typeOrSearchAgggregatedTransactions, useDurationSummaryField) {
  if (isSummaryFieldSupportedByDocType(typeOrSearchAgggregatedTransactions)) {
    if (useDurationSummaryField) {
      return _apm.TRANSACTION_DURATION_SUMMARY;
    }
    return _apm.TRANSACTION_DURATION_HISTOGRAM;
  }
  return _apm.TRANSACTION_DURATION;
}
function getProcessorEventForTransactions(searchAggregatedTransactions) {
  return searchAggregatedTransactions ? _common.ProcessorEvent.metric : _common.ProcessorEvent.transaction;
}
function isRootTransaction(searchAggregatedTransactions) {
  return searchAggregatedTransactions ? {
    term: {
      [_apm.TRANSACTION_ROOT]: true
    }
  } : {
    bool: {
      must_not: {
        exists: {
          field: _apm.PARENT_ID
        }
      }
    }
  };
}
function isDurationSummaryNotSupportedFilter() {
  return {
    bool: {
      must_not: [{
        exists: {
          field: _apm.TRANSACTION_DURATION_SUMMARY
        }
      }]
    }
  };
}