"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.homeRoute = exports.ServiceMapTitle = exports.ServiceInventoryTitle = exports.DependenciesOperationsTitle = void 0;
var _i18n = require("@kbn/i18n");
var _ioTsUtils = require("@kbn/io-ts-utils");
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var t = _interopRequireWildcard(require("io-ts"));
var _react = _interopRequireDefault(require("react"));
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _comparison_rt = require("../../../../common/comparison_rt");
var _environment_filter_values = require("../../../../common/environment_filter_values");
var _environment_rt = require("../../../../common/environment_rt");
var _trace_explorer = require("../../../../common/trace_explorer");
var _time_range_metadata_context = require("../../../context/time_range_metadata/time_range_metadata_context");
var _redirect_to = require("../redirect_to");
var _dependencies = require("./dependencies");
var _legacy_backends = require("./legacy_backends");
var _storage_explorer = require("./storage_explorer");
var _transaction_tabs = require("../../app/transaction_details/waterfall_with_summary/transaction_tabs");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ServiceGroupTemplate = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../templates/service_group_template'))).then(mod => ({
  default: mod.ServiceGroupTemplate
})));
const ServiceInventory = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../../app/service_inventory'))).then(mod => ({
  default: mod.ServiceInventory
})));
const ServiceMapHome = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../../app/service_map'))).then(mod => ({
  default: mod.ServiceMapHome
})));
const TopTracesOverview = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../../app/top_traces_overview'))).then(mod => ({
  default: mod.TopTracesOverview
})));
const TraceExplorer = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../../app/trace_explorer'))).then(mod => ({
  default: mod.TraceExplorer
})));
const TraceExplorerWaterfall = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../../app/trace_explorer/trace_explorer_waterfall'))).then(mod => ({
  default: mod.TraceExplorerWaterfall
})));
const TraceOverview = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../../app/trace_overview'))).then(mod => ({
  default: mod.TraceOverview
})));
function serviceGroupPage({
  path,
  element,
  title,
  serviceGroupContextTab
}) {
  return {
    [path]: {
      element: /*#__PURE__*/_react.default.createElement(ServiceGroupTemplate, {
        pageTitle: title,
        pagePath: path,
        serviceGroupContextTab: serviceGroupContextTab
      }, element),
      params: t.type({
        query: t.type({
          serviceGroup: t.string
        })
      }),
      defaults: {
        query: {
          serviceGroup: ''
        }
      }
    }
  };
}
const ServiceInventoryTitle = exports.ServiceInventoryTitle = _i18n.i18n.translate('xpack.apm.views.serviceInventory.title', {
  defaultMessage: 'Services'
});
const ServiceMapTitle = exports.ServiceMapTitle = _i18n.i18n.translate('xpack.apm.views.serviceMap.title', {
  defaultMessage: 'Service Map'
});
const DependenciesOperationsTitle = exports.DependenciesOperationsTitle = _i18n.i18n.translate('xpack.apm.views.dependenciesOperations.title', {
  defaultMessage: 'Operations'
});
const homeRoute = exports.homeRoute = {
  '/': {
    element: /*#__PURE__*/_react.default.createElement(_time_range_metadata_context.ApmTimeRangeMetadataContextProvider, null, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.Outlet, null)),
    params: t.type({
      query: t.intersection([_environment_rt.environmentRt, t.type({
        rangeFrom: t.string,
        rangeTo: t.string,
        kuery: t.string,
        comparisonEnabled: _ioTsUtils.toBooleanRt
      }), t.partial({
        refreshPaused: t.union([t.literal('true'), t.literal('false')]),
        refreshInterval: t.string,
        page: _ioTsUtils.toNumberRt,
        pageSize: _ioTsUtils.toNumberRt,
        sortField: t.string,
        sortDirection: t.union([t.literal('asc'), t.literal('desc')])
      }), _comparison_rt.offsetRt])
    }),
    defaults: {
      query: {
        environment: _environment_filter_values.ENVIRONMENT_ALL.value,
        kuery: ''
      }
    },
    children: {
      ...serviceGroupPage({
        path: '/services',
        title: ServiceInventoryTitle,
        element: /*#__PURE__*/_react.default.createElement(ServiceInventory, null),
        serviceGroupContextTab: 'service-inventory'
      }),
      ...serviceGroupPage({
        path: '/service-map',
        title: ServiceMapTitle,
        element: /*#__PURE__*/_react.default.createElement(ServiceMapHome, null),
        serviceGroupContextTab: 'service-map'
      }),
      '/traces': {
        element: /*#__PURE__*/_react.default.createElement(TraceOverview, null, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.Outlet, null)),
        children: {
          '/traces/explorer': {
            element: /*#__PURE__*/_react.default.createElement(TraceExplorer, null, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.Outlet, null)),
            children: {
              '/traces/explorer/waterfall': {
                element: /*#__PURE__*/_react.default.createElement(TraceExplorerWaterfall, null),
                params: t.type({
                  query: t.intersection([t.type({
                    traceId: t.string,
                    transactionId: t.string,
                    waterfallItemId: t.string,
                    detailTab: t.union([t.literal(_transaction_tabs.TransactionTab.timeline), t.literal(_transaction_tabs.TransactionTab.metadata), t.literal(_transaction_tabs.TransactionTab.logs)])
                  }), t.partial({
                    flyoutDetailTab: t.string
                  })])
                }),
                defaults: {
                  query: {
                    waterfallItemId: '',
                    traceId: '',
                    transactionId: '',
                    detailTab: _transaction_tabs.TransactionTab.timeline
                  }
                }
              },
              '/traces/explorer': {
                element: /*#__PURE__*/_react.default.createElement(_redirect_to.RedirectTo, {
                  pathname: "/traces/explorer/waterfall"
                })
              }
            },
            params: t.type({
              query: t.type({
                query: t.string,
                type: t.union([t.literal(_trace_explorer.TraceSearchType.kql), t.literal(_trace_explorer.TraceSearchType.eql)]),
                showCriticalPath: _ioTsUtils.toBooleanRt
              })
            }),
            defaults: {
              query: {
                query: '',
                type: _trace_explorer.TraceSearchType.kql,
                showCriticalPath: ''
              }
            }
          },
          '/traces': {
            element: /*#__PURE__*/_react.default.createElement(TopTracesOverview, null)
          }
        }
      },
      ..._dependencies.dependencies,
      ..._legacy_backends.legacyBackends,
      ..._storage_explorer.storageExplorer,
      '/': {
        element: /*#__PURE__*/_react.default.createElement(_redirect_to.RedirectTo, {
          pathname: "/services"
        })
      }
    }
  }
};