"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentConfigurationList = AgentConfigurationList;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _use_apm_router = require("../../../../../hooks/use_apm_router");
var _all_option = require("../../../../../../common/agent_configuration/all_option");
var _use_apm_plugin_context = require("../../../../../context/apm_plugin/use_apm_plugin_context");
var _use_fetcher = require("../../../../../hooks/use_fetcher");
var _loading_state_prompt = require("../../../../shared/loading_state_prompt");
var _managed_table = require("../../../../shared/managed_table");
var _timestamp_tooltip = require("../../../../shared/timestamp_tooltip");
var _confirm_delete_modal = require("./confirm_delete_modal");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AgentConfigurationList({
  status,
  configurations,
  refetch
}) {
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const canSave = core.application.capabilities.apm['settings:save'];
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [configToBeDeleted, setConfigToBeDeleted] = (0, _react.useState)(null);
  const apmRouter = (0, _use_apm_router.useApmRouter)();
  const createAgentConfigurationHref = apmRouter.link('/settings/agent-configuration/create');
  const emptyStatePrompt = /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "controlsHorizontal",
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.apm.agentConfig.configTable.emptyPromptTitle', {
      defaultMessage: 'No configurations found.'
    })),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: !canSave && _i18n.i18n.translate('xpack.apm.settings.agentConfig.createConfigButton.tooltip', {
        defaultMessage: "You don't have permissions to create agent configurations"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "apmAgentConfigurationListCreateConfigurationButton",
      color: "primary",
      fill: true,
      href: createAgentConfigurationHref,
      isDisabled: !canSave
    }, _i18n.i18n.translate('xpack.apm.agentConfig.configTable.createConfigButtonLabel', {
      defaultMessage: 'Create configuration'
    })))
  });
  const failurePrompt = /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "warning",
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.apm.agentConfig.configTable.configTable.failurePromptText', {
      defaultMessage: 'The list of agent configurations could not be fetched. Your user may not have the sufficient permissions.'
    })))
  });
  if (status === _use_fetcher.FETCH_STATUS.FAILURE) {
    return failurePrompt;
  }
  if (status === _use_fetcher.FETCH_STATUS.SUCCESS && (0, _lodash.isEmpty)(configurations)) {
    return emptyStatePrompt;
  }
  const columns = [{
    field: 'applied_by_agent',
    align: 'center',
    width: euiTheme.size.xl,
    name: '',
    sortable: true,
    render: (_, {
      applied_by_agent: appliedByAgent
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: appliedByAgent ? _i18n.i18n.translate('xpack.apm.agentConfig.configTable.appliedTooltipMessage', {
        defaultMessage: 'Applied by at least one agent'
      }) : _i18n.i18n.translate('xpack.apm.agentConfig.configTable.notAppliedTooltipMessage', {
        defaultMessage: 'Not yet applied by any agents'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: appliedByAgent ? 'success' : euiTheme.colors.lightShade
    }))
  }, {
    field: 'service.name',
    name: _i18n.i18n.translate('xpack.apm.agentConfig.configTable.serviceNameColumnLabel', {
      defaultMessage: 'Service name'
    }),
    sortable: true,
    render: (_, config) => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "apmColumnsButton",
      flush: "left",
      size: "s",
      color: "primary",
      href: apmRouter.link('/settings/agent-configuration/edit', {
        query: {
          name: config.service.name,
          environment: config.service.environment
        }
      })
    }, (0, _all_option.getOptionLabel)(config.service.name))
  }, {
    field: 'service.environment',
    name: _i18n.i18n.translate('xpack.apm.agentConfig.configTable.environmentColumnLabel', {
      defaultMessage: 'Service environment'
    }),
    sortable: true,
    render: (_, {
      service
    }) => (0, _all_option.getOptionLabel)(service.environment)
  }, {
    align: _eui.RIGHT_ALIGNMENT,
    field: '@timestamp',
    name: _i18n.i18n.translate('xpack.apm.agentConfig.configTable.lastUpdatedColumnLabel', {
      defaultMessage: 'Last updated'
    }),
    sortable: true,
    render: (_, item) => /*#__PURE__*/_react.default.createElement(_timestamp_tooltip.TimestampTooltip, {
      time: item['@timestamp'],
      timeUnit: "minutes"
    })
  }, ...(canSave ? [{
    width: euiTheme.size.xl,
    name: '',
    render: config => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "apmColumnsButton",
      "aria-label": _i18n.i18n.translate('xpack.apm.columns.euiButtonIcon.editLabel', {
        defaultMessage: 'Edit'
      }),
      iconType: "pencil",
      href: apmRouter.link('/settings/agent-configuration/edit', {
        query: {
          name: config.service.name,
          environment: config.service.environment
        }
      })
    })
  }, {
    width: euiTheme.size.xl,
    name: '',
    render: config => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "apmColumnsButton",
      "aria-label": _i18n.i18n.translate('xpack.apm.columns.euiButtonIcon.deleteLabel', {
        defaultMessage: 'Delete'
      }),
      iconType: "trash",
      onClick: () => setConfigToBeDeleted(config)
    })
  }] : [])];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, configToBeDeleted && /*#__PURE__*/_react.default.createElement(_confirm_delete_modal.ConfirmDeleteModal, {
    config: configToBeDeleted,
    onCancel: () => setConfigToBeDeleted(null),
    onConfirm: () => {
      setConfigToBeDeleted(null);
      refetch();
    }
  }), /*#__PURE__*/_react.default.createElement(_managed_table.ManagedTable, {
    noItemsMessage: /*#__PURE__*/_react.default.createElement(_loading_state_prompt.LoadingStatePrompt, null),
    columns: columns,
    items: configurations,
    initialSortField: "service.name",
    initialSortDirection: "asc",
    initialPageSize: 25
  }));
}