"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JvmMetricsOverview = JvmMetricsOverview;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _service_nodes = require("../../../../../common/service_nodes");
var _formatters = require("../../../../../common/utils/formatters");
var _use_apm_service_context = require("../../../../context/apm_service/use_apm_service_context");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_time_range = require("../../../../hooks/use_time_range");
var _style = require("../../../../utils/style");
var _service_node_metric_overview_link = require("../../../shared/links/apm/service_node_metric_overview_link");
var _managed_table = require("../../../shared/managed_table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INITIAL_SORT_FIELD = 'cpu';
const INITIAL_SORT_DIRECTION = 'desc';
const ServiceNodeName = _styled.default.div`
  ${(0, _style.truncate)(8 * _style.unit)}
`;
function JvmMetricsOverview() {
  var _data$serviceNodes;
  const {
    query: {
      environment,
      kuery,
      rangeFrom,
      rangeTo
    }
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}/metrics');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    serviceName
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (!start || !end) {
      return undefined;
    }
    return callApmApi('GET /internal/apm/services/{serviceName}/metrics/nodes', {
      params: {
        path: {
          serviceName
        },
        query: {
          kuery,
          environment,
          start,
          end
        }
      }
    });
  }, [kuery, environment, serviceName, start, end]);
  const items = (_data$serviceNodes = data === null || data === void 0 ? void 0 : data.serviceNodes) !== null && _data$serviceNodes !== void 0 ? _data$serviceNodes : [];
  const columns = [{
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.apm.jvmsTable.nameExplanation', {
        defaultMessage: `By default, the JVM name is the container ID (where applicable) or the hostname, but it can be manually configured through the agent's 'service_node_name' configuration.`
      })
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.apm.jvmsTable.nameColumnLabel', {
      defaultMessage: 'Name'
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      color: "subdued",
      type: "question",
      className: "eui-alignTop"
    }))),
    field: 'name',
    sortable: true,
    render: (_, {
      name
    }) => {
      const {
        displayedName,
        tooltip
      } = name === _service_nodes.SERVICE_NODE_NAME_MISSING ? {
        displayedName: (0, _service_nodes.getServiceNodeName)(name),
        tooltip: _i18n.i18n.translate('xpack.apm.jvmsTable.explainServiceNodeNameMissing', {
          defaultMessage: 'We could not identify which JVMs these metrics belong to. This is likely caused by running a version of APM Server that is older than 7.5. Upgrading to APM Server 7.5 or higher should resolve this issue.'
        })
      } : {
        displayedName: name,
        tooltip: name
      };
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: tooltip
      }, /*#__PURE__*/_react.default.createElement(_service_node_metric_overview_link.ServiceNodeMetricOverviewLink, {
        serviceName: serviceName,
        serviceNodeName: name
      }, /*#__PURE__*/_react.default.createElement(ServiceNodeName, null, displayedName)));
    }
  }, {
    name: _i18n.i18n.translate('xpack.apm.jvmsTable.hostName', {
      defaultMessage: 'Host name'
    }),
    field: 'hostName',
    sortable: true,
    render: (_, {
      hostName
    }) => hostName !== null && hostName !== void 0 ? hostName : ''
  }, {
    name: _i18n.i18n.translate('xpack.apm.jvmsTable.cpuColumnLabel', {
      defaultMessage: 'CPU avg'
    }),
    field: 'cpu',
    dataType: 'number',
    sortable: true,
    render: (_, {
      cpu
    }) => (0, _formatters.asPercent)(cpu, 1)
  }, {
    name: _i18n.i18n.translate('xpack.apm.jvmsTable.heapMemoryColumnLabel', {
      defaultMessage: 'Heap memory avg'
    }),
    field: 'heapMemory',
    dataType: 'number',
    sortable: true,
    render: _formatters.asDynamicBytes
  }, {
    name: _i18n.i18n.translate('xpack.apm.jvmsTable.nonHeapMemoryColumnLabel', {
      defaultMessage: 'Non-heap memory avg'
    }),
    field: 'nonHeapMemory',
    dataType: 'number',
    sortable: true,
    render: _formatters.asDynamicBytes
  }, {
    name: _i18n.i18n.translate('xpack.apm.jvmsTable.threadCountColumnLabel', {
      defaultMessage: 'Thread count max'
    }),
    field: 'threadCount',
    dataType: 'number',
    sortable: true,
    render: _formatters.asInteger
  }];
  return /*#__PURE__*/_react.default.createElement(_managed_table.ManagedTable, {
    isLoading: status === _use_fetcher.FETCH_STATUS.LOADING,
    noItemsMessage: _i18n.i18n.translate('xpack.apm.jvmsTable.noJvmsLabel', {
      defaultMessage: 'No JVMs were found'
    }),
    items: items,
    columns: columns,
    initialSortField: INITIAL_SORT_FIELD,
    initialSortDirection: INITIAL_SORT_DIRECTION,
    initialPageSize: 25
  });
}