"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCategorizeFieldAction = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/ui-actions-plugin/public");
var _mlUiActions = require("@kbn/ml-ui-actions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const createCategorizeFieldAction = (coreStart, plugins) => (0, _public.createAction)({
  type: _mlUiActions.ACTION_CATEGORIZE_FIELD,
  id: _mlUiActions.ACTION_CATEGORIZE_FIELD,
  getDisplayName: () => _i18n.i18n.translate('xpack.aiops.categorizeFieldAction.displayName', {
    defaultMessage: 'Pattern analysis'
  }),
  isCompatible: async ({
    field
  }) => {
    var _field$esTypes;
    return ((_field$esTypes = field.esTypes) === null || _field$esTypes === void 0 ? void 0 : _field$esTypes.includes('text')) === true;
  },
  execute: async context => {
    const {
      field,
      dataView,
      originatingApp,
      additionalFilter,
      focusTrapProps
    } = context;
    const {
      showCategorizeFlyout
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./show_flyout')));
    showCategorizeFlyout(field, dataView, coreStart, plugins, originatingApp, additionalFilter, focusTrapProps);
  }
});
exports.createCategorizeFieldAction = createCategorizeFieldAction;