"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiBasicTable = void 0;
exports.getItemId = getItemId;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _predicate = require("../../services/predicate");
var _objects = require("../../services/objects");
var _form = require("../form");
var _component_defaults = require("../provider/component_defaults");
var _table_pagination = require("../table/table_pagination");
var _table = require("../table");
var _table2 = require("../table/table.styles");
var _collapsed_item_actions = require("./collapsed_item_actions");
var _expanded_item_actions = require("./expanded_item_actions");
var _pagination_bar = require("./pagination_bar");
var _icon = require("../icon");
var _accessibility = require("../accessibility");
var _i18n = require("../i18n");
var _delay_render = require("../delay_render");
var _accessibility2 = require("../../services/accessibility");
var _basic_table = require("./basic_table.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "loading", "items", "itemId", "columns", "pagination", "sorting", "selection", "onChange", "error", "noItemsMessage", "compressed", "itemIdToExpandedRowMap", "responsiveBreakpoint", "rowProps", "cellProps", "tableCaption", "rowHeader", "tableLayout"],
  _excluded2 = ["align", "render", "dataType", "isExpander", "textOnly", "name", "field", "description", "sortable", "footer", "mobileOptions", "nameTooltip"];
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var dataTypesProfiles = {
  auto: {
    align: _services.LEFT_ALIGNMENT,
    render: function render(value) {
      return (0, _services.formatAuto)(value);
    }
  },
  string: {
    align: _services.LEFT_ALIGNMENT,
    render: function render(value) {
      return (0, _services.formatText)(value);
    }
  },
  number: {
    align: _services.RIGHT_ALIGNMENT,
    render: function render(value) {
      return (0, _services.formatNumber)(value);
    }
  },
  boolean: {
    align: _services.LEFT_ALIGNMENT,
    render: function render(value) {
      return (0, _services.formatBoolean)(value);
    }
  },
  date: {
    align: _services.LEFT_ALIGNMENT,
    render: function render(value) {
      return (0, _services.formatDate)(value);
    }
  }
};
var DATA_TYPES = Object.keys(dataTypesProfiles);
function getItemId(item, itemId) {
  if (itemId) {
    if ((0, _predicate.isFunction)(itemId)) {
      return itemId(item);
    }
    // @ts-ignore never mind about the index signature
    return item[itemId];
  }
}
function getRowProps(item, rowProps) {
  if (rowProps) {
    if ((0, _predicate.isFunction)(rowProps)) {
      return rowProps(item);
    }
    return rowProps;
  }
  return {};
}
function getCellProps(item, column, cellProps) {
  if (cellProps) {
    if ((0, _predicate.isFunction)(cellProps)) {
      return cellProps(item, column);
    }
    return cellProps;
  }
  return {};
}
function getColumnFooter(column, _ref) {
  var items = _ref.items,
    pagination = _ref.pagination;
  var _ref2 = column,
    footer = _ref2.footer;
  if (footer) {
    if ((0, _predicate.isFunction)(footer)) {
      return footer({
        items: items,
        pagination: pagination
      });
    }
    return footer;
  }
  return undefined;
}
function hasPagination(x) {
  return x.hasOwnProperty('pagination') && !!x.pagination;
}
var EuiBasicTable = exports.EuiBasicTable = /*#__PURE__*/function (_Component) {
  function EuiBasicTable(props) {
    var _this;
    _classCallCheck(this, EuiBasicTable);
    _this = _callSuper(this, EuiBasicTable, [props]);
    _defineProperty(_this, "tableId", (0, _accessibility2.htmlIdGenerator)('__table')());
    _defineProperty(_this, "selectAllIdGenerator", (0, _accessibility2.htmlIdGenerator)('_selection_column-checkbox'));
    _defineProperty(_this, "renderSelectAll", function (isMobile) {
      var _this$props = _this.props,
        items = _this$props.items,
        selection = _this$props.selection;
      if (!selection) {
        return;
      }
      var selectableItems = items.filter(function (item) {
        return !selection.selectable || selection.selectable(item);
      });
      var checked = _this.state.selection && selectableItems.length > 0 && _this.state.selection.length === selectableItems.length;
      var indeterminate = !checked && _this.state.selection && selectableItems.length > 0 && _this.state.selection.length > 0;
      var disabled = selectableItems.length === 0;
      var onChange = function onChange(event) {
        if (event.target.checked && !indeterminate) {
          _this.changeSelection(selectableItems);
        } else {
          _this.changeSelection([]);
        }
      };
      return (0, _react2.jsx)(_i18n.EuiI18n, {
        tokens: ['euiBasicTable.selectAllRows', 'euiBasicTable.deselectRows'],
        defaults: ['Select all rows', 'Deselect rows']
      }, function (_ref3) {
        var _ref4 = _slicedToArray(_ref3, 2),
          selectAllRows = _ref4[0],
          deselectRows = _ref4[1];
        return (0, _react2.jsx)(_form.EuiCheckbox, {
          id: _this.selectAllIdGenerator(),
          checked: checked,
          indeterminate: indeterminate,
          disabled: disabled,
          onChange: onChange,
          "data-test-subj": "checkboxSelectAll",
          "aria-label": checked || indeterminate ? deselectRows : selectAllRows,
          title: checked || indeterminate ? deselectRows : selectAllRows,
          label: isMobile ? selectAllRows : null
        });
      });
    });
    _defineProperty(_this, "renderCopyChar", function (columnIndex) {
      var isLastColumn = columnIndex === _this.props.columns.length - 1;
      return isLastColumn ? _services.tabularCopyMarkers.hiddenNewline : _services.tabularCopyMarkers.hiddenTab;
    });
    _defineProperty(_this, "resolveColumnSortDirection", function (column) {
      var sorting = _this.props.sorting;
      var _ref5 = column,
        sortable = _ref5.sortable,
        field = _ref5.field,
        name = _ref5.name;
      if (!sorting || !sorting.sort || !sortable) {
        return;
      }
      if (sorting.sort.field === field || sorting.sort.field === name) {
        return sorting.sort.direction;
      }
    });
    _defineProperty(_this, "resolveColumnOnSort", function (column) {
      var sorting = _this.props.sorting;
      var _ref6 = column,
        sortable = _ref6.sortable,
        name = _ref6.name;
      if (!sorting || !sortable) {
        return;
      }
      if (!_this.props.onChange) {
        throw new Error("BasicTable is configured to be sortable on column [".concat(name, "] but\n          [onChange] is not configured. This callback must be implemented to handle the sort requests"));
      }
      return function () {
        return _this.onColumnSortChange(column);
      };
    });
    _this.state = {
      // used for checking if  initial selection is rendered
      initialSelectionRendered: false,
      selection: []
    };
    return _this;
  }
  _inherits(EuiBasicTable, _Component);
  return _createClass(EuiBasicTable, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.getInitialSelection();
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      this.getInitialSelection();
    }
  }, {
    key: "pageSize",
    get: function get() {
      var _ref7, _this$props$paginatio, _this$props$paginatio2, _this$context$EuiTabl;
      return (_ref7 = (_this$props$paginatio = (_this$props$paginatio2 = this.props.pagination) === null || _this$props$paginatio2 === void 0 ? void 0 : _this$props$paginatio2.pageSize) !== null && _this$props$paginatio !== void 0 ? _this$props$paginatio : (_this$context$EuiTabl = this.context.EuiTablePagination) === null || _this$context$EuiTabl === void 0 ? void 0 : _this$context$EuiTabl.itemsPerPage) !== null && _ref7 !== void 0 ? _ref7 : _table_pagination.euiTablePaginationDefaults.itemsPerPage;
    }
  }, {
    key: "isSelectionControlled",
    get: function get() {
      var _this$props$selection;
      return !!((_this$props$selection = this.props.selection) !== null && _this$props$selection !== void 0 && _this$props$selection.selected);
    }
  }, {
    key: "getInitialSelection",
    value: function getInitialSelection() {
      if (this.isSelectionControlled) return;
      if (this.props.selection && this.props.selection.initialSelected && !this.state.initialSelectionRendered && this.props.items.length > 0) {
        this.setState({
          selection: this.props.selection.initialSelected,
          initialSelectionRendered: true
        });
      }
    }
  }, {
    key: "buildCriteria",
    value: function buildCriteria(props) {
      var criteria = {};
      if (hasPagination(props)) {
        criteria.page = {
          index: props.pagination.pageIndex,
          size: this.pageSize
        };
      }
      if (props.sorting) {
        criteria.sort = props.sorting.sort;
      }
      return criteria;
    }
  }, {
    key: "changeSelection",
    value: function changeSelection(changedSelection) {
      var _selection$onSelectio;
      var selection = this.props.selection;
      if (!selection) return;
      (_selection$onSelectio = selection.onSelectionChange) === null || _selection$onSelectio === void 0 || _selection$onSelectio.call(selection, changedSelection);
      if (!this.isSelectionControlled) {
        this.setState({
          selection: changedSelection
        });
      }
    }
  }, {
    key: "clearSelection",
    value: function clearSelection() {
      this.changeSelection([]);
    }
  }, {
    key: "onPageSizeChange",
    value: function onPageSizeChange(size) {
      this.clearSelection();
      var currentCriteria = this.buildCriteria(this.props);
      var criteria = _objectSpread(_objectSpread({}, currentCriteria), {}, {
        page: {
          index: 0,
          // when page size changes, we take the user back to the first page
          size: size
        }
      });
      if (this.props.onChange) {
        this.props.onChange(criteria);
      }
    }
  }, {
    key: "onPageChange",
    value: function onPageChange(index) {
      this.clearSelection();
      var currentCriteria = this.buildCriteria(this.props);
      var criteria = _objectSpread(_objectSpread({}, currentCriteria), {}, {
        page: _objectSpread(_objectSpread({}, currentCriteria.page), {}, {
          index: index
        })
      });
      if (this.props.onChange) {
        this.props.onChange(criteria);
      }
    }
  }, {
    key: "onColumnSortChange",
    value: function onColumnSortChange(column) {
      this.clearSelection();
      var currentCriteria = this.buildCriteria(this.props);
      var direction = _services.SortDirection.ASC;
      if (currentCriteria && currentCriteria.sort && (currentCriteria.sort.field === column.field || currentCriteria.sort.field === column.name)) {
        direction = _services.SortDirection.reverse(currentCriteria.sort.direction);
      }
      var criteria = _objectSpread(_objectSpread({}, currentCriteria), {}, {
        // resetting the page if the criteria has one
        page: !currentCriteria.page ? undefined : {
          index: 0,
          size: currentCriteria.page.size
        },
        sort: {
          field: column.field || column.name,
          direction: direction
        }
      });
      if (this.props.onChange) {
        // @ts-ignore complex relationship between pagination's existence and criteria, the code logic ensures this is correctly maintained
        this.props.onChange(criteria);
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
        className = _this$props2.className,
        loading = _this$props2.loading,
        items = _this$props2.items,
        itemId = _this$props2.itemId,
        columns = _this$props2.columns,
        pagination = _this$props2.pagination,
        sorting = _this$props2.sorting,
        selection = _this$props2.selection,
        onChange = _this$props2.onChange,
        error = _this$props2.error,
        noItemsMessage = _this$props2.noItemsMessage,
        compressed = _this$props2.compressed,
        itemIdToExpandedRowMap = _this$props2.itemIdToExpandedRowMap,
        responsiveBreakpoint = _this$props2.responsiveBreakpoint,
        rowProps = _this$props2.rowProps,
        cellProps = _this$props2.cellProps,
        tableCaption = _this$props2.tableCaption,
        rowHeader = _this$props2.rowHeader,
        tableLayout = _this$props2.tableLayout,
        rest = _objectWithoutProperties(_this$props2, _excluded);
      var classes = (0, _classnames.default)('euiBasicTable', {
        'euiBasicTable-loading': loading
      }, className);
      var table = this.renderTable();
      var paginationBar = this.renderPaginationBar();
      return (0, _react2.jsx)("div", _extends({
        className: classes
      }, rest), table, paginationBar);
    }
  }, {
    key: "renderTable",
    value: function renderTable() {
      var _this$props3 = this.props,
        compressed = _this$props3.compressed,
        responsiveBreakpoint = _this$props3.responsiveBreakpoint,
        tableLayout = _this$props3.tableLayout,
        loading = _this$props3.loading;
      return (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_table.EuiTableHeaderMobile, {
        responsiveBreakpoint: responsiveBreakpoint
      }, this.renderSelectAll(true), this.renderTableMobileSort()), (0, _react2.jsx)(_services.OverrideCopiedTabularContent, null, (0, _react2.jsx)(_table.EuiTable, {
        id: this.tableId,
        tableLayout: tableLayout,
        responsiveBreakpoint: responsiveBreakpoint,
        compressed: compressed,
        css: loading && _basic_table.safariLoadingWorkaround
      }, this.renderTableCaption(), this.renderTableHead(), this.renderTableBody(), this.renderTableFooter())));
    }
  }, {
    key: "renderTableMobileSort",
    value: function renderTableMobileSort() {
      var _this2 = this;
      var _this$props4 = this.props,
        columns = _this$props4.columns,
        sorting = _this$props4.sorting;
      var items = [];
      if (!sorting) {
        return null;
      }
      columns.forEach(function (column, index) {
        var _column;
        if (column.field && sorting.sort && !!sorting.enableAllColumns && column.sortable == null) {
          column = _objectSpread(_objectSpread({}, column), {}, {
            sortable: true
          });
        }
        if (!column.sortable || ((_column = column) === null || _column === void 0 || (_column = _column.mobileOptions) === null || _column === void 0 ? void 0 : _column.show) === false) {
          return;
        }
        var sortDirection = _this2.resolveColumnSortDirection(column);
        items.push({
          name: column.name,
          key: "_data_s_".concat(String(column.field), "_").concat(index),
          onSort: _this2.resolveColumnOnSort(column),
          isSorted: !!sortDirection,
          isSortAscending: sortDirection ? _services.SortDirection.isAsc(sortDirection) : undefined
        });
      });
      return items.length ? (0, _react2.jsx)(_table.EuiTableSortMobile, {
        items: items
      }) : null;
    }
  }, {
    key: "renderTableCaption",
    value: function renderTableCaption() {
      var _this$props5 = this.props,
        items = _this$props5.items,
        pagination = _this$props5.pagination,
        tableCaption = _this$props5.tableCaption;
      var itemCount = items.length;
      var totalItemCount = pagination ? pagination.totalItemCount : itemCount;
      var page = pagination ? pagination.pageIndex + 1 : 1;
      var pageCount = pagination ? Math.ceil(pagination.totalItemCount / this.pageSize) : 1;
      var captionElement;
      if (tableCaption) {
        if (pagination) {
          captionElement = (0, _react2.jsx)(_i18n.EuiI18n, {
            token: "euiBasicTable.tableCaptionWithPagination",
            default: "{tableCaption}; Page {page} of {pageCount}.",
            values: {
              tableCaption: tableCaption,
              page: page,
              pageCount: pageCount
            }
          });
        } else {
          captionElement = tableCaption;
        }
      } else {
        if (pagination) {
          if (pagination.totalItemCount > 0) {
            captionElement = (0, _react2.jsx)(_i18n.EuiI18n, {
              token: "euiBasicTable.tableAutoCaptionWithPagination",
              default: "This table contains {itemCount} rows out of {totalItemCount} rows; Page {page} of {pageCount}.",
              values: {
                totalItemCount: totalItemCount,
                itemCount: itemCount,
                page: page,
                pageCount: pageCount
              }
            });
          } else {
            captionElement = (0, _react2.jsx)(_i18n.EuiI18n, {
              token: "euiBasicTable.tableSimpleAutoCaptionWithPagination",
              default: "This table contains {itemCount} rows; Page {page} of {pageCount}.",
              values: {
                itemCount: itemCount,
                page: page,
                pageCount: pageCount
              }
            });
          }
        } else {
          captionElement = (0, _react2.jsx)(_i18n.EuiI18n, {
            token: "euiBasicTable.tableAutoCaptionWithoutPagination",
            default: "This table contains {itemCount} rows.",
            values: {
              itemCount: itemCount
            }
          });
        }
      }
      return (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("caption", {
        css: _table2.euiTableCaptionStyles,
        className: "euiTableCaption"
      }, _services.tabularCopyMarkers.hiddenNoCopyBoundary, (0, _react2.jsx)(_delay_render.EuiDelayRender, null, captionElement), _services.tabularCopyMarkers.hiddenNoCopyBoundary));
    }
  }, {
    key: "renderTableHead",
    value: function renderTableHead() {
      var _this3 = this;
      var _this$props6 = this.props,
        columns = _this$props6.columns,
        selection = _this$props6.selection;
      var headers = [];
      if (selection) {
        headers.push((0, _react2.jsx)(_table.EuiTableHeaderCellCheckbox, {
          key: "_selection_column_h",
          append: this.renderCopyChar(-1)
        }, this.renderSelectAll(false)));
      }
      columns.forEach(function (column, index) {
        var _ref8 = column,
          field = _ref8.field,
          width = _ref8.width,
          name = _ref8.name,
          nameTooltip = _ref8.nameTooltip,
          align = _ref8.align,
          dataType = _ref8.dataType,
          sortable = _ref8.sortable,
          mobileOptions = _ref8.mobileOptions,
          readOnly = _ref8.readOnly,
          description = _ref8.description;
        var columnAlign = align || _this3.getAlignForDataType(dataType);
        var sharedProps = {
          width: width,
          tooltipProps: nameTooltip,
          description: description,
          mobileOptions: mobileOptions,
          align: columnAlign,
          append: _this3.renderCopyChar(index)
        };

        // actions column
        if (column.actions) {
          headers.push((0, _react2.jsx)(_table.EuiTableHeaderCell, _extends({}, sharedProps, {
            key: "_actions_h_".concat(index),
            align: "right"
          }), name));
          return;
        }

        // computed column
        if (!column.field) {
          var _sorting = {};
          // computed columns are only sortable if their `sortable` is a function
          if (_this3.props.sorting && typeof sortable === 'function') {
            var sortDirection = _this3.resolveColumnSortDirection(column);
            _sorting.isSorted = !!sortDirection;
            _sorting.isSortAscending = sortDirection ? _services.SortDirection.isAsc(sortDirection) : undefined;
            _sorting.onSort = _this3.resolveColumnOnSort(column);
            _sorting.readOnly = _this3.props.sorting.readOnly || readOnly;
          }
          headers.push((0, _react2.jsx)(_table.EuiTableHeaderCell, _extends({}, sharedProps, {
            key: "_computed_column_h_".concat(index),
            "data-test-subj": "tableHeaderCell_".concat(typeof name === 'string' ? name : '', "_").concat(index)
          }, _sorting), name));
          return;
        }

        // field data column
        var sorting = {};
        if (_this3.props.sorting) {
          if (_this3.props.sorting.sort && !!_this3.props.sorting.enableAllColumns && column.sortable == null) {
            column = _objectSpread(_objectSpread({}, column), {}, {
              sortable: true
            });
          }
          var _ref9 = column,
            _sortable = _ref9.sortable;
          if (_sortable) {
            var _sortDirection = _this3.resolveColumnSortDirection(column);
            sorting.isSorted = !!_sortDirection;
            sorting.isSortAscending = _sortDirection ? _services.SortDirection.isAsc(_sortDirection) : undefined;
            sorting.onSort = _this3.resolveColumnOnSort(column);
            sorting.readOnly = _this3.props.sorting.readOnly || readOnly;
          }
        }
        headers.push((0, _react2.jsx)(_table.EuiTableHeaderCell, _extends({}, sharedProps, {
          key: "_data_h_".concat(String(field), "_").concat(index),
          "data-test-subj": "tableHeaderCell_".concat(String(field), "_").concat(index)
        }, sorting), name));
      });
      return (0, _react2.jsx)(_table.EuiTableHeader, null, headers);
    }
  }, {
    key: "renderTableFooter",
    value: function renderTableFooter() {
      var _this$props7 = this.props,
        items = _this$props7.items,
        columns = _this$props7.columns,
        pagination = _this$props7.pagination,
        selection = _this$props7.selection;
      var footers = [];
      var hasDefinedFooter = false;
      if (selection) {
        // Create an empty cell to compensate for additional selection column
        footers.push((0, _react2.jsx)(_table.EuiTableFooterCell, {
          key: "_selection_column_f"
        }, undefined));
      }
      columns.forEach(function (column) {
        var footer = getColumnFooter(column, {
          items: items,
          pagination: pagination
        });
        var _ref10 = column,
          mobileOptions = _ref10.mobileOptions,
          field = _ref10.field,
          align = _ref10.align;
        if (mobileOptions !== null && mobileOptions !== void 0 && mobileOptions.only) {
          return; // exclude columns that only exist for mobile headers
        }
        if (footer) {
          footers.push((0, _react2.jsx)(_table.EuiTableFooterCell, {
            key: "footer_".concat(String(field), "_").concat(footers.length - 1),
            align: align
          }, footer));
          hasDefinedFooter = true;
        } else {
          // Footer is undefined, so create an empty cell to preserve layout
          footers.push((0, _react2.jsx)(_table.EuiTableFooterCell, {
            key: "footer_empty_".concat(footers.length - 1),
            align: align
          }, undefined));
        }
      });
      return footers.length && hasDefinedFooter ? (0, _react2.jsx)(_table.EuiTableFooter, null, footers) : null;
    }
  }, {
    key: "renderTableBody",
    value: function renderTableBody() {
      var _this4 = this;
      var _this$props8 = this.props,
        error = _this$props8.error,
        loading = _this$props8.loading,
        items = _this$props8.items;
      var content;
      if (error) {
        content = this.renderErrorMessage(error);
      } else if (items.length === 0) {
        content = this.renderEmptyMessage();
      } else {
        content = items.map(function (item, index) {
          // if there's pagination the item's index must be adjusted to the where it is in the whole dataset
          var tableItemIndex = hasPagination(_this4.props) && _this4.pageSize > 0 ? _this4.props.pagination.pageIndex * _this4.pageSize + index : index;
          return _this4.renderItemRow(item, tableItemIndex, index);
        });
      }
      return (0, _react2.jsx)(_services.RenderWithEuiTheme, null, function (theme) {
        return (0, _react2.jsx)(_table.EuiTableBody, {
          css: loading && (0, _basic_table.euiBasicTableBodyLoading)(theme)
        }, content);
      });
    }
  }, {
    key: "renderErrorMessage",
    value: function renderErrorMessage(error) {
      var colSpan = this.props.columns.length + (this.props.selection ? 1 : 0);
      return (0, _react2.jsx)(_table.EuiTableRow, null, (0, _react2.jsx)(_table.EuiTableRowCell, {
        align: "center",
        colSpan: colSpan,
        mobileOptions: {
          width: '100%'
        }
      }, (0, _react2.jsx)(_icon.EuiIcon, {
        type: "minusInCircle",
        color: "danger"
      }), " ", error));
    }
  }, {
    key: "renderEmptyMessage",
    value: function renderEmptyMessage() {
      var _this$props9 = this.props,
        columns = _this$props9.columns,
        selection = _this$props9.selection,
        noItemsMessage = _this$props9.noItemsMessage;
      var colSpan = columns.length + (selection ? 1 : 0);
      return (0, _react2.jsx)(_table.EuiTableRow, null, (0, _react2.jsx)(_table.EuiTableRowCell, {
        align: "center",
        colSpan: colSpan,
        mobileOptions: {
          width: '100%'
        }
      }, noItemsMessage));
    }
  }, {
    key: "renderItemRow",
    value: function renderItemRow(item, rowIndex, displayedRowIndex) {
      var _this5 = this;
      var _this$props10 = this.props,
        columns = _this$props10.columns,
        selection = _this$props10.selection,
        rowHeader = _this$props10.rowHeader,
        itemIdToExpandedRowMap = _this$props10.itemIdToExpandedRowMap;
      var cells = [];
      var itemIdCallback = this.props.itemId;
      var itemId = getItemId(item, itemIdCallback) != null ? getItemId(item, itemIdCallback) : rowIndex;
      var selected = !selection ? false : this.state.selection && !!this.state.selection.find(function (selectedItem) {
        return getItemId(selectedItem, itemIdCallback) === itemId;
      });
      var rowSelectionDisabled = false;
      if (selection) {
        var _this$renderItemSelec = this.renderItemSelectionCell(itemId, item, selected, displayedRowIndex),
          _this$renderItemSelec2 = _slicedToArray(_this$renderItemSelec, 2),
          checkboxCell = _this$renderItemSelec2[0],
          isDisabled = _this$renderItemSelec2[1];
        cells.push(checkboxCell);
        rowSelectionDisabled = !!isDisabled;
      }
      var hasActions = false;
      columns.forEach(function (column, columnIndex) {
        var columnActions = column.actions;
        if (columnActions) {
          var hasCustomActions = columnActions.some(function (action) {
            return !!action.render;
          });
          cells.push(_this5.renderItemActionsCell(itemId, item, column, columnIndex, rowIndex, hasCustomActions));
          // A table theoretically could have both custom and default action items
          // If it has both, default action mobile row styles take precedence over custom
          hasActions = !hasActions && hasCustomActions ? 'custom' : true;
        } else if (column.field) {
          var fieldDataColumn = column;
          cells.push(_this5.renderItemFieldDataCell(itemId, item, column, columnIndex, fieldDataColumn.field === rowHeader));
        } else {
          cells.push(_this5.renderItemComputedCell(itemId, item, column, columnIndex));
        }
      });

      // Occupy full width of table, taking checkbox & mobile only columns into account.
      var expandedRowColSpan = selection ? columns.length + 1 : columns.length;
      var mobileOnlyCols = columns.reduce(function (num, column) {
        var _mobileOptions;
        return column !== null && column !== void 0 && (_mobileOptions = column.mobileOptions) !== null && _mobileOptions !== void 0 && _mobileOptions.only ? num + 1 : num + 0; // BWC only
      }, 0);
      expandedRowColSpan = expandedRowColSpan - mobileOnlyCols;

      // We'll use the ID to associate the expanded row with the original.
      var hasExpandedRow = itemIdToExpandedRowMap === null || itemIdToExpandedRowMap === void 0 ? void 0 : itemIdToExpandedRowMap.hasOwnProperty(itemId);
      var expandedRowId = hasExpandedRow ? "row_".concat(itemId, "_expansion") : undefined;
      var expandedRow = hasExpandedRow ? (0, _react2.jsx)(_table.EuiTableRow, {
        id: expandedRowId,
        isExpandedRow: true,
        hasSelection: !!selection
      }, (0, _react2.jsx)(_table.EuiTableRowCell, {
        colSpan: expandedRowColSpan,
        textOnly: false,
        append: _services.tabularCopyMarkers.hiddenNewline
      }, itemIdToExpandedRowMap[itemId])) : undefined;
      var rowPropsCallback = this.props.rowProps;
      var rowProps = getRowProps(item, rowPropsCallback);
      var row = (0, _react2.jsx)(_table.EuiTableRow, _extends({
        "aria-owns": expandedRowId,
        hasSelection: !!selection,
        isSelectable: !rowSelectionDisabled,
        isSelected: selected,
        hasActions: hasActions,
        isExpandable: hasExpandedRow
      }, rowProps), cells);
      return (0, _react2.jsx)(_react.Fragment, {
        key: "row_".concat(itemId)
      }, row, expandedRow);
    }
  }, {
    key: "renderItemSelectionCell",
    value: function renderItemSelectionCell(itemId, item, selected, displayedRowIndex) {
      var _this6 = this;
      var selection = this.props.selection;
      var key = "_selection_column_".concat(itemId);
      var checked = selected;
      var disabled = selection.selectable && !selection.selectable(item);
      var title = selection.selectableMessage && selection.selectableMessage(!disabled, item);
      var onChange = function onChange(event) {
        if (event.target.checked) {
          _this6.changeSelection([].concat(_toConsumableArray(_this6.state.selection), [item]));
        } else {
          var itemIdCallback = _this6.props.itemId;
          _this6.changeSelection(_this6.state.selection.reduce(function (selection, selectedItem) {
            if (getItemId(selectedItem, itemIdCallback) !== itemId) {
              selection.push(selectedItem);
            }
            return selection;
          }, []));
        }
      };
      return [(0, _react2.jsx)(_table.EuiTableRowCellCheckbox, {
        key: key,
        append: this.renderCopyChar(-1)
      }, (0, _react2.jsx)(_i18n.EuiI18n, {
        token: "euiBasicTable.selectThisRow",
        default: "Select row {index}",
        values: {
          index: displayedRowIndex + 1
        }
      }, function (selectThisRow) {
        return (0, _react2.jsx)(_form.EuiCheckbox, {
          id: "".concat(_this6.tableId).concat(key, "-checkbox"),
          disabled: disabled,
          checked: checked,
          onChange: onChange,
          title: title || selectThisRow,
          "aria-label": title || selectThisRow,
          "data-test-subj": "checkboxSelectRow-".concat(itemId)
        });
      })), disabled];
    }
  }, {
    key: "renderItemActionsCell",
    value: function renderItemActionsCell(itemId, item, column, columnIndex, rowIndex, hasCustomActions) {
      // Disable all actions if any row(s) are selected
      var allDisabled = this.state.selection.length > 0;
      var actualActions = column.actions.filter(function (action) {
        return !action.available || action.available(item);
      });
      if (actualActions.length > 2) {
        if (allDisabled) {
          // If all actions are disabled, do not show any actions but the popover toggle
          actualActions = [];
        } else {
          // if any of the actions `isPrimary`, add them inline as well, but only the first 2,
          // which we'll force to only show on hover for desktop views
          var primaryActions = actualActions.filter(function (action) {
            return action.isPrimary;
          });
          actualActions = primaryActions.slice(0, 2).map(function (action) {
            return _objectSpread(_objectSpread({}, action), {}, {
              showOnHover: true
            });
          });
        }

        // if we have more than 1 action, we don't show them all in the cell, instead we
        // put them all in a popover tool. This effectively means we can only have a maximum
        // of one tool per row (it's either and normal action, or it's a popover that shows multiple actions)
        //
        // here we create a single custom action that triggers the popover with all the configured actions

        actualActions.push({
          name: 'All actions',
          render: function render(item) {
            return (0, _react2.jsx)(_collapsed_item_actions.CollapsedItemActions, {
              className: "euiBasicTable__collapsedActions",
              actions: column.actions,
              actionsDisabled: allDisabled,
              itemId: itemId,
              item: item,
              displayedRowIndex: rowIndex
            });
          }
        });
      }
      var key = "record_actions_".concat(itemId, "_").concat(columnIndex);
      return (0, _react2.jsx)(_table.EuiTableRowCell, {
        key: key,
        align: "right",
        textOnly: false,
        hasActions: hasCustomActions ? 'custom' : true,
        append: this.renderCopyChar(columnIndex)
      }, (0, _react2.jsx)(_expanded_item_actions.ExpandedItemActions, {
        actions: actualActions,
        actionsDisabled: allDisabled,
        itemId: itemId,
        item: item
      }));
    }
  }, {
    key: "renderItemFieldDataCell",
    value: function renderItemFieldDataCell(itemId, item, column, columnIndex, setScopeRow) {
      var field = column.field,
        render = column.render,
        dataType = column.dataType;
      var key = "_data_column_".concat(String(field), "_").concat(itemId, "_").concat(columnIndex);
      var contentRenderer = render || this.getRendererForDataType(dataType);
      var value = (0, _objects.get)(item, field);
      var content = contentRenderer(value, item);
      return this.renderItemCell(item, column, columnIndex, key, content, setScopeRow);
    }
  }, {
    key: "renderItemComputedCell",
    value: function renderItemComputedCell(itemId, item, column, columnIndex) {
      var render = column.render;
      var key = "_computed_column_".concat(itemId, "_").concat(columnIndex);
      var contentRenderer = render || this.getRendererForDataType();
      var content = contentRenderer(item);
      return this.renderItemCell(item, column, columnIndex, key, content, false);
    }
  }, {
    key: "renderItemCell",
    value: function renderItemCell(item, column, columnIndex, key, content, setScopeRow) {
      var _mobileOptions$render, _mobileOptions$header;
      var _ref11 = column,
        align = _ref11.align,
        render = _ref11.render,
        dataType = _ref11.dataType,
        isExpander = _ref11.isExpander,
        textOnly = _ref11.textOnly,
        name = _ref11.name,
        field = _ref11.field,
        description = _ref11.description,
        sortable = _ref11.sortable,
        footer = _ref11.footer,
        mobileOptions = _ref11.mobileOptions,
        nameTooltip = _ref11.nameTooltip,
        rest = _objectWithoutProperties(_ref11, _excluded2);
      var columnAlign = align || this.getAlignForDataType(dataType);
      var cellPropsCallback = this.props.cellProps;
      var cellProps = getCellProps(item, column, cellPropsCallback);
      return (0, _react2.jsx)(_table.EuiTableRowCell, _extends({
        key: key,
        align: columnAlign,
        isExpander: isExpander,
        textOnly: textOnly || !render,
        setScopeRow: setScopeRow,
        mobileOptions: _objectSpread(_objectSpread({}, mobileOptions), {}, {
          render: mobileOptions === null || mobileOptions === void 0 || (_mobileOptions$render = mobileOptions.render) === null || _mobileOptions$render === void 0 ? void 0 : _mobileOptions$render.call(mobileOptions, item),
          header: (_mobileOptions$header = mobileOptions === null || mobileOptions === void 0 ? void 0 : mobileOptions.header) !== null && _mobileOptions$header !== void 0 ? _mobileOptions$header : name
        })
      }, cellProps, rest, {
        append: this.renderCopyChar(columnIndex)
      }), content);
    }
  }, {
    key: "getRendererForDataType",
    value: function getRendererForDataType() {
      var dataType = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'auto';
      var profile = dataTypesProfiles[dataType];
      if (!profile) {
        throw new Error("Unknown dataType [".concat(dataType, "]. The supported data types are [").concat(DATA_TYPES.join(', '), "]"));
      }
      return profile.render;
    }
  }, {
    key: "getAlignForDataType",
    value: function getAlignForDataType() {
      var dataType = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'auto';
      var profile = dataTypesProfiles[dataType];
      if (!profile) {
        throw new Error("Unknown dataType [".concat(dataType, "]. The supported data types are [").concat(DATA_TYPES.join(', '), "]"));
      }
      return profile.align;
    }
  }, {
    key: "renderPaginationBar",
    value: function renderPaginationBar() {
      var _this7 = this;
      var _this$props11 = this.props,
        error = _this$props11.error,
        pagination = _this$props11.pagination,
        tableCaption = _this$props11.tableCaption,
        onChange = _this$props11.onChange;
      if (!error && pagination && pagination.totalItemCount > 0) {
        if (!onChange) {
          throw new Error("The Basic Table is configured with pagination but [onChange] is\n        not configured. This callback must be implemented to handle pagination changes");
        }
        return (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiBasicTable.tablePagination",
          default: "Pagination for table: {tableCaption}",
          values: {
            tableCaption: tableCaption
          }
        }, function (tablePagination) {
          return (0, _react2.jsx)(_pagination_bar.PaginationBar, {
            pagination: pagination,
            onPageSizeChange: _this7.onPageSizeChange.bind(_this7),
            onPageChange: _this7.onPageChange.bind(_this7),
            "aria-controls": _this7.tableId,
            "aria-label": tablePagination
          });
        });
      }
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps, prevState) {
      if (!nextProps.selection) {
        // next props doesn't have a selection, reset our state
        return {
          selection: []
        };
      }
      var controlledSelection = nextProps.selection.selected;
      var unfilteredSelection = controlledSelection !== null && controlledSelection !== void 0 ? controlledSelection : prevState.selection;

      // Ensure we're not including selections that aren't in the
      // current `items` array (affected by pagination)
      var itemId = nextProps.itemId,
        items = nextProps.items;
      var selection = unfilteredSelection.filter(function (selectedItem) {
        return items.findIndex(function (item) {
          return getItemId(item, itemId) === getItemId(selectedItem, itemId);
        }) !== -1;
      });

      // If some selected items were filtered out, update state and callback
      if (selection.length !== unfilteredSelection.length) {
        var _nextProps$selection$, _nextProps$selection;
        (_nextProps$selection$ = (_nextProps$selection = nextProps.selection).onSelectionChange) === null || _nextProps$selection$ === void 0 || _nextProps$selection$.call(_nextProps$selection, selection);
        return {
          selection: selection
        };
      }

      // Always update selection state from props if controlled
      if (controlledSelection) {
        return {
          selection: selection
        };
      }
      return null;
    }
  }]);
}(_react.Component);
_defineProperty(EuiBasicTable, "contextType", _component_defaults.EuiComponentDefaultsContext);
_defineProperty(EuiBasicTable, "defaultProps", {
  tableLayout: 'fixed',
  noItemsMessage: (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiBasicTable.noItemsMessage",
    default: "No items found"
  })
});
EuiBasicTable.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
     * Describes how to extract a unique ID from each item, used for selections & expanded rows
     */
  /**
     * Describes how to extract a unique ID from each item, used for selections & expanded rows
     */
  itemId: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired, _propTypes.default.func.isRequired]),
  /**
     * Row expansion uses the itemId prop to identify each row
     */
  /**
     * Row expansion uses the itemId prop to identify each row
     */
  itemIdToExpandedRowMap: _propTypes.default.shape({}),
  /**
     * A list of objects to appear in the table - an item per row
     */
  /**
     * A list of objects to appear in the table - an item per row
     */
  items: _propTypes.default.arrayOf(_propTypes.default.any.isRequired),
  /**
     * Applied to `EuiTableRowCell`
     */
  /**
     * Applied to `EuiTableRowCell`
     */
  cellProps: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.func.isRequired]),
  /**
     * An array of one of the objects: {@link EuiTableFieldDataColumnType}, {@link EuiTableComputedColumnType} or {@link EuiTableActionsColumnType}.
     */
  /**
     * An array of one of the objects: {@link EuiTableFieldDataColumnType}, {@link EuiTableComputedColumnType} or {@link EuiTableActionsColumnType}.
     */
  columns: _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.shape({
    /**
       * A field of the item (may be a nested field)
       */
    // type hack used for better autocomplete support
    // https://github.com/microsoft/TypeScript/issues/29729
    field: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.any.isRequired]).isRequired,
    // supports outer.inner key paths
    /**
       * The display name of the column
       */
    name: _propTypes.default.node.isRequired,
    /**
       * Allows adding an icon with a tooltip displayed next to the name
       */
    nameTooltip: _propTypes.default.shape({
      /** The main content of the tooltip */content: _propTypes.default.node.isRequired,
      /**
         * The icon type to display
         * @default 'question'
         */
      icon: _propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "agentApp", "aggregate", "analyzeEvent", "annotation", "anomalyChart", "anomalySwimLane", "apmApp", "apmTrace", "appSearchApp", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "arrowStart", "arrowEnd", "article", "asterisk", "at", "auditbeatApp", "beaker", "bell", "bellSlash", "beta", "bolt", "boxesHorizontal", "boxesVertical", "branch", "branchUser", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "casesApp", "changePointDetection", "check", "checkCircle", "checkInCircleFilled", "cheer", "classificationJob", "clickLeft", "clickRight", "clock", "clockCounter", "cloudDrizzle", "cloudStormy", "cloudSunny", "cluster", "code", "codeApp", "color", "comment", "compute", "console", "consoleApp", "container", "continuityAbove", "continuityAboveBelow", "continuityBelow", "continuityWithin", "contrast", "contrastHigh", "controls", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createGenericJob", "createGeoJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crossInCircle", "crosshairs", "currency", "cut", "dashboardApp", "dataVisualizer", "database", "desktop", "devToolsApp", "diff", "discoverApp", "discuss", "document", "documentEdit", "documentation", "documents", "dot", "dotInCircle", "doubleArrowLeft", "doubleArrowRight", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorChecklist", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignLeft", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "endpoint", "eql", "eraser", "error", "errorFilled", "esqlVis", "exit", "expand", "expandMini", "export", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "fieldStatistics", "filebeatApp", "filter", "filterExclude", "filterIgnore", "filterInclude", "filterInCircle", "flask", "flag", "fleetApp", "fold", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "frameNext", "framePrevious", "fullScreen", "fullScreenExit", "function", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "grabOmnidirectional", "gradient", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "info", "image", "importAction", "index", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexRuntime", "indexSettings", "indexTemporary", "infinity", "inputOutput", "inspect", "invert", "ip", "key", "keyboard", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "kubernetesNode", "kubernetesPod", "launch", "layers", "lensApp", "lettering", "lineDashed", "lineDotted", "lineSolid", "link", "list", "listAdd", "lock", "lockOpen", "logPatternAnalysis", "logRateAnalysis", "logoAWS", "logoAWSMono", "logoAerospike", "logoApache", "logoAppSearch", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticStack", "logoElasticsearch", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoVulnerabilityManagement", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logsApp", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithExclamation", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuDown", "menuLeft", "menuRight", "menuUp", "merge", "metricbeatApp", "metricsApp", "minimize", "minus", "minusInCircle", "minusInCircleFilled", "minusInSquare", "mobile", "monitoringApp", "moon", "move", "namespace", "nested", "newChat", "node", "notebookApp", "number", "offline", "online", "outlierDetectionJob", "package", "packetbeatApp", "pageSelect", "pagesSelect", "palette", "paperClip", "partial", "pause", "payment", "pencil", "percent", "pin", "pinFilled", "pipeBreaks", "pipelineApp", "pipeNoBreaks", "pivot", "play", "playFilled", "plugs", "plus", "plusInCircle", "plusInCircleFilled", "plusInSquare", "popout", "push", "questionInCircle", "question", "quote", "readOnly", "recentlyViewedApp", "refresh", "regressionJob", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "section", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "sessionViewer", "shard", "share", "singleMetricViewer", "snowflake", "sortAscending", "sortDescending", "sortDown", "sortLeft", "sortRight", "sortUp", "sortable", "spaces", "spacesApp", "sparkles", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "sun", "swatchInput", "symlink", "tableDensityCompact", "tableDensityExpanded", "tableDensityNormal", "tableOfContents", "tag", "tear", "temperature", "timeline", "timelineWithArrow", "timelionApp", "timeRefresh", "timeslider", "training", "transitionLeftIn", "transitionLeftOut", "transitionTopIn", "transitionTopOut", "trash", "unfold", "unlink", "upgradeAssistantApp", "uptimeApp", "user", "userAvatar", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visVega", "visVisualBuilder", "visualizeApp", "vulnerabilityManagementApp", "warning", "warningFilled", "alert", "watchesApp", "web", "wordWrap", "wordWrapDisabled", "workplaceSearchApp", "wrench", "tokenAlias", "tokenAnnotation", "tokenArray", "tokenBinary", "tokenBoolean", "tokenClass", "tokenCompletionSuggester", "tokenConstant", "tokenDate", "tokenDimension", "tokenElement", "tokenEnum", "tokenEnumMember", "tokenEvent", "tokenException", "tokenField", "tokenFile", "tokenFlattened", "tokenFunction", "tokenGeo", "tokenHistogram", "tokenInterface", "tokenIP", "tokenJoin", "tokenKey", "tokenKeyword", "tokenMethod", "tokenMetricCounter", "tokenMetricGauge", "tokenModule", "tokenNamespace", "tokenNested", "tokenNull", "tokenNumber", "tokenObject", "tokenOperator", "tokenPackage", "tokenParameter", "tokenPercolator", "tokenProperty", "tokenRange", "tokenRankFeature", "tokenRankFeatures", "tokenRepo", "tokenSearchType", "tokenSemanticText", "tokenShape", "tokenString", "tokenStruct", "tokenSymbol", "tokenTag", "tokenText", "tokenTokenCount", "tokenVariable", "tokenVectorDense", "tokenDenseVector", "tokenVectorSparse"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired]),
      /** Additional props for EuiIcon */iconProps: _propTypes.default.any,
      /** Additional props for the EuiToolip */tooltipProps: _propTypes.default.shape({
        /**
           * Passes onto the span wrapping the trigger.
           */
        anchorClassName: _propTypes.default.string,
        /**
           * Passes onto the span wrapping the trigger.
           */
        anchorProps: _propTypes.default.shape({
          className: _propTypes.default.string,
          "aria-label": _propTypes.default.string,
          "data-test-subj": _propTypes.default.string,
          css: _propTypes.default.any
        }),
        /**
           * Passes onto the tooltip itself, not the trigger.
           */
        className: _propTypes.default.string,
        /**
           * The main content of your tooltip.
           */
        content: _propTypes.default.node,
        /**
           * Common display alternatives for the anchor wrapper
           */
        display: _propTypes.default.any,
        /**
           * An optional title for your tooltip.
           */
        title: _propTypes.default.node,
        /**
           * Unless you provide one, this will be randomly generated.
           */
        id: _propTypes.default.string,
        /**
           * When `true`, the tooltip's position is re-calculated when the user
           * scrolls. This supports having fixed-position tooltip anchors.
           *
           * When nesting an `EuiTooltip` in a scrollable container, `repositionOnScroll` should be `true`
           */
        repositionOnScroll: _propTypes.default.bool,
        /**
           * Disables the tooltip content being read by screen readers when focusing the trigger element.
           * Do not use when the trigger `aria-label` and tooltip `content` can be rephrased to be standalone
           * information (action & additional information).
           * Enable this prop only when the trigger has a descriptive label that either duplicates or includes
           * the tooltip content and would result in repetitive output.
           * @default false
           */
        disableScreenReaderOutput: _propTypes.default.bool,
        /**
           * If supplied, called when mouse movement causes the tool tip to be
           * hidden.
           */
        onMouseOut: _propTypes.default.func,
        "aria-label": _propTypes.default.string,
        "data-test-subj": _propTypes.default.string,
        css: _propTypes.default.any,
        delay: _propTypes.default.any,
        position: _propTypes.default.any
      })
    }),
    /**
       * A description of the column (will be presented as a title over the column header)
       */
    description: _propTypes.default.string,
    /**
       * Describes the data types of the displayed value (serves as a rendering hint for the table)
       */
    dataType: _propTypes.default.oneOf(["auto", "string", "number", "boolean", "date"]),
    /**
       * A CSS width property. Hints for the required width of the column (e.g. "30%", "100px", etc..)
       */
    width: _propTypes.default.string,
    /**
       * Defines whether the user can sort on this column. If a function is provided, this function returns the value to sort against
       */
    sortable: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.func.isRequired]),
    /**
       * Disables the user's ability to change the sort, but will still
       * show the current sort direction in the column header
       */
    readOnly: _propTypes.default.bool,
    /**
       * Defines the horizontal alignment of the column
       * @default left
       */
    align: _propTypes.default.any,
    /**
       * Creates a text wrapper around cell content that helps word break or truncate
       * long text correctly.
       * @default true
       */
    textOnly: _propTypes.default.bool,
    /**
       * Indicates whether this column should truncate overflowing text content.
       * - Set to `true` to enable single-line truncation.
       * - To enable multi-line truncation, use a configuration object with `lines`
       * set to a number of lines to truncate to.
       */
    truncateText: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.shape({
      lines: _propTypes.default.number.isRequired
    }).isRequired]),
    /**
       * Allows configuring custom render options or appearances for column cells
       * when the table responsively collapses into a mobile-friendly view
       */
    mobileOptions: _propTypes.default.shape({
      render: _propTypes.default.func
    }),
    /**
       * A custom renderer for this column's cell content.
       * Unlike computed columns or `mobileOptions.render`, this function receives:
       * - `value`: The value of the specified field for this row
       * - `item`: The full data item (row object)
       */
    render: _propTypes.default.func,
    /**
       * Content to display in the footer beneath this column
       */
    footer: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired, _propTypes.default.func.isRequired]),
    /**
       * If passing `itemIdToExpandedRowMap` to your table, set this flag to `true`
       * for the custom column or cell used to toggle the expanded row.
       */
    isExpander: _propTypes.default.bool,
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  }).isRequired, _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any,
    /**
         * A function that computes the value for each item and renders it
         */
    render: _propTypes.default.func.isRequired,
    /**
         * The display name of the column
         */
    name: _propTypes.default.node,
    /**
         * Allows configuring an icon with a tooltip, to be displayed next to the name
         */
    nameTooltip: _propTypes.default.shape({
      /** The main content of the tooltip */content: _propTypes.default.node.isRequired,
      /**
         * The icon type to display
         * @default 'question'
         */
      icon: _propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "agentApp", "aggregate", "analyzeEvent", "annotation", "anomalyChart", "anomalySwimLane", "apmApp", "apmTrace", "appSearchApp", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "arrowStart", "arrowEnd", "article", "asterisk", "at", "auditbeatApp", "beaker", "bell", "bellSlash", "beta", "bolt", "boxesHorizontal", "boxesVertical", "branch", "branchUser", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "casesApp", "changePointDetection", "check", "checkCircle", "checkInCircleFilled", "cheer", "classificationJob", "clickLeft", "clickRight", "clock", "clockCounter", "cloudDrizzle", "cloudStormy", "cloudSunny", "cluster", "code", "codeApp", "color", "comment", "compute", "console", "consoleApp", "container", "continuityAbove", "continuityAboveBelow", "continuityBelow", "continuityWithin", "contrast", "contrastHigh", "controls", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createGenericJob", "createGeoJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crossInCircle", "crosshairs", "currency", "cut", "dashboardApp", "dataVisualizer", "database", "desktop", "devToolsApp", "diff", "discoverApp", "discuss", "document", "documentEdit", "documentation", "documents", "dot", "dotInCircle", "doubleArrowLeft", "doubleArrowRight", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorChecklist", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignLeft", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "endpoint", "eql", "eraser", "error", "errorFilled", "esqlVis", "exit", "expand", "expandMini", "export", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "fieldStatistics", "filebeatApp", "filter", "filterExclude", "filterIgnore", "filterInclude", "filterInCircle", "flask", "flag", "fleetApp", "fold", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "frameNext", "framePrevious", "fullScreen", "fullScreenExit", "function", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "grabOmnidirectional", "gradient", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "info", "image", "importAction", "index", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexRuntime", "indexSettings", "indexTemporary", "infinity", "inputOutput", "inspect", "invert", "ip", "key", "keyboard", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "kubernetesNode", "kubernetesPod", "launch", "layers", "lensApp", "lettering", "lineDashed", "lineDotted", "lineSolid", "link", "list", "listAdd", "lock", "lockOpen", "logPatternAnalysis", "logRateAnalysis", "logoAWS", "logoAWSMono", "logoAerospike", "logoApache", "logoAppSearch", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticStack", "logoElasticsearch", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoVulnerabilityManagement", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logsApp", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithExclamation", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuDown", "menuLeft", "menuRight", "menuUp", "merge", "metricbeatApp", "metricsApp", "minimize", "minus", "minusInCircle", "minusInCircleFilled", "minusInSquare", "mobile", "monitoringApp", "moon", "move", "namespace", "nested", "newChat", "node", "notebookApp", "number", "offline", "online", "outlierDetectionJob", "package", "packetbeatApp", "pageSelect", "pagesSelect", "palette", "paperClip", "partial", "pause", "payment", "pencil", "percent", "pin", "pinFilled", "pipeBreaks", "pipelineApp", "pipeNoBreaks", "pivot", "play", "playFilled", "plugs", "plus", "plusInCircle", "plusInCircleFilled", "plusInSquare", "popout", "push", "questionInCircle", "question", "quote", "readOnly", "recentlyViewedApp", "refresh", "regressionJob", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "section", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "sessionViewer", "shard", "share", "singleMetricViewer", "snowflake", "sortAscending", "sortDescending", "sortDown", "sortLeft", "sortRight", "sortUp", "sortable", "spaces", "spacesApp", "sparkles", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "sun", "swatchInput", "symlink", "tableDensityCompact", "tableDensityExpanded", "tableDensityNormal", "tableOfContents", "tag", "tear", "temperature", "timeline", "timelineWithArrow", "timelionApp", "timeRefresh", "timeslider", "training", "transitionLeftIn", "transitionLeftOut", "transitionTopIn", "transitionTopOut", "trash", "unfold", "unlink", "upgradeAssistantApp", "uptimeApp", "user", "userAvatar", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visVega", "visVisualBuilder", "visualizeApp", "vulnerabilityManagementApp", "warning", "warningFilled", "alert", "watchesApp", "web", "wordWrap", "wordWrapDisabled", "workplaceSearchApp", "wrench", "tokenAlias", "tokenAnnotation", "tokenArray", "tokenBinary", "tokenBoolean", "tokenClass", "tokenCompletionSuggester", "tokenConstant", "tokenDate", "tokenDimension", "tokenElement", "tokenEnum", "tokenEnumMember", "tokenEvent", "tokenException", "tokenField", "tokenFile", "tokenFlattened", "tokenFunction", "tokenGeo", "tokenHistogram", "tokenInterface", "tokenIP", "tokenJoin", "tokenKey", "tokenKeyword", "tokenMethod", "tokenMetricCounter", "tokenMetricGauge", "tokenModule", "tokenNamespace", "tokenNested", "tokenNull", "tokenNumber", "tokenObject", "tokenOperator", "tokenPackage", "tokenParameter", "tokenPercolator", "tokenProperty", "tokenRange", "tokenRankFeature", "tokenRankFeatures", "tokenRepo", "tokenSearchType", "tokenSemanticText", "tokenShape", "tokenString", "tokenStruct", "tokenSymbol", "tokenTag", "tokenText", "tokenTokenCount", "tokenVariable", "tokenVectorDense", "tokenDenseVector", "tokenVectorSparse"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired]),
      /** Additional props for EuiIcon */iconProps: _propTypes.default.any,
      /** Additional props for the EuiToolip */tooltipProps: _propTypes.default.shape({
        anchorClassName: _propTypes.default.string,
        anchorProps: _propTypes.default.shape({
          className: _propTypes.default.string,
          "aria-label": _propTypes.default.string,
          "data-test-subj": _propTypes.default.string,
          css: _propTypes.default.any
        }),
        className: _propTypes.default.string,
        content: _propTypes.default.node,
        display: _propTypes.default.any,
        title: _propTypes.default.node,
        id: _propTypes.default.string,
        repositionOnScroll: _propTypes.default.bool,
        disableScreenReaderOutput: _propTypes.default.bool,
        onMouseOut: _propTypes.default.func,
        "aria-label": _propTypes.default.string,
        "data-test-subj": _propTypes.default.string,
        css: _propTypes.default.any,
        delay: _propTypes.default.any,
        position: _propTypes.default.any
      })
    }),
    /**
         * If provided, allows this column to be sorted on. Must return the value to sort against.
         */
    sortable: _propTypes.default.func
  }).isRequired, _propTypes.default.shape({
    /**
       * An array of one of the objects: {@link DefaultItemAction} or {@link CustomItemAction}
       */
    actions: _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.shape({
      /**
         * The type of action
         */
      type: _propTypes.default.oneOfType([_propTypes.default.oneOf(["button"]), _propTypes.default.oneOf(["icon"]).isRequired]),
      /**
         * Defines the color of the button
         */
      color: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.func.isRequired]),
      /**
         * The display name of the action (will render as visible text if rendered within a collapsed menu)
         */
      /**
         * The display name of the action (will render as visible text if rendered within a collapsed menu)
         */
      name: _propTypes.default.oneOfType([_propTypes.default.node.isRequired, _propTypes.default.func.isRequired]).isRequired,
      /**
         * Describes the action (will render as tooltip content)
         */
      /**
         * Describes the action (will render as tooltip content)
         */
      description: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.func.isRequired]).isRequired,
      /**
         * A handler function to execute the action. Passes back the current row
         * item as the first argument, and the originating React click event
         * as a second argument.
         */
      /**
         * A handler function to execute the action. Passes back the current row
         * item as the first argument, and the originating React click event
         * as a second argument.
         */
      onClick: _propTypes.default.func,
      href: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.func.isRequired]),
      target: _propTypes.default.string,
      /**
         * A callback function that determines whether the action is available
         */
      /**
         * A callback function that determines whether the action is available
         */
      available: _propTypes.default.func,
      /**
         * A callback function that determines whether the action is enabled
         */
      /**
         * A callback function that determines whether the action is enabled
         */
      enabled: _propTypes.default.func,
      "data-test-subj": _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.func.isRequired]),
      /**
         * If more than 3 actions are passed, 2 primary actions will show (on hover)
         * next to an expansion menu of all actions.
         *
         * On mobile, primary actions will be tucked away in the expansion menu for space.
         */
      /**
         * If more than 3 actions are passed, 2 primary actions will show (on hover)
         * next to an expansion menu of all actions.
         *
         * On mobile, primary actions will be tucked away in the expansion menu for space.
         */
      isPrimary: _propTypes.default.bool,
      /**
         * Allows only showing the action on mouse hover or keyboard focus.
         * If more than 3 actions are passed, this will always be true for `isPrimary` actions.
         *
         * Has no effect on mobile, or if `hasActions` is not set.
         */
      /**
         * Allows only showing the action on mouse hover or keyboard focus.
         * If more than 3 actions are passed, this will always be true for `isPrimary` actions.
         *
         * Has no effect on mobile, or if `hasActions` is not set.
         */
      showOnHover: _propTypes.default.bool,
      /**
         * Associates an icon with the button
         */
      icon: _propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "agentApp", "aggregate", "analyzeEvent", "annotation", "anomalyChart", "anomalySwimLane", "apmApp", "apmTrace", "appSearchApp", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "arrowStart", "arrowEnd", "article", "asterisk", "at", "auditbeatApp", "beaker", "bell", "bellSlash", "beta", "bolt", "boxesHorizontal", "boxesVertical", "branch", "branchUser", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "casesApp", "changePointDetection", "check", "checkCircle", "checkInCircleFilled", "cheer", "classificationJob", "clickLeft", "clickRight", "clock", "clockCounter", "cloudDrizzle", "cloudStormy", "cloudSunny", "cluster", "code", "codeApp", "color", "comment", "compute", "console", "consoleApp", "container", "continuityAbove", "continuityAboveBelow", "continuityBelow", "continuityWithin", "contrast", "contrastHigh", "controls", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createGenericJob", "createGeoJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crossInCircle", "crosshairs", "currency", "cut", "dashboardApp", "dataVisualizer", "database", "desktop", "devToolsApp", "diff", "discoverApp", "discuss", "document", "documentEdit", "documentation", "documents", "dot", "dotInCircle", "doubleArrowLeft", "doubleArrowRight", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorChecklist", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignLeft", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "endpoint", "eql", "eraser", "error", "errorFilled", "esqlVis", "exit", "expand", "expandMini", "export", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "fieldStatistics", "filebeatApp", "filter", "filterExclude", "filterIgnore", "filterInclude", "filterInCircle", "flask", "flag", "fleetApp", "fold", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "frameNext", "framePrevious", "fullScreen", "fullScreenExit", "function", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "grabOmnidirectional", "gradient", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "info", "image", "importAction", "index", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexRuntime", "indexSettings", "indexTemporary", "infinity", "inputOutput", "inspect", "invert", "ip", "key", "keyboard", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "kubernetesNode", "kubernetesPod", "launch", "layers", "lensApp", "lettering", "lineDashed", "lineDotted", "lineSolid", "link", "list", "listAdd", "lock", "lockOpen", "logPatternAnalysis", "logRateAnalysis", "logoAWS", "logoAWSMono", "logoAerospike", "logoApache", "logoAppSearch", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticStack", "logoElasticsearch", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoVulnerabilityManagement", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logsApp", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithExclamation", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuDown", "menuLeft", "menuRight", "menuUp", "merge", "metricbeatApp", "metricsApp", "minimize", "minus", "minusInCircle", "minusInCircleFilled", "minusInSquare", "mobile", "monitoringApp", "moon", "move", "namespace", "nested", "newChat", "node", "notebookApp", "number", "offline", "online", "outlierDetectionJob", "package", "packetbeatApp", "pageSelect", "pagesSelect", "palette", "paperClip", "partial", "pause", "payment", "pencil", "percent", "pin", "pinFilled", "pipeBreaks", "pipelineApp", "pipeNoBreaks", "pivot", "play", "playFilled", "plugs", "plus", "plusInCircle", "plusInCircleFilled", "plusInSquare", "popout", "push", "questionInCircle", "question", "quote", "readOnly", "recentlyViewedApp", "refresh", "regressionJob", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "section", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "sessionViewer", "shard", "share", "singleMetricViewer", "snowflake", "sortAscending", "sortDescending", "sortDown", "sortLeft", "sortRight", "sortUp", "sortable", "spaces", "spacesApp", "sparkles", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "sun", "swatchInput", "symlink", "tableDensityCompact", "tableDensityExpanded", "tableDensityNormal", "tableOfContents", "tag", "tear", "temperature", "timeline", "timelineWithArrow", "timelionApp", "timeRefresh", "timeslider", "training", "transitionLeftIn", "transitionLeftOut", "transitionTopIn", "transitionTopOut", "trash", "unfold", "unlink", "upgradeAssistantApp", "uptimeApp", "user", "userAvatar", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visVega", "visVisualBuilder", "visualizeApp", "vulnerabilityManagementApp", "warning", "warningFilled", "alert", "watchesApp", "web", "wordWrap", "wordWrapDisabled", "workplaceSearchApp", "wrench", "tokenAlias", "tokenAnnotation", "tokenArray", "tokenBinary", "tokenBoolean", "tokenClass", "tokenCompletionSuggester", "tokenConstant", "tokenDate", "tokenDimension", "tokenElement", "tokenEnum", "tokenEnumMember", "tokenEvent", "tokenException", "tokenField", "tokenFile", "tokenFlattened", "tokenFunction", "tokenGeo", "tokenHistogram", "tokenInterface", "tokenIP", "tokenJoin", "tokenKey", "tokenKeyword", "tokenMethod", "tokenMetricCounter", "tokenMetricGauge", "tokenModule", "tokenNamespace", "tokenNested", "tokenNull", "tokenNumber", "tokenObject", "tokenOperator", "tokenPackage", "tokenParameter", "tokenPercolator", "tokenProperty", "tokenRange", "tokenRankFeature", "tokenRankFeatures", "tokenRepo", "tokenSearchType", "tokenSemanticText", "tokenShape", "tokenString", "tokenStruct", "tokenSymbol", "tokenTag", "tokenText", "tokenTokenCount", "tokenVariable", "tokenVectorDense", "tokenDenseVector", "tokenVectorSparse"]).isRequired, _propTypes.default.func.isRequired])
    }).isRequired, _propTypes.default.shape({
      /**
         * Allows rendering a totally custom action
         */
      render: _propTypes.default.func.isRequired,
      /**
         * A callback that defines whether the action is available
         */
      available: _propTypes.default.func,
      /**
         * A callback that defines whether the action is enabled
         */
      enabled: _propTypes.default.func
    }).isRequired]).isRequired).isRequired,
    /**
       * The display name of the column
       */
    name: _propTypes.default.node,
    /**
       * Allows configuring an icon with a tooltip, to be displayed next to the name
       */
    nameTooltip: _propTypes.default.shape({
      /** The main content of the tooltip */content: _propTypes.default.node.isRequired,
      /**
         * The icon type to display
         * @default 'question'
         */
      icon: _propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "agentApp", "aggregate", "analyzeEvent", "annotation", "anomalyChart", "anomalySwimLane", "apmApp", "apmTrace", "appSearchApp", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "arrowStart", "arrowEnd", "article", "asterisk", "at", "auditbeatApp", "beaker", "bell", "bellSlash", "beta", "bolt", "boxesHorizontal", "boxesVertical", "branch", "branchUser", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "casesApp", "changePointDetection", "check", "checkCircle", "checkInCircleFilled", "cheer", "classificationJob", "clickLeft", "clickRight", "clock", "clockCounter", "cloudDrizzle", "cloudStormy", "cloudSunny", "cluster", "code", "codeApp", "color", "comment", "compute", "console", "consoleApp", "container", "continuityAbove", "continuityAboveBelow", "continuityBelow", "continuityWithin", "contrast", "contrastHigh", "controls", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createGenericJob", "createGeoJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crossInCircle", "crosshairs", "currency", "cut", "dashboardApp", "dataVisualizer", "database", "desktop", "devToolsApp", "diff", "discoverApp", "discuss", "document", "documentEdit", "documentation", "documents", "dot", "dotInCircle", "doubleArrowLeft", "doubleArrowRight", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorChecklist", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignLeft", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "endpoint", "eql", "eraser", "error", "errorFilled", "esqlVis", "exit", "expand", "expandMini", "export", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "fieldStatistics", "filebeatApp", "filter", "filterExclude", "filterIgnore", "filterInclude", "filterInCircle", "flask", "flag", "fleetApp", "fold", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "frameNext", "framePrevious", "fullScreen", "fullScreenExit", "function", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "grabOmnidirectional", "gradient", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "info", "image", "importAction", "index", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexRuntime", "indexSettings", "indexTemporary", "infinity", "inputOutput", "inspect", "invert", "ip", "key", "keyboard", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "kubernetesNode", "kubernetesPod", "launch", "layers", "lensApp", "lettering", "lineDashed", "lineDotted", "lineSolid", "link", "list", "listAdd", "lock", "lockOpen", "logPatternAnalysis", "logRateAnalysis", "logoAWS", "logoAWSMono", "logoAerospike", "logoApache", "logoAppSearch", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticStack", "logoElasticsearch", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoVulnerabilityManagement", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logsApp", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithExclamation", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuDown", "menuLeft", "menuRight", "menuUp", "merge", "metricbeatApp", "metricsApp", "minimize", "minus", "minusInCircle", "minusInCircleFilled", "minusInSquare", "mobile", "monitoringApp", "moon", "move", "namespace", "nested", "newChat", "node", "notebookApp", "number", "offline", "online", "outlierDetectionJob", "package", "packetbeatApp", "pageSelect", "pagesSelect", "palette", "paperClip", "partial", "pause", "payment", "pencil", "percent", "pin", "pinFilled", "pipeBreaks", "pipelineApp", "pipeNoBreaks", "pivot", "play", "playFilled", "plugs", "plus", "plusInCircle", "plusInCircleFilled", "plusInSquare", "popout", "push", "questionInCircle", "question", "quote", "readOnly", "recentlyViewedApp", "refresh", "regressionJob", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "section", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "sessionViewer", "shard", "share", "singleMetricViewer", "snowflake", "sortAscending", "sortDescending", "sortDown", "sortLeft", "sortRight", "sortUp", "sortable", "spaces", "spacesApp", "sparkles", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "sun", "swatchInput", "symlink", "tableDensityCompact", "tableDensityExpanded", "tableDensityNormal", "tableOfContents", "tag", "tear", "temperature", "timeline", "timelineWithArrow", "timelionApp", "timeRefresh", "timeslider", "training", "transitionLeftIn", "transitionLeftOut", "transitionTopIn", "transitionTopOut", "trash", "unfold", "unlink", "upgradeAssistantApp", "uptimeApp", "user", "userAvatar", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visVega", "visVisualBuilder", "visualizeApp", "vulnerabilityManagementApp", "warning", "warningFilled", "alert", "watchesApp", "web", "wordWrap", "wordWrapDisabled", "workplaceSearchApp", "wrench", "tokenAlias", "tokenAnnotation", "tokenArray", "tokenBinary", "tokenBoolean", "tokenClass", "tokenCompletionSuggester", "tokenConstant", "tokenDate", "tokenDimension", "tokenElement", "tokenEnum", "tokenEnumMember", "tokenEvent", "tokenException", "tokenField", "tokenFile", "tokenFlattened", "tokenFunction", "tokenGeo", "tokenHistogram", "tokenInterface", "tokenIP", "tokenJoin", "tokenKey", "tokenKeyword", "tokenMethod", "tokenMetricCounter", "tokenMetricGauge", "tokenModule", "tokenNamespace", "tokenNested", "tokenNull", "tokenNumber", "tokenObject", "tokenOperator", "tokenPackage", "tokenParameter", "tokenPercolator", "tokenProperty", "tokenRange", "tokenRankFeature", "tokenRankFeatures", "tokenRepo", "tokenSearchType", "tokenSemanticText", "tokenShape", "tokenString", "tokenStruct", "tokenSymbol", "tokenTag", "tokenText", "tokenTokenCount", "tokenVariable", "tokenVectorDense", "tokenDenseVector", "tokenVectorSparse"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired]),
      /** Additional props for EuiIcon */iconProps: _propTypes.default.any,
      /** Additional props for the EuiToolip */tooltipProps: _propTypes.default.shape({
        anchorClassName: _propTypes.default.string,
        anchorProps: _propTypes.default.shape({
          className: _propTypes.default.string,
          "aria-label": _propTypes.default.string,
          "data-test-subj": _propTypes.default.string,
          css: _propTypes.default.any
        }),
        className: _propTypes.default.string,
        content: _propTypes.default.node,
        display: _propTypes.default.any,
        title: _propTypes.default.node,
        id: _propTypes.default.string,
        repositionOnScroll: _propTypes.default.bool,
        disableScreenReaderOutput: _propTypes.default.bool,
        onMouseOut: _propTypes.default.func,
        "aria-label": _propTypes.default.string,
        "data-test-subj": _propTypes.default.string,
        css: _propTypes.default.any,
        delay: _propTypes.default.any,
        position: _propTypes.default.any
      })
    })
  }).isRequired]).isRequired),
  /**
     * Error message to display
     */
  /**
     * Error message to display
     */
  error: _propTypes.default.string,
  /**
     * Describes the content of the table. If not specified, the caption will be "This table contains {itemCount} rows."
     */
  /**
     * Describes the content of the table. If not specified, the caption will be "This table contains {itemCount} rows."
     */
  tableCaption: _propTypes.default.string,
  /**
     * Indicates which column should be used as the identifying cell in each row. Should match a "field" prop in FieldDataColumn
     */
  /**
     * Indicates which column should be used as the identifying cell in each row. Should match a "field" prop in FieldDataColumn
     */
  rowHeader: _propTypes.default.string,
  /**
     * Provides an infinite loading indicator
     */
  /**
     * Provides an infinite loading indicator
     */
  loading: _propTypes.default.bool,
  /**
     * Message to display if table is empty
     */
  /**
     * Message to display if table is empty
     */
  noItemsMessage: _propTypes.default.node,
  /**
     * Called whenever pagination or sorting changes (this property is required when either pagination or sorting is configured).
     * See {@link Criteria} or {@link CriteriaWithPagination}
     */
  onChange: _propTypes.default.func,
  /**
     * Configures {@link Pagination}
     */
  pagination: _propTypes.default.oneOfType([_propTypes.default.oneOf([undefined]), _propTypes.default.shape({
    /**
       * The current page (zero-based) index
       */
    pageIndex: _propTypes.default.number.isRequired,
    /**
       * The maximum number of items that can be shown in a single page.
       * Pass `0` to display the selected "Show all" option and hide the pagination.
       *
       * @default 10
       */
    pageSize: _propTypes.default.number,
    /**
       * The total number of items the page is "sliced" of
       */
    totalItemCount: _propTypes.default.number.isRequired,
    /**
       * Configures the page size dropdown options.
       * Pass `0` as one of the options to create a "Show all" option.
       *
       * @default [10, 25, 50]
       */
    pageSizeOptions: _propTypes.default.arrayOf(_propTypes.default.number.isRequired),
    /**
       * Set to false to hide the page size dropdown
       *
       * @default true
       */
    showPerPageOptions: _propTypes.default.bool
  })]),
  /**
     * Applied to `EuiTableRow`
     */
  /**
     * Applied to `EuiTableRow`
     */
  rowProps: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.func.isRequired]),
  /**
     * Configures {@link EuiTableSelectionType}
     */
  /**
     * Configures {@link EuiTableSelectionType}
     */
  selection: _propTypes.default.shape({
    /**
       * A callback that will be called whenever the item selection changes.
       *
       * Required if `selected` is passed.
       */
    onSelectionChange: _propTypes.default.func,
    /**
       * A callback that is called per item to indicate whether it is selectable
       */
    selectable: _propTypes.default.func,
    /**
       * A callback that is called per item to retrieve a message for its selectable state.
       * We display these messages as a tooltip on an unselectable checkbox
       */
    selectableMessage: _propTypes.default.func,
    /**
       * Sets initially selected items. Use for uncontrolled selection behavior (checkbox
       * will only change from user input, and not from developer control).
       *
       * This prop will be ignored if `selected` is passed.
       */
    initialSelected: _propTypes.default.arrayOf(_propTypes.default.any.isRequired),
    /**
       * Used for controlled selection behavior, e.g. when you want to programmatically
       * control which selection checkboxes are checked, and which are not.
       */
    selected: _propTypes.default.arrayOf(_propTypes.default.any.isRequired)
  }),
  /**
     * Configures {@link EuiTableSortingType}
     */
  /**
     * Configures {@link EuiTableSortingType}
     */
  sorting: _propTypes.default.shape({
    /**
       * Indicates the property/field to sort on
       */
    sort: _propTypes.default.shape({
      field: _propTypes.default.any.isRequired,
      direction: _propTypes.default.oneOf(["asc", "desc"]).isRequired
    }),
    /**
       * Enables/disables unsorting of table columns. Supported by EuiInMemoryTable.
       */
    allowNeutralSort: _propTypes.default.bool,
    /**
       * Enables the default sorting ability for each column.
       */
    enableAllColumns: _propTypes.default.bool,
    /**
       * Disables the user's ability to change the sort but still shows the current direction
       */
    readOnly: _propTypes.default.bool
  }),
  /**
     * Sets the table-layout CSS property. Note that auto tableLayout prevents truncateText from working properly.
     */
  /**
     * Sets the table-layout CSS property. Note that auto tableLayout prevents truncateText from working properly.
     */
  tableLayout: _propTypes.default.oneOf(["fixed", "auto"])
};