"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createChartSelectorsFactory = exports.EMPTY_LEGEND_ITEM_LIST = void 0;
const get_internal_is_intialized_1 = require("./selectors/get_internal_is_intialized");
const constants_1 = require("../common/constants");
const legend_1 = require("../common/legend");
exports.EMPTY_LEGEND_ITEM_LIST = [];
const EMPTY_TOOLTIP = Object.freeze({ header: null, values: [] });
const createChartSelectorsFactory = (overrides = {}, callbacksCreators = []) => () => {
    const callbacks = callbacksCreators.map((cb) => cb());
    return {
        isInitialized: () => get_internal_is_intialized_1.InitStatus.SpecNotInitialized,
        isBrushAvailable: () => false,
        isBrushing: () => false,
        isChartEmpty: () => true,
        getLegendItems: () => legend_1.EMPTY_LEGEND_LIST,
        getLegendItemsLabels: () => exports.EMPTY_LEGEND_ITEM_LIST,
        getLegendExtraValues: () => legend_1.EMPTY_LEGEND_ITEM_EXTRA_VALUES,
        getPointerCursor: () => constants_1.DEFAULT_CSS_CURSOR,
        isTooltipVisible: () => ({
            visible: false,
            isExternal: false,
            displayOnly: false,
            isPinnable: false,
        }),
        getTooltipInfo: () => EMPTY_TOOLTIP,
        getTooltipAnchor: () => null,
        getProjectionContainerArea: () => ({ top: 0, left: 0, width: 0, height: 0 }),
        getMainProjectionArea: () => ({ top: 0, left: 0, width: 0, height: 0 }),
        getBrushArea: () => null,
        getDebugState: () => ({}),
        getChartTypeDescription: () => '',
        getSmallMultiplesDomains: () => ({ smVDomain: [], smHDomain: [] }),
        canDisplayChartTitles: () => true,
        ...overrides,
        eventCallbacks: (state) => {
            callbacks.forEach((cb) => cb(state));
        },
    };
};
exports.createChartSelectorsFactory = createChartSelectorsFactory;
//# sourceMappingURL=chart_selectors.js.map