"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.statusAssetInventoryRoute = void 0;
var _utils = require("@kbn/lists-plugin/server/routes/utils");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("../../../../common/api/asset_inventory/constants");
var _constants2 = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const statusAssetInventoryRoute = (router, logger) => {
  router.versioned.get({
    access: 'public',
    path: _constants.ASSET_INVENTORY_STATUS_API_PATH,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution']
      }
    }
  }).addVersion({
    version: _constants2.API_VERSIONS.public.v1,
    validate: false
  }, async (context, _, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    const secSol = await context.securitySolution;
    try {
      const entityStoreClient = secSol.getEntityStoreDataClient();
      const entityStorePrivileges = await entityStoreClient.getEntityStoreInitPrivileges([]);
      const body = await secSol.getAssetInventoryClient().status(secSol, entityStorePrivileges);
      return response.ok({
        body
      });
    } catch (e) {
      const error = (0, _securitysolutionEsUtils.transformError)(e);
      logger.error(`Error retrieving Asset Inventory status: ${error.message}`);
      return siemResponse.error({
        statusCode: error.statusCode,
        body: error.message
      });
    }
  });
};
exports.statusAssetInventoryRoute = statusAssetInventoryRoute;