"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHostPolicyResponseHandler = void 0;
var _error_handler = require("../error_handler");
var _service = require("./service");
var _errors = require("../../errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getHostPolicyResponseHandler = function (endpointAppContextServices) {
  const logger = endpointAppContextServices.createLogger('endpointPolicyResponse');
  return async (context, request, response) => {
    const spaceId = (await context.securitySolution).getSpaceId();
    const esClient = (await context.core).elasticsearch.client.asInternalUser;
    const fleetServices = endpointAppContextServices.getInternalFleetServices(spaceId);
    try {
      const agentId = request.query.agentId;
      const doc = await (0, _service.getPolicyResponseByAgentId)(agentId, esClient, fleetServices);
      if (doc) {
        return response.ok({
          body: doc
        });
      }
      logger.debug(`Agent id [${agentId}] has no policy response documents indexed yet`);
      throw new _errors.NotFoundError(`Policy response for endpoint id [${agentId}] not found`);
    } catch (err) {
      return (0, _error_handler.errorHandler)(logger, response, err);
    }
  };
};
exports.getHostPolicyResponseHandler = getHostPolicyResponseHandler;