"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timelineDefaults = exports.getTimelineManageDefaults = void 0;
var _timeline = require("../../../common/types/timeline");
var _timeline2 = require("../../../common/api/timeline");
var _normalize_time_range = require("../../common/utils/normalize_time_range");
var _default_headers = require("../components/timeline/body/column_headers/default_headers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// normalizeTimeRange uses getTimeRangeSettings which cannot be used outside Kibana context if the uiSettings is not false
const {
  from: start,
  to: end
} = (0, _normalize_time_range.normalizeTimeRange)({
  from: '',
  to: ''
}, false);
const timelineDefaults = exports.timelineDefaults = {
  activeTab: _timeline.TimelineTabs.query,
  prevActiveTab: _timeline.TimelineTabs.query,
  columns: _default_headers.defaultUdtHeaders,
  documentType: '',
  defaultColumns: _default_headers.defaultUdtHeaders,
  dataProviders: [],
  dataViewId: null,
  dateRange: {
    start,
    end
  },
  description: '',
  eqlOptions: {
    eventCategoryField: 'event.category',
    timestampField: '@timestamp',
    query: '',
    size: 100
  },
  eventType: 'all',
  eventIdToNoteIds: {},
  excludedRowRendererIds: [_timeline2.RowRendererIdEnum.alert, _timeline2.RowRendererIdEnum.alerts, _timeline2.RowRendererIdEnum.auditd, _timeline2.RowRendererIdEnum.auditd_file, _timeline2.RowRendererIdEnum.library, _timeline2.RowRendererIdEnum.netflow, _timeline2.RowRendererIdEnum.plain, _timeline2.RowRendererIdEnum.registry, _timeline2.RowRendererIdEnum.suricata, _timeline2.RowRendererIdEnum.system, _timeline2.RowRendererIdEnum.system_dns, _timeline2.RowRendererIdEnum.system_endgame_process, _timeline2.RowRendererIdEnum.system_file, _timeline2.RowRendererIdEnum.system_fim, _timeline2.RowRendererIdEnum.system_security_event, _timeline2.RowRendererIdEnum.system_socket, _timeline2.RowRendererIdEnum.threat_match, _timeline2.RowRendererIdEnum.zeek],
  highlightedDropAndProviderId: '',
  historyIds: [],
  indexNames: [],
  isFavorite: false,
  isLive: false,
  isSaving: false,
  itemsPerPage: 25,
  itemsPerPageOptions: [10, 25, 50, 100],
  kqlMode: 'filter',
  kqlQuery: {
    filterQuery: null
  },
  loadingEventIds: [],
  resolveTimelineConfig: undefined,
  queryFields: [],
  title: '',
  timelineType: _timeline2.TimelineTypeEnum.default,
  templateTimelineId: null,
  templateTimelineVersion: null,
  noteIds: [],
  pinnedEventIds: {},
  pinnedEventsSaveObject: {},
  savedObjectId: null,
  selectAll: false,
  show: false,
  sort: [{
    columnId: '@timestamp',
    columnType: 'date',
    esTypes: ['date'],
    sortDirection: 'desc'
  }],
  status: _timeline2.TimelineStatusEnum.draft,
  version: null,
  deletedEventIds: [],
  selectedEventIds: {},
  isSelectAllChecked: false,
  filters: [],
  savedSearchId: null,
  savedSearch: null,
  isDataProviderVisible: false,
  sampleSize: 500,
  rowHeight: 3
};
const getTimelineManageDefaults = id => ({
  defaultColumns: _default_headers.defaultUdtHeaders,
  documentType: '',
  selectAll: false,
  id,
  isLoading: false,
  queryFields: [],
  title: ''
});
exports.getTimelineManageDefaults = getTimelineManageDefaults;