"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFooterItems = void 0;
var _i18n = require("@kbn/i18n");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _react = require("react");
var _constants = require("./constants");
var _kibana = require("../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFooterItems = () => {
  const {
    services: {
      onboarding
    }
  } = (0, _kibana.useKibana)();
  const projectUrl = (0, _useObservable.default)(onboarding.projectUrl$);
  const deploymentUrl = (0, _useObservable.default)(onboarding.deploymentUrl$);
  const expandProject = (0, _react.useMemo)(() => ({
    icon: 'arrowUp',
    id: _constants.OnboardingFooterLinkItemId.expand,
    title: _i18n.i18n.translate('xpack.securitySolution.onboarding.footer.expand.title', {
      defaultMessage: 'Expand your project'
    }),
    description: _i18n.i18n.translate('xpack.securitySolution.onboarding.footer.expand.description', {
      defaultMessage: 'Access Elastic’s full security capabilities'
    }),
    link: {
      title: _i18n.i18n.translate('xpack.securitySolution.onboarding.footer.expand.link.title', {
        defaultMessage: 'Go to project settings'
      }),
      href: projectUrl !== null && projectUrl !== void 0 ? projectUrl : ''
    }
  }), [projectUrl]);
  const manageDeployment = (0, _react.useMemo)(() => ({
    icon: 'arrowUp',
    id: _constants.OnboardingFooterLinkItemId.manageDeployment,
    title: _i18n.i18n.translate('xpack.securitySolution.onboarding.footer.manageDeployment.title', {
      defaultMessage: 'Manage your deployment'
    }),
    description: _i18n.i18n.translate('xpack.securitySolution.onboarding.footer.manageDeployment.description', {
      defaultMessage: 'Access Elastic’s full security capabilities'
    }),
    link: {
      title: _i18n.i18n.translate('xpack.securitySolution.onboarding.footer.manageDeployment.link.title', {
        defaultMessage: 'Go to settings'
      }),
      href: deploymentUrl !== null && deploymentUrl !== void 0 ? deploymentUrl : ''
    }
  }), [deploymentUrl]);
  const footerItems = (0, _react.useMemo)(() => [{
    icon: 'documents',
    id: _constants.OnboardingFooterLinkItemId.documentation,
    title: _i18n.i18n.translate('xpack.securitySolution.onboarding.footer.documentation.title', {
      defaultMessage: 'Browse docs'
    }),
    description: _i18n.i18n.translate('xpack.securitySolution.onboarding.footer.documentation.description', {
      defaultMessage: 'In-depth guides for all features'
    }),
    link: {
      title: _i18n.i18n.translate('xpack.securitySolution.onboarding.footer.documentation.link.title', {
        defaultMessage: 'Go to docs'
      }),
      href: 'https://docs.elastic.co/integrations/elastic-security-intro'
    }
  }, {
    icon: 'users',
    id: _constants.OnboardingFooterLinkItemId.slack,
    title: _i18n.i18n.translate('xpack.securitySolution.onboarding.footer.slack.title', {
      defaultMessage: 'Join the Slack'
    }),
    description: _i18n.i18n.translate('xpack.securitySolution.onboarding.footer.slack.description', {
      defaultMessage: 'Discuss Elastic with fellow users'
    }),
    link: {
      title: _i18n.i18n.translate('xpack.securitySolution.onboarding.footer.slack.link.title', {
        defaultMessage: 'Go to Elastic community Slack'
      }),
      href: 'https://www.elastic.co/blog/join-our-elastic-stack-workspace-on-slack'
    }
  }, {
    icon: 'beaker',
    id: _constants.OnboardingFooterLinkItemId.labs,
    title: _i18n.i18n.translate('xpack.securitySolution.onboarding.footer.labs.title', {
      defaultMessage: 'Help improve Elastic Security'
    }),
    description: _i18n.i18n.translate('xpack.securitySolution.onboarding.footer.labs.description', {
      defaultMessage: 'Meet live with our user research team'
    }),
    link: {
      title: _i18n.i18n.translate('xpack.securitySolution.onboarding.footer.labs.link.title', {
        defaultMessage: 'Opt into user research'
      }),
      href: 'https://elastic.eu.qualtrics.com/jfe/form/SV_exQvUoHguCio4pE'
    }
  }], []);
  if (projectUrl) {
    return [expandProject, ...footerItems];
  }
  if (deploymentUrl) {
    return [manageDeployment, ...footerItems];
  }
  return footerItems;
};
exports.useFooterItems = useFooterItems;