"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.IntegrationsCard = void 0;
var _react = _interopRequireDefault(require("react"));
var _card_content_panel = require("../common/card_content_panel");
var _centered_loading_spinner = require("../../../../../common/components/centered_loading_spinner");
var _onboarding_context = require("../../../onboarding_context");
var _components = require("../../../../../common/lib/integrations/components");
var _integration_card_top_callout = require("../common/integrations/callouts/integration_card_top_callout");
var _integration_context = require("../../../../../common/lib/integrations/hooks/integration_context");
var _integration_tabs_configs = require("../../../../../common/lib/integrations/configs/integration_tabs_configs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IntegrationsCard = exports.IntegrationsCard = /*#__PURE__*/_react.default.memo(({
  checkCompleteMetadata
}) => {
  const {
    spaceId,
    telemetry: {
      reportLinkClick
    }
  } = (0, _onboarding_context.useOnboardingContext)();
  if (!checkCompleteMetadata) {
    return /*#__PURE__*/_react.default.createElement(_centered_loading_spinner.CenteredLoadingSpinner, {
      "data-test-subj": "loadingInstalledIntegrations"
    });
  }
  return /*#__PURE__*/_react.default.createElement(_card_content_panel.OnboardingCardContentPanel, null, /*#__PURE__*/_react.default.createElement(_integration_context.IntegrationContextProvider, {
    spaceId: spaceId,
    reportLinkClick: reportLinkClick,
    integrationTabs: _integration_tabs_configs.INTEGRATION_TABS
  }, /*#__PURE__*/_react.default.createElement(_components.SecurityIntegrations, {
    checkCompleteMetadata: checkCompleteMetadata,
    topCalloutRenderer: _integration_card_top_callout.IntegrationCardTopCallout
  })));
});
IntegrationsCard.displayName = 'IntegrationsCard';

// eslint-disable-next-line import/no-default-export
var _default = exports.default = IntegrationsCard;