"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cleanEventFilterToUpdate = cleanEventFilterToUpdate;
exports.ensureEventFiltersListExists = ensureEventFiltersListExists;
exports.getList = getList;
exports.getSummary = getSummary;
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function createEventFilterList(http) {
  try {
    await http.post(_constants.EXCEPTION_LIST_URL, {
      body: JSON.stringify(_constants.EVENT_FILTER_LIST_DEFINITION)
    });
  } catch (err) {
    var _err$response;
    // Ignore 409 errors. List already created
    if (((_err$response = err.response) === null || _err$response === void 0 ? void 0 : _err$response.status) !== 409) {
      throw err;
    }
  }
}
let listExistsPromise;
async function ensureEventFiltersListExists(http) {
  if (!listExistsPromise) {
    listExistsPromise = createEventFilterList(http);
  }
  await listExistsPromise;
}
async function getList({
  http,
  perPage,
  page,
  sortField,
  sortOrder,
  filter
}) {
  await ensureEventFiltersListExists(http);
  return http.get(`${_constants.EXCEPTION_LIST_ITEM_URL}/_find`, {
    query: {
      page,
      per_page: perPage,
      sort_field: sortField,
      sort_order: sortOrder,
      list_id: [_constants.ENDPOINT_EVENT_FILTERS_LIST_ID],
      namespace_type: ['agnostic'],
      filter
    }
  });
}
async function getSummary({
  http,
  filter
}) {
  await ensureEventFiltersListExists(http);
  return http.get(`${_constants.EXCEPTION_LIST_URL}/summary`, {
    query: {
      filter,
      list_id: _constants.ENDPOINT_EVENT_FILTERS_LIST_ID,
      namespace_type: 'agnostic'
    }
  });
}
function cleanEventFilterToUpdate(exception) {
  var _exceptionToUpdateCle;
  const exceptionToUpdateCleaned = {
    ...exception
  };
  // Clean unnecessary fields for update action
  ['created_at', 'created_by', 'list_id', 'tie_breaker_id', 'updated_at', 'updated_by', 'meta'].forEach(field => {
    delete exceptionToUpdateCleaned[field];
  });
  exceptionToUpdateCleaned.comments = (_exceptionToUpdateCle = exceptionToUpdateCleaned.comments) === null || _exceptionToUpdateCle === void 0 ? void 0 : _exceptionToUpdateCle.map(comment => ({
    comment: comment.comment,
    id: comment.id
  }));
  return exceptionToUpdateCleaned;
}