"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderAgentInfo = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _agent_type_integration = require("../../../../../common/components/endpoint/agents/agent_type_integration");
var _use_test_id_generator = require("../../../../hooks/use_test_id_generator");
var _platforms = require("./platforms");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HeaderAgentInfo = exports.HeaderAgentInfo = /*#__PURE__*/(0, _react.memo)(({
  platform,
  hostName,
  lastCheckin,
  agentType,
  'data-test-subj': dataTestSubj,
  children
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const testId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    alignItems: "center",
    "data-test-subj": testId('agentInfo')
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_platforms.PlatformIcon, {
    "data-test-subj": testId('platformIcon'),
    platform: platform
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "eui-textTruncate"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "eui-textTruncate"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: hostName,
    anchorClassName: "eui-textTruncate"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": testId('hostName'),
    className: "eui-textTruncate",
    tabIndex: 0
  }, /*#__PURE__*/_react.default.createElement("h6", {
    className: "eui-textTruncate"
  }, hostName)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, children))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    "data-test-subj": testId('lastSeen')
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.responder.header.lastSeen",
    defaultMessage: "Last seen {date}",
    values: {
      date: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
        value: lastCheckin
      })
    }
  }))))), agentType && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      paddingLeft: euiTheme.size.l
    }
  }, /*#__PURE__*/_react.default.createElement(_agent_type_integration.AgentTypeIntegration, {
    agentType: agentType,
    "data-test-subj": testId('integration')
  })));
});
HeaderAgentInfo.displayName = 'HeaderAgentInfo';