"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelineFlyout = exports.TIMELINE_ON_CLOSE_EVENT = exports.SecuritySolutionFlyout = exports.SECURITY_SOLUTION_ON_CLOSE_EVENT = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _expandableFlyout = require("@kbn/expandable-flyout");
var _eui = require("@elastic/eui");
var _generic_details_left = require("./entity_details/generic_details_left");
var _generic_right = require("./entity_details/generic_right");
var _context = require("./ai_for_soc/context");
var _ai_for_soc = require("./ai_for_soc");
var _context2 = require("./document_details/session_view/context");
var _session_view = require("./document_details/session_view");
var _network_details = require("./network_details");
var _flyouts = require("./document_details/shared/constants/flyouts");
var _panel_keys = require("./document_details/shared/constants/panel_keys");
var _isolate_host = require("./document_details/isolate_host");
var _context3 = require("./document_details/isolate_host/context");
var _context4 = require("./document_details/shared/context");
var _right = require("./document_details/right");
var _left = require("./document_details/left");
var _preview = require("./document_details/preview");
var _alert_reason = require("./document_details/alert_reason");
var _context5 = require("./document_details/alert_reason/context");
var _right2 = require("./rule_details/right");
var _user_right = require("./entity_details/user_right");
var _user_details_left = require("./entity_details/user_details_left");
var _host_right = require("./entity_details/host_right");
var _host_details_left = require("./entity_details/host_details_left");
var _analyzer_panels = require("./document_details/analyzer_panels");
var _constants = require("./entity_details/shared/constants");
var _service_right = require("./entity_details/service_right");
var _service_details_left = require("./entity_details/service_details_left");
var _constants2 = require("./csp_details/findings_flyout/constants");
var _findings_right = require("./csp_details/findings_flyout/findings_right");
var _panel_keys2 = require("./ai_for_soc/constants/panel_keys");
var _constants3 = require("./csp_details/vulnerabilities_flyout/constants");
var _vulnerabilities_right = require("./csp_details/vulnerabilities_flyout/vulnerabilities_right");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * List of all panels that will be used within the document details expandable flyout.
 * This needs to be passed to the expandable flyout registeredPanels property.
 */
const expandableFlyoutDocumentsPanels = [{
  key: _panel_keys.DocumentDetailsRightPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_context4.DocumentDetailsProvider, props.params, /*#__PURE__*/_react.default.createElement(_right.RightPanel, {
    path: props.path
  }))
}, {
  key: _panel_keys.DocumentDetailsLeftPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_context4.DocumentDetailsProvider, props.params, /*#__PURE__*/_react.default.createElement(_left.LeftPanel, {
    path: props.path
  }))
}, {
  key: _panel_keys.DocumentDetailsPreviewPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_context4.DocumentDetailsProvider, props.params, /*#__PURE__*/_react.default.createElement(_preview.PreviewPanel, {
    path: props.path
  }))
}, {
  key: _panel_keys.DocumentDetailsAlertReasonPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_context5.AlertReasonPanelProvider, props.params, /*#__PURE__*/_react.default.createElement(_alert_reason.AlertReasonPanel, null))
}, {
  key: _right2.RulePanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_right2.RulePanel, props.params)
}, {
  key: _right2.RulePreviewPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_right2.RulePanel, (0, _extends2.default)({}, props.params, {
    isPreviewMode: true
  }))
}, {
  key: _panel_keys.DocumentDetailsIsolateHostPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_context3.IsolateHostPanelProvider, props.params, /*#__PURE__*/_react.default.createElement(_isolate_host.IsolateHostPanel, {
    path: props.path
  }))
}, {
  key: _panel_keys.DocumentDetailsAnalyzerPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_analyzer_panels.AnalyzerPanel, props.params)
}, {
  key: _panel_keys.DocumentDetailsSessionViewPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_context2.SessionViewPanelProvider, props.params, /*#__PURE__*/_react.default.createElement(_session_view.SessionViewPanel, {
    path: props.path
  }))
}, {
  key: _constants.UserPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_user_right.UserPanel, props.params)
}, {
  key: _user_details_left.UserDetailsPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_user_details_left.UserDetailsPanel, props.params)
}, {
  key: _user_right.UserPreviewPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_user_right.UserPanel, (0, _extends2.default)({}, props.params, {
    isPreviewMode: true
  }))
}, {
  key: _constants.HostPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_host_right.HostPanel, props.params)
}, {
  key: _host_details_left.HostDetailsPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_host_details_left.HostDetailsPanel, props.params)
}, {
  key: _host_right.HostPreviewPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_host_right.HostPanel, (0, _extends2.default)({}, props.params, {
    isPreviewMode: true
  }))
}, {
  key: _network_details.NetworkPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_network_details.NetworkPanel, props.params)
}, {
  key: _network_details.NetworkPreviewPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_network_details.NetworkPanel, (0, _extends2.default)({}, props.params, {
    isPreviewMode: true
  }))
}, {
  key: _constants.ServicePanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_service_right.ServicePanel, props.params)
}, {
  key: _service_details_left.ServiceDetailsPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_service_details_left.ServiceDetailsPanel, props.params)
}, {
  key: _constants.GenericEntityPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_generic_right.GenericEntityPanel, props.params)
}, {
  key: _generic_details_left.GenericEntityDetailsPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_generic_details_left.GenericEntityDetailsPanel, props.params)
}, {
  key: _constants2.MisconfigurationFindingsPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_findings_right.FindingsMisconfigurationPanel, props.params)
}, {
  key: _panel_keys2.IOCPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_context.AIForSOCDetailsProvider, props.params, /*#__PURE__*/_react.default.createElement(_ai_for_soc.AIForSOCPanel, null))
}, {
  key: _constants2.MisconfigurationFindingsPreviewPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_findings_right.FindingsMisconfigurationPanel, props.params)
}, {
  key: _constants3.VulnerabilityFindingsPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_vulnerabilities_right.FindingsVulnerabilityPanel, props.params)
}, {
  key: _constants3.VulnerabilityFindingsPreviewPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_vulnerabilities_right.FindingsVulnerabilityPanel, props.params)
}];
const SECURITY_SOLUTION_ON_CLOSE_EVENT = exports.SECURITY_SOLUTION_ON_CLOSE_EVENT = `expandable-flyout-on-close-${_flyouts.Flyouts.securitySolution}`;
const TIMELINE_ON_CLOSE_EVENT = exports.TIMELINE_ON_CLOSE_EVENT = `expandable-flyout-on-close-${_flyouts.Flyouts.timeline}`;

/**
 * Flyout used for the Security Solution application
 * We keep the default EUI 1000 z-index to ensure it is always rendered behind Timeline (which has a z-index of 1001)
 * We propagate the onClose callback to the rest of Security Solution using a window event 'expandable-flyout-on-close-SecuritySolution'
 * This flyout support push/overlay mode. The value is saved in local storage.
 */
const SecuritySolutionFlyout = exports.SecuritySolutionFlyout = /*#__PURE__*/(0, _react.memo)(() => {
  const onClose = (0, _react.useCallback)(() => window.dispatchEvent(new CustomEvent(SECURITY_SOLUTION_ON_CLOSE_EVENT, {
    detail: _flyouts.Flyouts.securitySolution
  })), []);
  return /*#__PURE__*/_react.default.createElement(_expandableFlyout.ExpandableFlyout, {
    registeredPanels: expandableFlyoutDocumentsPanels,
    paddingSize: "none",
    onClose: onClose
  });
});
SecuritySolutionFlyout.displayName = 'SecuritySolutionFlyout';

/**
 * Flyout used in Timeline
 * We set the z-index to 1002 to ensure it is always rendered above Timeline (which has a z-index of 1001)
 * We propagate the onClose callback to the rest of Security Solution using a window event 'expandable-flyout-on-close-Timeline'
 * This flyout does not support push mode, because timeline being rendered in a modal (EUiPortal), it's very difficult to dynamically change its width.
 */
const TimelineFlyout = exports.TimelineFlyout = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const onClose = (0, _react.useCallback)(() => window.dispatchEvent(new CustomEvent(TIMELINE_ON_CLOSE_EVENT, {
    detail: _flyouts.Flyouts.timeline
  })), []);
  return /*#__PURE__*/_react.default.createElement(_expandableFlyout.ExpandableFlyout, {
    registeredPanels: expandableFlyoutDocumentsPanels,
    paddingSize: "none",
    customStyles: {
      'z-index': euiTheme.levels.flyout + 2
    },
    onClose: onClose,
    flyoutCustomProps: {
      pushVsOverlay: {
        disabled: true,
        tooltip: 'Push mode is not supported in Timeline'
      }
    }
  });
});
TimelineFlyout.displayName = 'TimelineFlyout';