"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HighlightedFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _highlighted_fields_helpers = require("../../shared/utils/highlighted_fields_helpers");
var _highlighted_fields_cell = require("./highlighted_fields_cell");
var _cell_actions = require("../../shared/components/cell_actions");
var _test_ids = require("./test_ids");
var _use_highlighted_fields = require("../../shared/hooks/use_highlighted_fields");
var _highlighted_fields_button = require("./highlighted_fields_button");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const columns = [{
  field: 'field',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.investigation.highlightedFields.tableFieldColumnLabel",
    defaultMessage: "Field"
  }),
  'data-test-subj': 'fieldCell',
  width: '30%'
}, {
  field: 'description',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.investigation.highlightedFields.tableValueColumnLabel",
    defaultMessage: "Value"
  }),
  'data-test-subj': 'valueCell',
  width: '70%',
  render: description => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, description.showCellActions ? /*#__PURE__*/_react.default.createElement(_cell_actions.CellActions, {
    field: description.field,
    value: description.values
  }, /*#__PURE__*/_react.default.createElement(_highlighted_fields_cell.HighlightedFieldsCell, {
    values: description.values,
    field: description.field,
    originalField: description.originalField,
    scopeId: description.scopeId,
    showPreview: true
  })) : /*#__PURE__*/_react.default.createElement(_highlighted_fields_cell.HighlightedFieldsCell, {
    values: description.values,
    field: description.field,
    originalField: description.originalField
  }))
}];
/**
 * Component that displays the highlighted fields in the right panel under the Investigation section.
 * It is used in both in the alerts page and the AI for SOC alert summary page. The latter has no CellActions enabled.
 */
const HighlightedFields = exports.HighlightedFields = /*#__PURE__*/(0, _react.memo)(({
  dataFormattedForFieldBrowser,
  investigationFields,
  scopeId = '',
  showCellActions,
  showEditButton = false
}) => {
  const [isEditLoading, setIsEditLoading] = (0, _react.useState)(false);
  const highlightedFields = (0, _use_highlighted_fields.useHighlightedFields)({
    dataFormattedForFieldBrowser,
    investigationFields
  });
  const items = (0, _react.useMemo)(() => (0, _highlighted_fields_helpers.convertHighlightedFieldsToTableRow)(highlightedFields, scopeId, showCellActions), [highlightedFields, scopeId, showCellActions]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    css: {
      minHeight: '40px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": _test_ids.HIGHLIGHTED_FIELDS_TITLE_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.investigation.highlightedFields.highlightedFieldsTitle",
    defaultMessage: "Highlighted fields"
  })))), showEditButton && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_highlighted_fields_button.EditHighlightedFieldsButton, {
    customHighlightedFields: investigationFields,
    dataFormattedForFieldBrowser: dataFormattedForFieldBrowser,
    setIsEditLoading: setIsEditLoading
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": _test_ids.HIGHLIGHTED_FIELDS_DETAILS_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: items,
    columns: columns,
    compressed: true,
    loading: isEditLoading,
    message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.right.investigation.highlightedFields.noDataDescription",
      defaultMessage: "There's no highlighted fields for this alert."
    })
  }))));
});
HighlightedFields.displayName = 'HighlightedFields';