"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsqlDashboardPanel = exports.DEFAULT_PAGE_SIZE = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _fp = require("lodash/fp");
var _react2 = require("@emotion/react");
var _inspect = require("../../../../../common/components/inspect");
var _use_error_toast = require("../../../../../common/hooks/use_error_toast");
var _visualization_embeddable = require("../../../../../common/components/visualization_actions/visualization_embeddable");
var _hooks = require("./hooks");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_PAGE_SIZE = exports.DEFAULT_PAGE_SIZE = 10;
const EsqlDashboardPanel = ({
  stackByField,
  generateVisualizationQuery,
  generateTableQuery,
  getLensAttributes,
  columns,
  timerange,
  pageSize = DEFAULT_PAGE_SIZE,
  showInspectTable = false,
  title
}) => {
  const [sortField, setSortField] = (0, _react.useState)('@timestamp');
  const [sortDirection, setSortDirection] = (0, _react.useState)('asc');
  const [currentPage, setCurrentPage] = (0, _react.useState)(1);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const tableQuery = (0, _react.useMemo)(() => generateTableQuery(sortField, sortDirection, currentPage), [sortField, sortDirection, currentPage, generateTableQuery]);
  const visualizationQuery = (0, _react.useMemo)(() => generateVisualizationQuery(stackByField, timerange), [generateVisualizationQuery, stackByField, timerange]);
  const {
    records: items,
    error,
    isLoading,
    isInitialLoading,
    isRefetching,
    isError
  } = (0, _hooks.useDashboardTableQuery)(tableQuery);
  const onTableChange = ({
    sort
  }) => {
    if (sort) {
      const {
        field,
        direction
      } = sort;
      setSortField(field);
      setSortDirection(direction);
    }
  };
  (0, _use_error_toast.useErrorToast)(_i18n.i18n.translate('xpack.securitySolution.genericDashboard.queryError', {
    defaultMessage: 'There was an error loading the data'
  }), error);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    "data-test-subj": "genericDashboardSections"
  }, /*#__PURE__*/_react.default.createElement(_visualization_embeddable.VisualizationEmbeddable, {
    stackByField: stackByField,
    esql: visualizationQuery,
    "data-test-subj": "genericDashboardEmbeddableHistogram",
    getLensAttributes: getLensAttributes,
    height: 260,
    id: "GenericDashboard",
    timerange: timerange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m"
  }) : isError ? /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.securitySolution.genericDashboard.errorLoadingData', {
      defaultMessage: 'Error loading data'
    }),
    color: "danger",
    iconType: "error"
  })) : /*#__PURE__*/_react.default.createElement(_inspect.InspectButtonContainer, null, /*#__PURE__*/_react.default.createElement("div", {
    // Anchors the position absolute inspect button (nearest positioned ancestor)
    css: (0, _react2.css)`
                  position: relative;
                `
  }, /*#__PURE__*/_react.default.createElement("div", {
    // Position the inspect button above the table
    css: (0, _react2.css)`
                    position: absolute;
                    right: 0;
                    top: -${euiTheme.size.base};
                  `
  }, showInspectTable && /*#__PURE__*/_react.default.createElement(_inspect.InspectButton, {
    queryId: _hooks.DASHBOARD_TABLE_QUERY_ID,
    title: title
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    id: _hooks.DASHBOARD_TABLE_QUERY_ID,
    loading: isInitialLoading || isRefetching,
    items: (0, _fp.take)(currentPage * pageSize, items) || [],
    onChange: onTableChange,
    sorting: {
      sort: {
        field: sortField,
        direction: sortDirection
      }
    },
    columns: columns
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), items.length > currentPage * pageSize && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    isLoading: isInitialLoading || isRefetching,
    onClick: () => {
      setCurrentPage(page => page + 1);
    },
    flush: "right",
    color: "primary",
    size: "s",
    iconType: "sortDown",
    iconSide: "right",
    iconSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.genericDashboard.showMore",
    defaultMessage: "Show more"
  })))));
};
exports.EsqlDashboardPanel = EsqlDashboardPanel;