"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegedAccessDetectionInstallPrompt = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/ml-plugin/public");
var _i18n = require("@kbn/i18n");
var _entity_store_dashboard = _interopRequireDefault(require("../../../../images/entity_store_dashboard.png"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PrivilegedAccessDetectionInstallPrompt = ({
  installationErrorOccurred,
  install
}) => {
  const [mlNodesAvailable, setMlNodesAvailable] = (0, _react.useState)(false);
  const privilegedAccessDetectionInstallTooltipText = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.topPrivilegedAccessDetectionAnomalies.installTooltip', {
    defaultMessage: 'Install and enable privileged access detection anomaly jobs'
  });
  const privilegedAccessDetectionInstallTooltipUnavailableText = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.topPrivilegedAccessDetectionAnomalies.installUnavailableTooltip', {
    defaultMessage: 'Unable to install jobs due to no ML node currently available.'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    hasBorder: false,
    layout: "horizontal",
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: mlNodesAvailable ? privilegedAccessDetectionInstallTooltipText : privilegedAccessDetectionInstallTooltipUnavailableText
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      disabled: !mlNodesAvailable,
      fill: true,
      onClick: () => install(),
      "data-test-subj": `privilegedUserMonitoringEnablementButton`
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.privilegedAccessDetection.enableButton",
      defaultMessage: "Install"
    }))),
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      size: "l",
      hasShadow: true,
      src: _entity_store_dashboard.default,
      alt: _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.topPrivilegedAccessDetectionAnomalies.installAndEnable', {
        defaultMessage: 'Install and Enable.'
      })
    }),
    "data-test-subj": "privilegedUserMonitoringEnablementPanel",
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.topPrivilegedAccessDetectionAnomalies.enablePrivilegedAccessDetection', {
      defaultMessage: 'Enable Privileged access detection.'
    })),
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.privilegedAccessEnablementDescription",
      defaultMessage: 'Detect anomalous privileged access activity in Windows, Linux and Okta system logs.'
    })), /*#__PURE__*/_react.default.createElement(_public.MlNodeAvailableWarningShared, {
      size: "s",
      nodeAvailableCallback: setMlNodesAvailable
    }), installationErrorOccurred && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.privilegedAccessDetection.installErrorStatus', {
        defaultMessage: 'There was an error installing the privileged access detection package.'
      }),
      color: "danger",
      iconType: "error"
    }))
  }));
};
exports.PrivilegedAccessDetectionInstallPrompt = PrivilegedAccessDetectionInstallPrompt;