"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityStoreEnablementModal = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _entity_analytics = require("../../../../../common/api/entity_analytics");
var _use_contract_component = require("../../../../common/hooks/use_contract_component");
var _translations = require("../translations");
var _entity_store_missing_privileges_callout = require("./entity_store_missing_privileges_callout");
var _use_missing_risk_engine_privileges = require("../../../hooks/use_missing_risk_engine_privileges");
var _risk_engine_privileges_callout = require("../../risk_engine_privileges_callout");
var _use_entity_engine_privileges = require("../hooks/use_entity_engine_privileges");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isInstallButtonEnabled = (canInstallRiskScore, canInstallEntityStore, userHasEnabled) => {
  if (canInstallRiskScore || canInstallEntityStore) {
    return userHasEnabled.riskScore || userHasEnabled.entityStore;
  }
  return false;
};
const ENTITY_STORE = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.enablements.modal.store', {
  defaultMessage: 'Entity Store'
});
const EntityStoreEnablementModal = ({
  visible,
  toggle,
  enableStore,
  riskEngineStatus,
  entityStoreStatus
}) => {
  const riskEnginePrivileges = (0, _use_missing_risk_engine_privileges.useMissingRiskEnginePrivileges)();
  const {
    data: entityEnginePrivileges,
    isLoading: isLoadingEntityEnginePrivileges
  } = (0, _use_entity_engine_privileges.useEntityEnginePrivileges)();
  const hasRiskScorePrivileges = !(riskEnginePrivileges.isLoading || !(riskEnginePrivileges !== null && riskEnginePrivileges !== void 0 && riskEnginePrivileges.hasAllRequiredPrivileges));
  const canInstallRiskScore = hasRiskScorePrivileges && riskEngineStatus === _entity_analytics.RiskEngineStatusEnum.NOT_INSTALLED;
  const hasEntityStorePrivileges = !(isLoadingEntityEnginePrivileges || !(entityEnginePrivileges !== null && entityEnginePrivileges !== void 0 && entityEnginePrivileges.has_all_required));
  const canInstallEntityStore = hasEntityStorePrivileges && entityStoreStatus === 'not_installed';
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [toggleState, setToggleState] = (0, _react2.useState)({
    riskScore: false,
    entityStore: false
  });

  /**
   * Update the toggle state when the install status changes because privileges are async.
   * We automatically toggle the switch when the user can enable the engine.
   *
   */
  (0, _react2.useEffect)(() => {
    setToggleState({
      riskScore: canInstallRiskScore,
      entityStore: canInstallEntityStore
    });
  }, [canInstallRiskScore, canInstallEntityStore]);
  const isInstallButtonDisabled = !isInstallButtonEnabled(canInstallRiskScore, canInstallEntityStore, toggleState);
  const {
    AdditionalChargesMessage
  } = (0, _use_contract_component.useContractComponents)();
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  if (!visible) {
    return null;
  }
  const proceedWarning = /*#__PURE__*/_react2.default.createElement(_eui.EuiCallOut, {
    size: "s",
    color: "danger",
    css: (0, _react.css)`
        border-radius: ${euiTheme.border.radius.medium};
      `
  }, /*#__PURE__*/_react2.default.createElement("p", null, _translations.ENABLEMENT_WARNING_SELECT_TO_PROCEED));
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiModal, {
    onClose: () => toggle(false),
    "aria-labelledby": modalTitleId,
    "data-test-subj": "entityStoreEnablementModal"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.enablements.modal.title",
    defaultMessage: "Entity Analytics Enablement"
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, AdditionalChargesMessage && /*#__PURE__*/_react2.default.createElement(AdditionalChargesMessage, null)), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.enablements.modal.risk",
      defaultMessage: "Risk Score"
    }),
    checked: toggleState.riskScore,
    disabled: !canInstallRiskScore,
    onChange: () => setToggleState(prev => ({
      ...prev,
      riskScore: !prev.riskScore
    })),
    "data-test-subj": "enablementRiskScoreSwitch"
  })), !riskEnginePrivileges.isLoading && !riskEnginePrivileges.hasAllRequiredPrivileges && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_risk_engine_privileges_callout.RiskEnginePrivilegesCallOut, {
    privileges: riskEnginePrivileges
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, null, _translations.ENABLEMENT_DESCRIPTION_RISK_ENGINE_ONLY)), /*#__PURE__*/_react2.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSwitch, {
    label: ENTITY_STORE,
    checked: toggleState.entityStore,
    disabled: !canInstallEntityStore,
    onChange: () => setToggleState(prev => ({
      ...prev,
      entityStore: !prev.entityStore
    })),
    "data-test-subj": "enablementEntityStoreSwitch"
  }))), !entityEnginePrivileges || entityEnginePrivileges.has_all_required ? null : /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_entity_store_missing_privileges_callout.EntityStoreMissingPrivilegesCallout, {
    privileges: entityEnginePrivileges
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, null, _translations.ENABLEMENT_DESCRIPTION_ENTITY_STORE_ONLY)))), /*#__PURE__*/_react2.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center"
  }, isInstallButtonDisabled && (canInstallRiskScore || canInstallEntityStore) ? /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, proceedWarning) : null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => toggle(false)
  }, 'Cancel'), /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    onClick: enableStore(toggleState),
    fill: true,
    isDisabled: isInstallButtonDisabled,
    "aria-disabled": isInstallButtonDisabled,
    "data-test-subj": "entityStoreEnablementModalButton"
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.enablements.modal.enable",
    defaultMessage: "Enable"
  })))))));
};
exports.EntityStoreEnablementModal = EntityStoreEnablementModal;