"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateAlertStatus = void 0;
var _api = require("../../../../detections/containers/detection_engine/alerts/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Update alert status by query or signalIds.
 *  Either query or signalIds must be provided
 * `signalIds` is the preferred way to update alerts because it is more cost effective on Serverless.
 *
 * @param status to update to('open' / 'closed' / 'acknowledged')
 * @param index index to be updated
 * @param query optional query object to update alerts by query.
 * @param signalIds optional signalIds to update alerts by signalIds.
 * @param signal to cancel request
 *
 * @throws An error if response is not OK
 */
const updateAlertStatus = ({
  status,
  query,
  signalIds,
  signal
}) => {
  if (signalIds && signalIds.length > 0) {
    return (0, _api.updateAlertStatusByIds)({
      status,
      signalIds,
      signal
    }).then(({
      updated
    }) => ({
      updated: updated !== null && updated !== void 0 ? updated : 0,
      version_conflicts: 0
    }));
  } else if (query) {
    return (0, _api.updateAlertStatusByQuery)({
      status,
      query,
      signal
    }).then(({
      updated,
      version_conflicts: conflicts
    }) => ({
      updated: updated !== null && updated !== void 0 ? updated : 0,
      version_conflicts: conflicts
    }));
  }
  throw new Error('Either query or signalIds must be provided');
};
exports.updateAlertStatus = updateAlertStatus;