"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMLRuleConfig = void 0;
var _use_rule_fields = require("../../../../detection_engine/rule_management/logic/use_rule_fields");
var _use_ml_capabilities = require("./use_ml_capabilities");
var _use_ml_rule_validations = require("./use_ml_rule_validations");
var _has_ml_admin_permissions = require("../../../../../common/machine_learning/has_ml_admin_permissions");
var _has_ml_license = require("../../../../../common/machine_learning/has_ml_license");
var _use_terms_aggregation_fields = require("../../../hooks/use_terms_aggregation_fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This hook is used to retrieve the various configurations and status needed for creating/editing an ML Rule in the Detection Engine UI. It composes several other ML hooks.
 *
 * @param machineLearningJobId The ID(s) of the ML job to retrieve the configuration for
 *
 * @returns {UseMlRuleConfigReturn} An object containing the various configurations and statuses needed for creating/editing an ML Rule
 *
 */
const useMLRuleConfig = ({
  machineLearningJobId
}) => {
  const mlCapabilities = (0, _use_ml_capabilities.useMlCapabilities)();
  const {
    loading: validationsLoading,
    allJobsStarted
  } = (0, _use_ml_rule_validations.useMlRuleValidations)({
    machineLearningJobId
  });
  const {
    loading: mlFieldsLoading,
    fields: mlFields
  } = (0, _use_rule_fields.useRuleFields)({
    machineLearningJobId
  });
  const mlSuppressionFields = (0, _use_terms_aggregation_fields.useTermsAggregationFields)(mlFields);
  return {
    hasMlAdminPermissions: (0, _has_ml_admin_permissions.hasMlAdminPermissions)(mlCapabilities),
    hasMlLicense: (0, _has_ml_license.hasMlLicense)(mlCapabilities),
    mlFields,
    loading: validationsLoading || mlFieldsLoading,
    mlSuppressionFields,
    allJobsStarted
  };
};
exports.useMLRuleConfig = useMLRuleConfig;